/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.params.HttpParams;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;

public class KeycloakSPNegoSchemeFactory
extends SPNegoSchemeFactory {
    private final CommonKerberosConfig kerberosConfig;
    private String username;
    private String password;

    public KeycloakSPNegoSchemeFactory(CommonKerberosConfig kerberosConfig) {
        super(true, false);
        this.kerberosConfig = kerberosConfig;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public AuthScheme newInstance(HttpParams params) {
        return new KeycloakSPNegoScheme(this.isStripPort(), this.isUseCanonicalHostname());
    }

    public class KeycloakSPNegoScheme
    extends SPNegoScheme {
        public KeycloakSPNegoScheme(boolean stripPort, boolean useCanonicalHostname) {
            super(stripPort, useCanonicalHostname);
        }

        protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
            KerberosUsernamePasswordAuthenticator authenticator = new KerberosUsernamePasswordAuthenticator(KeycloakSPNegoSchemeFactory.this.kerberosConfig){

                protected String getKerberosPrincipal(String username) throws LoginException {
                    if (username.contains("@")) {
                        return username;
                    }
                    return username + "@" + this.config.getKerberosRealm();
                }
            };
            try {
                Subject clientSubject = authenticator.authenticateSubject(KeycloakSPNegoSchemeFactory.this.username, KeycloakSPNegoSchemeFactory.this.password);
                ByteArrayHolder holder = Subject.doAs(clientSubject, new ClientAcceptSecContext(input, oid, authServer));
                byte[] byArray = holder.bytes;
                return byArray;
            }
            catch (Exception le) {
                throw new RuntimeException(le);
            }
            finally {
                authenticator.logoutSubject();
            }
        }

        private class ByteArrayHolder {
            private byte[] bytes;

            private ByteArrayHolder() {
            }

            static /* synthetic */ byte[] access$302(ByteArrayHolder x0, byte[] x1) {
                x0.bytes = x1;
                return x1;
            }
        }

        private class ClientAcceptSecContext
        implements PrivilegedExceptionAction<ByteArrayHolder> {
            private final byte[] input;
            private final Oid oid;
            private final String authServer;

            public ClientAcceptSecContext(byte[] input, Oid oid, String authServer) {
                this.input = input;
                this.oid = oid;
                this.authServer = authServer;
            }

            @Override
            public ByteArrayHolder run() throws Exception {
                byte[] token = this.input;
                if (token == null) {
                    token = new byte[]{};
                }
                GSSManager manager = KeycloakSPNegoScheme.this.getManager();
                String httPrincipal = KeycloakSPNegoSchemeFactory.this.kerberosConfig.getServerPrincipal().replaceFirst("/.*@", "/" + this.authServer + "@");
                GSSName serverName = manager.createName(httPrincipal, null);
                GSSContext gssContext = manager.createContext(serverName.canonicalize(this.oid), this.oid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
                byte[] outputToken = gssContext.initSecContext(token, 0, token.length);
                ByteArrayHolder result = new ByteArrayHolder();
                ByteArrayHolder.access$302(result, outputToken);
                return result;
            }
        }
    }
}

