/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosTest;
import org.keycloak.testsuite.util.KerberosRule;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class KerberosStandaloneCrossRealmTrustTest
extends AbstractKerberosTest {
    private static final String PROVIDER_CONFIG_LOCATION = "classpath:kerberos/kerberos-standalone-connection.properties";
    @ClassRule
    public static KerberosRule kerberosRule = new KerberosRule("classpath:kerberos/kerberos-standalone-connection.properties", "KEYCLOAK.ORG");
    @ClassRule
    public static KerberosRule kerberosRule2 = new KerberosRule("classpath:kerberos/kerberos-standalone-connection.properties", "KC2.COM");

    @Override
    protected KerberosRule getKerberosRule() {
        return kerberosRule;
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig() {
        return new KerberosConfig(this.getUserStorageConfiguration());
    }

    @Override
    protected ComponentRepresentation getUserStorageConfiguration() {
        return this.getUserStorageConfiguration("kerberos-standalone", "kerberos");
    }

    @Test
    public void test01spnegoLoginSameRealmTest() throws Exception {
        this.assertSuccessfulSpnegoLogin("hnelson", "hnelson", "secret");
        this.assertUser("hnelson", "hnelson@keycloak.org", null, null, false);
    }

    @Test
    public void test02spnegoLoginDifferentRealmTest() throws Exception {
        this.assertSuccessfulSpnegoLogin("hnelson2@KC2.COM", "hnelson2", "secret");
        this.assertUser("hnelson2", "hnelson2@keycloak.org", null, null, false);
    }
}

