/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import javax.ws.rs.core.Response;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosTest;
import org.keycloak.testsuite.util.KerberosRule;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class KerberosLdapCrossRealmTrustTest
extends AbstractKerberosTest {
    private static final String PROVIDER_CONFIG_LOCATION = "classpath:kerberos/kerberos-ldap-crt-connection.properties";
    @ClassRule
    public static KerberosRule kerberosRule = new KerberosRule("classpath:kerberos/kerberos-ldap-crt-connection.properties", "KEYCLOAK.ORG");
    @ClassRule
    public static KerberosRule kerberosRule2 = new KerberosRule("classpath:kerberos/kerberos-ldap-crt-connection.properties", "KC2.COM");

    @Override
    protected KerberosRule getKerberosRule() {
        return kerberosRule;
    }

    @Override
    protected CommonKerberosConfig getKerberosConfig() {
        return new LDAPProviderKerberosConfig(this.getUserStorageConfiguration());
    }

    @Override
    protected ComponentRepresentation getUserStorageConfiguration() {
        return this.getUserStorageConfiguration("kerberos-ldap", "ldap");
    }

    @Test
    public void test01SpnegoLoginCRTSuccess() throws Exception {
        AccessToken token = this.assertSuccessfulSpnegoLogin("hnelson2@KC2.COM", "hnelson2", "secret");
        Assert.assertEquals((Object)token.getEmail(), (Object)"hnelson2@kc2.com");
        this.assertUser("hnelson2", "hnelson2@kc2.com", "Horatio", "Nelson", false);
    }

    @Test
    public void test02DisableTrust() throws Exception {
        this.testingClient.testing().ldap("test").removeLDAPUser("krbtgt2");
        try {
            Response spnegoResponse = this.spnegoLogin("hnelson2@KC2.COM", "secret");
            Assert.fail((String)"Not expected to successfully login");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

