/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.kerberos;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.ietf.jgss.GSSCredential;
import org.junit.Assume;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KerberosSerializationUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosTest;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public abstract class AbstractKerberosSingleRealmTest
extends AbstractKerberosTest {
    @Test
    public void spnegoNotAvailableTest() throws Exception {
        this.initHttpClient(false);
        String kcLoginPageLocation = this.oauth.getLoginFormUrl();
        Response response = this.client.target(kcLoginPageLocation).request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((Object)"Negotiate", (Object)response.getHeaderString("WWW-Authenticate"));
        String responseText = (String)response.readEntity(String.class);
        response.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void spnegoWithInvalidTokenTest() throws Exception {
        this.initHttpClient(true);
        AtomicReference origKeytab = new AtomicReference();
        this.updateUserStorageProvider(kerberosProviderRep -> {
            String keytab = (String)kerberosProviderRep.getConfig().getFirst((Object)"keyTab");
            origKeytab.set(keytab);
            kerberosProviderRep.getConfig().putSingle((Object)"keyTab", (Object)(keytab + "-invalid"));
        });
        try {
            Response spnegoResponse = this.spnegoLogin("hnelson", "secret");
            Assert.assertEquals((long)200L, (long)spnegoResponse.getStatus());
            String context = (String)spnegoResponse.readEntity(String.class);
            spnegoResponse.close();
            org.junit.Assert.assertTrue((boolean)context.contains("Sign in to test"));
            this.events.clear();
        }
        finally {
            this.updateUserStorageProvider(kerberosProviderRep -> kerberosProviderRep.getConfig().putSingle((Object)"keyTab", origKeytab.get()));
        }
    }

    @Test
    public void spnegoLoginWithRequiredKerberosAuthExecutionTest() {
        AuthenticationExecutionModel.Requirement oldRequirement = this.updateKerberosAuthExecutionRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        Response response = this.spnegoLogin("hnelson", "secret");
        this.updateKerberosAuthExecutionRequirement(oldRequirement);
        Assert.assertEquals((long)302L, (long)response.getStatus());
    }

    @Test
    public void spnegoCaseInsensitiveTest() throws Exception {
        this.assertSuccessfulSpnegoLogin(this.getKerberosRule().isCaseSensitiveLogin() ? "MyDuke" : "myduke", "myduke", "theduke");
    }

    @Test
    public void usernamePasswordLoginTest() throws Exception {
        this.updateProviderEditMode(UserStorageProvider.EditMode.READ_ONLY);
        this.changePasswordPage.open();
        this.loginPage.assertCurrent();
        this.loginPage.login("jduke", "theduke");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.changePassword("theduke-invalid", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Invalid existing password."));
        this.changePasswordPage.changePassword("theduke", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("You can't update your password as your account is read-only"));
        this.updateProviderEditMode(UserStorageProvider.EditMode.UNSYNCED);
        this.changePasswordPage.changePassword("theduke", "newPass", "newPass");
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Your password has been updated."));
        this.changePasswordPage.logout();
        this.loginPage.login("jduke", "theduke");
        this.loginPage.assertCurrent();
        this.loginPage.login("jduke", "newPass");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.logout();
        this.events.clear();
        Response spnegoResponse = this.spnegoLogin("jduke", "theduke");
        Assert.assertEquals((long)302L, (long)spnegoResponse.getStatus());
        List users = this.testRealmResource().users().search("jduke", Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.events.expectLogin().client("kerberos-app").user(userId).detail("username", "jduke").assertEvent();
        String codeUrl = spnegoResponse.getLocation().toString();
        this.assertAuthenticationSuccess(codeUrl);
    }

    @Test
    public void credentialDelegationTest() throws Exception {
        Assume.assumeTrue((String)"Ignoring test as the embedded server is not started", (boolean)this.getKerberosRule().isStartEmbeddedLdapServer());
        ProtocolMapperModel protocolMapper = UserSessionNoteMapper.createClaimMapper((String)"gss delegation credential", (String)"gss_delegation_credential", (String)"gss_delegation_credential", (String)"String", (boolean)true, (boolean)false);
        ProtocolMapperRepresentation protocolMapperRep = ModelToRepresentation.toRepresentation((ProtocolMapperModel)protocolMapper);
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.testRealmResource(), (String)"kerberos-app");
        Response response = clientResource.getProtocolMappers().createMapper(protocolMapperRep);
        String protocolMapperId = ApiUtil.getCreatedId((Response)response);
        response.close();
        AccessToken token = this.assertSuccessfulSpnegoLogin("hnelson", "hnelson", "secret");
        String serializedGssCredential = (String)token.getOtherClaims().get("gss_delegation_credential");
        Assert.assertNotNull((Object)serializedGssCredential);
        GSSCredential gssCredential = KerberosSerializationUtils.deserializeCredential((String)serializedGssCredential);
        String ldapResponse = this.invokeLdap(gssCredential, token.getPreferredUsername());
        Assert.assertEquals((Object)"Horatio Nelson", (Object)ldapResponse);
        this.oauth.openLogout();
        clientResource.getProtocolMappers().delete(protocolMapperId);
        token = this.assertSuccessfulSpnegoLogin("hnelson", "hnelson", "secret");
        Assert.assertFalse((boolean)token.getOtherClaims().containsKey("gss_delegation_credential"));
        this.events.clear();
    }
}

