/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.exportimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.models.credential.dto.PasswordCredentialData;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.util.JsonSerialization;

public class ExportImportUtil {
    public static void assertDataImportedInRealm(Keycloak adminClient, KeycloakTestingClient testingClient, RealmRepresentation realm) throws IOException {
        org.junit.Assert.assertTrue((boolean)realm.isVerifyEmail());
        org.junit.Assert.assertEquals((Object)3600000, (Object)realm.getOfflineSessionIdleTimeout());
        org.junit.Assert.assertEquals((Object)1500, (Object)realm.getAccessTokenLifespanForImplicitFlow());
        org.junit.Assert.assertEquals((Object)1800, (Object)realm.getSsoSessionIdleTimeout());
        org.junit.Assert.assertEquals((Object)36000, (Object)realm.getSsoSessionMaxLifespan());
        org.junit.Assert.assertEquals((Object)3600, (Object)realm.getSsoSessionIdleTimeoutRememberMe());
        org.junit.Assert.assertEquals((Object)172800, (Object)realm.getSsoSessionMaxLifespanRememberMe());
        Set creds = realm.getRequiredCredentials();
        org.junit.Assert.assertEquals((long)1L, (long)creds.size());
        String cred = (String)creds.iterator().next();
        org.junit.Assert.assertEquals((Object)"password", (Object)cred);
        RealmResource realmRsc = adminClient.realm(realm.getRealm());
        UserRepresentation user = ExportImportUtil.findByUsername(realmRsc, "loginclient");
        org.junit.Assert.assertNotNull((Object)user);
        UserResource userRsc = realmRsc.users().get(user.getId());
        org.junit.Assert.assertEquals((long)0L, (long)userRsc.getFederatedIdentity().size());
        List resources = realmRsc.clients().findAll();
        org.junit.Assert.assertEquals((long)10L, (long)resources.size());
        ClientRepresentation application = ApiUtil.findClientByClientId((RealmResource)realmRsc, (String)"Application").toRepresentation();
        ClientRepresentation otherApp = ApiUtil.findClientByClientId((RealmResource)realmRsc, (String)"OtherApp").toRepresentation();
        ClientRepresentation accountApp = ApiUtil.findClientByClientId((RealmResource)realmRsc, (String)"account").toRepresentation();
        ClientRepresentation testAppAuthzApp = ApiUtil.findClientByClientId((RealmResource)realmRsc, (String)"test-app-authz").toRepresentation();
        ClientResource nonExisting = ApiUtil.findClientByClientId((RealmResource)realmRsc, (String)"NonExisting");
        org.junit.Assert.assertNotNull((Object)application);
        org.junit.Assert.assertNotNull((Object)otherApp);
        org.junit.Assert.assertNull((Object)nonExisting);
        List clients = realmRsc.clients().findAll();
        org.junit.Assert.assertEquals((long)10L, (long)clients.size());
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, application));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, otherApp));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.hasClient(clients, accountApp));
        org.junit.Assert.assertEquals((Object)"Applicationn", (Object)application.getName());
        org.junit.Assert.assertEquals((Object)50, (Object)application.getNodeReRegistrationTimeout());
        Map appRegisteredNodes = application.getRegisteredNodes();
        org.junit.Assert.assertEquals((long)2L, (long)appRegisteredNodes.size());
        org.junit.Assert.assertTrue((10 == (Integer)appRegisteredNodes.get("node1") ? 1 : 0) != 0);
        org.junit.Assert.assertTrue((20 == (Integer)appRegisteredNodes.get("172.10.15.20") ? 1 : 0) != 0);
        org.junit.Assert.assertEquals((Object)"client-secret", (Object)application.getClientAuthenticatorType());
        org.junit.Assert.assertEquals((Object)"client-jwt", (Object)otherApp.getClientAuthenticatorType());
        Map flowMap = otherApp.getAuthenticationFlowBindingOverrides();
        org.junit.Assert.assertNotNull((Object)flowMap);
        org.junit.Assert.assertEquals((long)1L, (long)flowMap.size());
        org.junit.Assert.assertTrue((boolean)flowMap.containsKey("browser"));
        AuthenticationFlowRepresentation flowRep = realmRsc.flows().getFlow((String)flowMap.get("browser"));
        org.junit.Assert.assertNotNull((Object)flowRep);
        org.junit.Assert.assertEquals((Object)"browser", (Object)flowRep.getAlias());
        org.junit.Assert.assertNull((Object)ApiUtil.findClientResourceById((RealmResource)realmRsc, (String)"982734"));
        org.junit.Assert.assertEquals((Object)application.getId(), (Object)ApiUtil.findClientResourceById((RealmResource)realmRsc, (String)application.getId()).toRepresentation().getId());
        UserRepresentation admin = ExportImportUtil.findByUsername(realmRsc, "admin");
        org.junit.Assert.assertNull((Object)admin.getCreatedTimestamp());
        Set<RoleRepresentation> allRoles = ExportImportUtil.allRoles(realmRsc, admin);
        org.junit.Assert.assertEquals((long)3L, (long)allRoles.size());
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-admin")));
        UserRepresentation wburke = ExportImportUtil.findByUsername(realmRsc, "wburke");
        org.junit.Assert.assertEquals((Object)new Long(123654L), (Object)wburke.getCreatedTimestamp());
        allRoles = ExportImportUtil.allRoles(realmRsc, wburke);
        org.junit.Assert.assertEquals((long)2L, (long)allRoles.size());
        org.junit.Assert.assertFalse((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-user")));
        org.junit.Assert.assertNull((Object)realmRsc.users().get(wburke.getId()).roles().getAll().getRealmMappings());
        org.junit.Assert.assertEquals((Object)159, (Object)wburke.getNotBefore());
        UserRepresentation loginclient = ExportImportUtil.findByUsername(realmRsc, "loginclient");
        org.junit.Assert.assertEquals((Object)new Long(123655L), (Object)loginclient.getCreatedTimestamp());
        UserRepresentation hashedPasswordUser = ExportImportUtil.findByUsername(realmRsc, "hashedpassworduser");
        CredentialRepresentation password = realmRsc.users().get(hashedPasswordUser.getId()).credentials().stream().filter(credential -> "password".equals(credential.getType())).findFirst().get();
        PasswordCredentialData credentialData = (PasswordCredentialData)JsonSerialization.readValue((String)password.getCredentialData(), PasswordCredentialData.class);
        org.junit.Assert.assertEquals((long)1234L, (long)credentialData.getHashIterations());
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmRolesForUser(realmRsc, admin);
        org.junit.Assert.assertEquals((long)1L, (long)realmRoles.size());
        org.junit.Assert.assertEquals((Object)"admin", (Object)realmRoles.iterator().next().getName());
        List<RoleRepresentation> appRoles = ExportImportUtil.clientRolesForUser(realmRsc, application, admin);
        org.junit.Assert.assertEquals((long)1L, (long)appRoles.size());
        org.junit.Assert.assertEquals((Object)"app-admin", (Object)appRoles.iterator().next().getName());
        Map attrs = wburke.getAttributes();
        org.junit.Assert.assertEquals((long)1L, (long)attrs.size());
        List attrVals = (List)attrs.get("old-email");
        org.junit.Assert.assertEquals((long)1L, (long)attrVals.size());
        org.junit.Assert.assertEquals((Object)"bburke@redhat.com", attrVals.get(0));
        attrs = admin.getAttributes();
        org.junit.Assert.assertEquals((long)2L, (long)attrs.size());
        attrVals = (List)attrs.get("key1");
        org.junit.Assert.assertEquals((long)1L, (long)attrVals.size());
        org.junit.Assert.assertEquals((Object)"val1", attrVals.get(0));
        attrVals = (List)attrs.get("key2");
        org.junit.Assert.assertEquals((long)2L, (long)attrVals.size());
        org.junit.Assert.assertTrue((attrVals.contains("val21") && attrVals.contains("val22") ? 1 : 0) != 0);
        ClientResource oauthClient = ApiUtil.findClientResourceByClientId((RealmResource)realmRsc, (String)"oauthclient");
        ClientRepresentation oauthClientRep = oauthClient.toRepresentation();
        org.junit.Assert.assertEquals((Object)"clientpassword", (Object)oauthClient.getSecret().getValue());
        org.junit.Assert.assertTrue((boolean)oauthClientRep.isEnabled());
        org.junit.Assert.assertNotNull((Object)oauthClientRep);
        Set<RoleRepresentation> allScopes = ExportImportUtil.allScopeMappings(oauthClient);
        org.junit.Assert.assertEquals((long)2L, (long)allScopes.size());
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        List<RoleRepresentation> realmScopes = ExportImportUtil.realmScopeMappings(oauthClient);
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(realmScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        List<RoleRepresentation> appScopes = ExportImportUtil.clientScopeMappings(oauthClient);
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(appScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        UserResource socialUser = realmRsc.users().get(ExportImportUtil.findByUsername(realmRsc, "mySocialUser").getId());
        List socialLinks = socialUser.getFederatedIdentity();
        org.junit.Assert.assertEquals((long)3L, (long)socialLinks.size());
        boolean facebookFound = false;
        boolean googleFound = false;
        boolean twitterFound = false;
        FederatedIdentityRepresentation facebookIdentityRep = null;
        for (FederatedIdentityRepresentation federatedIdentityRep : socialLinks) {
            if ("facebook1".equals(federatedIdentityRep.getIdentityProvider())) {
                facebookFound = true;
                facebookIdentityRep = federatedIdentityRep;
                org.junit.Assert.assertEquals((Object)"facebook1", (Object)federatedIdentityRep.getUserId());
                org.junit.Assert.assertEquals((Object)"fbuser1", (Object)federatedIdentityRep.getUserName());
                continue;
            }
            if ("google1".equals(federatedIdentityRep.getIdentityProvider())) {
                googleFound = true;
                org.junit.Assert.assertEquals((Object)"google1", (Object)federatedIdentityRep.getUserId());
                org.junit.Assert.assertEquals((Object)"mysocialuser@gmail.com", (Object)federatedIdentityRep.getUserName());
                continue;
            }
            if (!"twitter1".equals(federatedIdentityRep.getIdentityProvider())) continue;
            twitterFound = true;
            org.junit.Assert.assertEquals((Object)"twitter1", (Object)federatedIdentityRep.getUserId());
            org.junit.Assert.assertEquals((Object)"twuser1", (Object)federatedIdentityRep.getUserName());
        }
        org.junit.Assert.assertTrue((facebookFound && twitterFound && googleFound ? 1 : 0) != 0);
        UserRepresentation foundSocialUser = testingClient.testing().getUserByFederatedIdentity(realm.getRealm(), "facebook1", "facebook1", "fbuser1");
        org.junit.Assert.assertEquals((Object)foundSocialUser.getUsername(), (Object)socialUser.toRepresentation().getUsername());
        org.junit.Assert.assertNull((Object)testingClient.testing().getUserByFederatedIdentity(realm.getRealm(), "facebook", "not-existing", "not-existing"));
        org.junit.Assert.assertEquals((Object)"facebook1", (Object)facebookIdentityRep.getUserId());
        org.junit.Assert.assertEquals((Object)"fbuser1", (Object)facebookIdentityRep.getUserName());
        org.junit.Assert.assertEquals((Object)"facebook1", (Object)facebookIdentityRep.getIdentityProvider());
        socialUser.removeFederatedIdentity("facebook1");
        org.junit.Assert.assertEquals((long)2L, (long)socialUser.getFederatedIdentity().size());
        socialUser.addFederatedIdentity("facebook1", facebookIdentityRep);
        org.junit.Assert.assertEquals((long)3L, (long)socialUser.getFederatedIdentity().size());
        Map smtpConfig = realm.getSmtpServer();
        org.junit.Assert.assertTrue((smtpConfig.size() == 3 ? 1 : 0) != 0);
        org.junit.Assert.assertEquals((Object)"auto@keycloak.org", smtpConfig.get("from"));
        org.junit.Assert.assertEquals((Object)"localhost", smtpConfig.get("host"));
        org.junit.Assert.assertEquals((Object)"3025", smtpConfig.get("port"));
        List identityProviders = realm.getIdentityProviders();
        org.junit.Assert.assertEquals((long)3L, (long)identityProviders.size());
        IdentityProviderRepresentation google = null;
        for (IdentityProviderRepresentation idpRep : identityProviders) {
            if (!idpRep.getAlias().equals("google1")) continue;
            google = idpRep;
        }
        org.junit.Assert.assertNotNull(google);
        org.junit.Assert.assertEquals((Object)"google1", (Object)google.getAlias());
        org.junit.Assert.assertEquals((Object)"google", (Object)google.getProviderId());
        org.junit.Assert.assertTrue((boolean)google.isEnabled());
        org.junit.Assert.assertEquals((Object)"googleId", google.getConfig().get("clientId"));
        org.junit.Assert.assertEquals((Object)"googleSecret", google.getConfig().get("clientSecret"));
        List fedProviders = realm.getUserFederationProviders();
        org.junit.Assert.assertTrue((fedProviders == null || fedProviders.size() == 0 ? 1 : 0) != 0);
        List storageProviders = realmRsc.components().query(realm.getId(), UserStorageProvider.class.getName());
        org.junit.Assert.assertTrue((storageProviders.size() == 2 ? 1 : 0) != 0);
        ComponentRepresentation ldap1 = (ComponentRepresentation)storageProviders.get(0);
        ComponentRepresentation ldap2 = (ComponentRepresentation)storageProviders.get(1);
        if (!"MyLDAPProvider1".equals(ldap1.getName())) {
            ldap2 = ldap1;
            ldap1 = (ComponentRepresentation)storageProviders.get(1);
        }
        org.junit.Assert.assertEquals((Object)"MyLDAPProvider1", (Object)ldap1.getName());
        org.junit.Assert.assertEquals((Object)"ldap", (Object)ldap1.getProviderId());
        org.junit.Assert.assertEquals((Object)"1", (Object)ldap1.getConfig().getFirst((Object)"priority"));
        org.junit.Assert.assertEquals((Object)"ldap://foo", (Object)ldap1.getConfig().getFirst((Object)"connectionUrl"));
        org.junit.Assert.assertEquals((Object)"MyLDAPProvider2", (Object)ldap2.getName());
        org.junit.Assert.assertEquals((Object)"ldap://bar", (Object)ldap2.getConfig().getFirst((Object)"connectionUrl"));
        List fedMappers1 = realmRsc.components().query(ldap1.getId(), LDAPStorageMapper.class.getName());
        ComponentRepresentation fullNameMapper = (ComponentRepresentation)fedMappers1.iterator().next();
        org.junit.Assert.assertEquals((Object)"FullNameMapper", (Object)fullNameMapper.getName());
        org.junit.Assert.assertEquals((Object)"full-name-ldap-mapper", (Object)fullNameMapper.getProviderId());
        org.junit.Assert.assertEquals((Object)"cn", (Object)fullNameMapper.getConfig().getFirst((Object)"ldap.full.name.attribute"));
        org.junit.Assert.assertNull((Object)testingClient.testing().getUserByUsernameFromFedProviderFactory(realm.getRealm(), "wburke"));
        AuthenticationFlowRepresentation clientFlow = testingClient.testing().getClientAuthFlow(realm.getRealm());
        org.junit.Assert.assertEquals((Object)"clients", (Object)clientFlow.getAlias());
        org.junit.Assert.assertNotNull((Object)realmRsc.flows().getFlow(clientFlow.getId()));
        org.junit.Assert.assertTrue((realmRsc.flows().getExecutions(clientFlow.getAlias()).size() > 0 ? 1 : 0) != 0);
        AuthenticationFlowRepresentation resetFlow = testingClient.testing().getResetCredFlow(realm.getRealm());
        org.junit.Assert.assertEquals((Object)"reset credentials", (Object)resetFlow.getAlias());
        org.junit.Assert.assertNotNull((Object)realmRsc.flows().getFlow(resetFlow.getId()));
        org.junit.Assert.assertTrue((realmRsc.flows().getExecutions(resetFlow.getAlias()).size() > 0 ? 1 : 0) != 0);
        List applicationMappers = application.getProtocolMappers();
        org.junit.Assert.assertNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "username"));
        org.junit.Assert.assertNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "email"));
        org.junit.Assert.assertNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "given name"));
        org.junit.Assert.assertNull((Object)ExportImportUtil.findMapperByName(applicationMappers, "openid-connect", "gss delegation credential"));
        org.junit.Assert.assertEquals((long)1L, (long)otherApp.getProtocolMappers().size());
        List otherAppMappers = otherApp.getProtocolMappers();
        org.junit.Assert.assertNull((Object)ExportImportUtil.findMapperByName(otherAppMappers, "openid-connect", "username"));
        ProtocolMapperRepresentation gssCredentialMapper = ExportImportUtil.findMapperByName(otherAppMappers, "openid-connect", "gss delegation credential");
        ExportImportUtil.assertGssProtocolMapper(gssCredentialMapper);
        List clientScopes = realmRsc.clientScopes().findAll();
        ClientScopeRepresentation clientScope = clientScopes.stream().filter(clientScope1 -> "foo_scope".equals(clientScope1.getName())).findFirst().get();
        org.junit.Assert.assertEquals((Object)"foo_scope", (Object)clientScope.getName());
        org.junit.Assert.assertEquals((Object)"foo scope-desc", (Object)clientScope.getDescription());
        org.junit.Assert.assertEquals((Object)"openid-connect", (Object)clientScope.getProtocol());
        org.junit.Assert.assertEquals((long)1L, (long)clientScope.getProtocolMappers().size());
        List clientScopeMappers = clientScope.getProtocolMappers();
        ProtocolMapperRepresentation scopeGssCredentialMapper = ExportImportUtil.findMapperByName(clientScopeMappers, "openid-connect", "gss delegation credential");
        ExportImportUtil.assertGssProtocolMapper(scopeGssCredentialMapper);
        Set<RoleRepresentation> allClientScopeScopes = ExportImportUtil.allScopeMappings(realmRsc.clientScopes().get(clientScope.getId()));
        org.junit.Assert.assertEquals((long)3L, (long)allClientScopeScopes.size());
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientScopeScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientScopeScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allClientScopeScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        List<RoleRepresentation> clientScopeRealmScopes = ExportImportUtil.realmScopeMappings(realmRsc.clientScopes().get(clientScope.getId()));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientScopeRealmScopes, ExportImportUtil.findRealmRole(realmRsc, "admin")));
        List<RoleRepresentation> clientScopeAppScopes = ExportImportUtil.clientScopeMappings(realmRsc.clientScopes().get(clientScope.getId()));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientScopeAppScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-user")));
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(clientScopeAppScopes, ExportImportUtil.findClientRole(realmRsc, application.getId(), "app-admin")));
        org.junit.Assert.assertTrue((boolean)otherApp.getDefaultClientScopes().contains("foo_scope"));
        org.junit.Assert.assertFalse((boolean)application.getDefaultClientScopes().contains("foo_scope"));
        ExportImportUtil.testRealmDefaultClientScopes(realmRsc);
        UserResource adminRsc = realmRsc.users().get(admin.getId());
        List consents = adminRsc.getConsents();
        org.junit.Assert.assertEquals((long)2L, (long)consents.size());
        Map<String, Object> appAdminConsent = ExportImportUtil.findConsentByClientId(consents, application.getClientId());
        org.junit.Assert.assertNotNull(appAdminConsent);
        org.junit.Assert.assertTrue((boolean)ExportImportUtil.isClientScopeGranted(appAdminConsent, "offline_access", "roles", "profile", "email", "account", "web-origins"));
        Map<String, Object> otherAppAdminConsent = ExportImportUtil.findConsentByClientId(consents, otherApp.getClientId());
        org.junit.Assert.assertFalse((boolean)ExportImportUtil.isClientScopeGranted(otherAppAdminConsent, "offline_access"));
        org.junit.Assert.assertTrue((boolean)application.isStandardFlowEnabled());
        org.junit.Assert.assertTrue((boolean)application.isImplicitFlowEnabled());
        org.junit.Assert.assertTrue((boolean)application.isDirectAccessGrantsEnabled());
        org.junit.Assert.assertFalse((boolean)otherApp.isStandardFlowEnabled());
        org.junit.Assert.assertFalse((boolean)otherApp.isImplicitFlowEnabled());
        org.junit.Assert.assertFalse((boolean)otherApp.isDirectAccessGrantsEnabled());
        org.junit.Assert.assertFalse((boolean)application.isServiceAccountsEnabled());
        org.junit.Assert.assertTrue((boolean)otherApp.isServiceAccountsEnabled());
        if (ProfileAssume.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
            org.junit.Assert.assertTrue((boolean)testAppAuthzApp.isServiceAccountsEnabled());
            org.junit.Assert.assertNull((Object)testingClient.testing().getUserByServiceAccountClient(realm.getRealm(), application.getClientId()));
            UserRepresentation otherAppSA = testingClient.testing().getUserByServiceAccountClient(realm.getRealm(), otherApp.getClientId());
            org.junit.Assert.assertNotNull((Object)otherAppSA);
            org.junit.Assert.assertEquals((Object)"service-account-otherapp", (Object)otherAppSA.getUsername());
            UserRepresentation testAppAuthzSA = testingClient.testing().getUserByServiceAccountClient(realm.getRealm(), testAppAuthzApp.getClientId());
            org.junit.Assert.assertNotNull((Object)testAppAuthzSA);
            org.junit.Assert.assertEquals((Object)"service-account-test-app-authz", (Object)testAppAuthzSA.getUsername());
            allRoles = ExportImportUtil.allRoles(realmRsc, otherAppSA);
            org.junit.Assert.assertEquals((long)3L, (long)allRoles.size());
            org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findRealmRole(realmRsc, "user")));
            org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-user")));
            org.junit.Assert.assertTrue((boolean)ExportImportUtil.containsRole(allRoles, ExportImportUtil.findClientRole(realmRsc, otherApp.getId(), "otherapp-admin")));
            ExportImportUtil.assertAuthorizationSettingsOtherApp(realmRsc);
            ExportImportUtil.assertAuthorizationSettingsTestAppAuthz(realmRsc);
        }
    }

    private static boolean isClientScopeGranted(Map<String, Object> consent, String ... clientScopeNames) {
        if (consent.get("grantedClientScopes") == null) {
            return false;
        }
        return ((List)consent.get("grantedClientScopes")).containsAll(Arrays.asList(clientScopeNames));
    }

    private static Map<String, Object> findConsentByClientId(List<Map<String, Object>> consents, String clientId) {
        for (Map<String, Object> consent : consents) {
            if (!clientId.equals(consent.get("clientId"))) continue;
            return consent;
        }
        return null;
    }

    private static void assertGssProtocolMapper(ProtocolMapperRepresentation gssCredentialMapper) {
        org.junit.Assert.assertEquals((Object)"gss delegation credential", (Object)gssCredentialMapper.getName());
        org.junit.Assert.assertEquals((Object)"openid-connect", (Object)gssCredentialMapper.getProtocol());
        org.junit.Assert.assertEquals((Object)"oidc-usersessionmodel-note-mapper", (Object)gssCredentialMapper.getProtocolMapper());
        String includeInAccessToken = (String)gssCredentialMapper.getConfig().get("access.token.claim");
        String includeInIdToken = (String)gssCredentialMapper.getConfig().get("id.token.claim");
        org.junit.Assert.assertTrue((boolean)includeInAccessToken.equalsIgnoreCase("true"));
        org.junit.Assert.assertTrue((includeInIdToken == null || !Boolean.parseBoolean(includeInIdToken) ? 1 : 0) != 0);
    }

    private static ProtocolMapperRepresentation findMapperByName(List<ProtocolMapperRepresentation> mappers, String type, String name) {
        if (mappers == null) {
            return null;
        }
        for (ProtocolMapperRepresentation mapper : mappers) {
            if (!mapper.getProtocol().equals(type) || !mapper.getName().equals(name)) continue;
            return mapper;
        }
        return null;
    }

    private static boolean hasClient(List<ClientRepresentation> clients, ClientRepresentation client) {
        for (ClientRepresentation clientRep : clients) {
            if (!client.getId().equals(clientRep.getId())) continue;
            return true;
        }
        return false;
    }

    private static UserRepresentation findByUsername(RealmResource realmRsc, String username) {
        for (UserRepresentation user : realmRsc.users().search(null, Integer.valueOf(0), Integer.valueOf(-1))) {
            if (!user.getUsername().equalsIgnoreCase(username)) continue;
            return user;
        }
        return null;
    }

    private static Set<RoleRepresentation> allScopeMappings(ClientResource client) {
        HashSet<RoleRepresentation> allRoles = new HashSet<RoleRepresentation>();
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmScopeMappings(client);
        if (realmRoles != null) {
            allRoles.addAll(realmRoles);
        }
        allRoles.addAll(ExportImportUtil.clientScopeMappings(client));
        return allRoles;
    }

    private static Set<RoleRepresentation> allScopeMappings(ClientScopeResource client) {
        HashSet<RoleRepresentation> allRoles = new HashSet<RoleRepresentation>();
        List<RoleRepresentation> realmRoles = ExportImportUtil.realmScopeMappings(client);
        if (realmRoles != null) {
            allRoles.addAll(realmRoles);
        }
        allRoles.addAll(ExportImportUtil.clientScopeMappings(client));
        return allRoles;
    }

    private static List<RoleRepresentation> clientScopeMappings(ClientResource client) {
        LinkedList<RoleRepresentation> clientScopeMappings = new LinkedList<RoleRepresentation>();
        Map clientRoles = client.getScopeMappings().getAll().getClientMappings();
        if (clientRoles == null) {
            return clientScopeMappings;
        }
        for (String clientKey : clientRoles.keySet()) {
            List clientRoleScopeMappings = ((ClientMappingsRepresentation)clientRoles.get(clientKey)).getMappings();
            if (clientRoleScopeMappings == null) continue;
            clientScopeMappings.addAll(clientRoleScopeMappings);
        }
        return clientScopeMappings;
    }

    private static List<RoleRepresentation> clientScopeMappings(ClientScopeResource client) {
        LinkedList<RoleRepresentation> clientScopeMappings = new LinkedList<RoleRepresentation>();
        Map clientRoles = client.getScopeMappings().getAll().getClientMappings();
        if (clientRoles == null) {
            return clientScopeMappings;
        }
        for (String clientKey : clientRoles.keySet()) {
            List clientRoleScopeMappings = ((ClientMappingsRepresentation)clientRoles.get(clientKey)).getMappings();
            if (clientRoleScopeMappings == null) continue;
            clientScopeMappings.addAll(clientRoleScopeMappings);
        }
        return clientScopeMappings;
    }

    private static List<RoleRepresentation> realmScopeMappings(ClientResource client) {
        return client.getScopeMappings().realmLevel().listAll();
    }

    private static List<RoleRepresentation> realmScopeMappings(ClientScopeResource client) {
        return client.getScopeMappings().realmLevel().listAll();
    }

    private static Set<RoleRepresentation> allRoles(RealmResource realmRsc, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        HashSet<RoleRepresentation> roles = new HashSet<RoleRepresentation>();
        List realmRoles = userRsc.roles().getAll().getRealmMappings();
        if (realmRoles != null) {
            roles.addAll(realmRoles);
        }
        roles.addAll(ExportImportUtil.allClientRolesForUser(realmRsc, user));
        return roles;
    }

    private static List<RoleRepresentation> realmRolesForUser(RealmResource realmRsc, UserRepresentation user) {
        return realmRsc.users().get(user.getId()).roles().getAll().getRealmMappings();
    }

    private static List<RoleRepresentation> allClientRolesForUser(RealmResource realmRsc, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        for (String client : userRsc.roles().getAll().getClientMappings().keySet()) {
            List clientRoles = ((ClientMappingsRepresentation)userRsc.roles().getAll().getClientMappings().get(client)).getMappings();
            if (clientRoles == null) continue;
            roles.addAll(clientRoles);
        }
        return roles;
    }

    private static List<RoleRepresentation> clientRolesForUser(RealmResource realmRsc, ClientRepresentation client, UserRepresentation user) {
        UserResource userRsc = realmRsc.users().get(user.getId());
        return userRsc.roles().clientLevel(client.getId()).listAll();
    }

    private static RoleRepresentation findRealmRole(RealmResource realmRsc, String roleName) {
        return realmRsc.roles().get(roleName).toRepresentation();
    }

    private static RoleRepresentation findClientRole(RealmResource realmRsc, String clientDbId, String roleName) {
        return realmRsc.clients().get(clientDbId).roles().get(roleName).toRepresentation();
    }

    private static boolean containsRole(Collection<RoleRepresentation> roles, RoleRepresentation role) {
        for (RoleRepresentation setRole : roles) {
            if (!setRole.getId().equals(role.getId())) continue;
            return true;
        }
        return false;
    }

    private static void assertAuthorizationSettingsOtherApp(RealmResource realmRsc) {
        AuthorizationResource authzResource = ApiUtil.findAuthorizationSettings((RealmResource)realmRsc, (String)"OtherApp");
        org.junit.Assert.assertNotNull((Object)authzResource);
        List resources = authzResource.resources().resources();
        org.junit.Assert.assertThat(resources.stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Default Resource", "test"}));
        List policies = authzResource.policies().policies();
        org.junit.Assert.assertThat(policies.stream().map(AbstractPolicyRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"User Policy", "Default Permission", "test-permission"}));
    }

    private static void assertAuthorizationSettingsTestAppAuthz(RealmResource realmRsc) {
        AuthorizationResource authzResource = ApiUtil.findAuthorizationSettings((RealmResource)realmRsc, (String)"test-app-authz");
        org.junit.Assert.assertNotNull((Object)authzResource);
        List resources = authzResource.resources().resources();
        org.junit.Assert.assertEquals((long)4L, (long)resources.size());
        ResourceServerRepresentation authzSettings = authzResource.getSettings();
        ArrayList resourcePredicates = new ArrayList();
        resourcePredicates.add(resourceRep -> {
            if ("Admin Resource".equals(resourceRep.getName())) {
                org.junit.Assert.assertEquals((Object)authzSettings.getClientId(), (Object)resourceRep.getOwner().getId());
                org.junit.Assert.assertEquals((Object)"/protected/admin/*", (Object)resourceRep.getUri());
                org.junit.Assert.assertEquals((Object)"http://test-app-authz/protected/admin", (Object)resourceRep.getType());
                org.junit.Assert.assertEquals((Object)"http://icons.com/icon-admin", (Object)resourceRep.getIconUri());
                org.junit.Assert.assertEquals((long)1L, (long)resourceRep.getScopes().size());
                return true;
            }
            return false;
        });
        resourcePredicates.add(resourceRep -> {
            if ("Protected Resource".equals(resourceRep.getName())) {
                org.junit.Assert.assertEquals((Object)authzSettings.getClientId(), (Object)resourceRep.getOwner().getId());
                org.junit.Assert.assertEquals((Object)"/*", (Object)resourceRep.getUri());
                org.junit.Assert.assertEquals((Object)"http://test-app-authz/protected/resource", (Object)resourceRep.getType());
                org.junit.Assert.assertEquals((Object)"http://icons.com/icon-resource", (Object)resourceRep.getIconUri());
                org.junit.Assert.assertEquals((long)1L, (long)resourceRep.getScopes().size());
                return true;
            }
            return false;
        });
        resourcePredicates.add(resourceRep -> {
            if ("Premium Resource".equals(resourceRep.getName())) {
                org.junit.Assert.assertEquals((Object)authzSettings.getClientId(), (Object)resourceRep.getOwner().getId());
                org.junit.Assert.assertEquals((Object)"/protected/premium/*", (Object)resourceRep.getUri());
                org.junit.Assert.assertEquals((Object)"urn:test-app-authz:protected:resource", (Object)resourceRep.getType());
                org.junit.Assert.assertEquals((Object)"http://icons.com/icon-premium", (Object)resourceRep.getIconUri());
                org.junit.Assert.assertEquals((long)1L, (long)resourceRep.getScopes().size());
                return true;
            }
            return false;
        });
        resourcePredicates.add(resourceRep -> {
            if ("Main Page".equals(resourceRep.getName())) {
                org.junit.Assert.assertEquals((Object)authzSettings.getClientId(), (Object)resourceRep.getOwner().getId());
                org.junit.Assert.assertNull((Object)resourceRep.getUri());
                org.junit.Assert.assertEquals((Object)"urn:test-app-authz:protected:resource", (Object)resourceRep.getType());
                org.junit.Assert.assertEquals((Object)"http://icons.com/icon-main-page", (Object)resourceRep.getIconUri());
                org.junit.Assert.assertEquals((long)3L, (long)resourceRep.getScopes().size());
                return true;
            }
            return false;
        });
        ExportImportUtil.assertPredicate(resources, resourcePredicates);
        List scopes = authzResource.scopes().scopes();
        org.junit.Assert.assertEquals((long)6L, (long)scopes.size());
        ArrayList scopePredicates = new ArrayList();
        scopePredicates.add(scopeRepresentation -> "admin-access".equals(scopeRepresentation.getName()));
        scopePredicates.add(scopeRepresentation -> "resource-access".equals(scopeRepresentation.getName()));
        scopePredicates.add(scopeRepresentation -> "premium-access".equals(scopeRepresentation.getName()));
        scopePredicates.add(scopeRepresentation -> "urn:test-app-authz:page:main:actionForAdmin".equals(scopeRepresentation.getName()));
        scopePredicates.add(scopeRepresentation -> "urn:test-app-authz:page:main:actionForUser".equals(scopeRepresentation.getName()));
        scopePredicates.add(scopeRepresentation -> "urn:test-app-authz:page:main:actionForPremiumUser".equals(scopeRepresentation.getName()));
        ExportImportUtil.assertPredicate(scopes, scopePredicates);
        List policies = authzResource.policies().policies();
        org.junit.Assert.assertEquals((long)14L, (long)policies.size());
        ArrayList policyPredicates = new ArrayList();
        policyPredicates.add(policyRepresentation -> "Any Admin Policy".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Any User Policy".equals(policyRepresentation.getName()));
        policyPredicates.add(representation -> "Client and Realm Role Policy".equals(representation.getName()));
        policyPredicates.add(representation -> "Client Test Policy".equals(representation.getName()));
        policyPredicates.add(representation -> "Group Policy Test".equals(representation.getName()));
        policyPredicates.add(policyRepresentation -> "Only Premium User Policy".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "wburke policy".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "All Users Policy".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Premium Resource Permission".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Administrative Resource Permission".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Protected Resource Permission".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Action 1 on Main Page Resource Permission".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Action 2 on Main Page Resource Permission".equals(policyRepresentation.getName()));
        policyPredicates.add(policyRepresentation -> "Action 3 on Main Page Resource Permission".equals(policyRepresentation.getName()));
        ExportImportUtil.assertPredicate(policies, policyPredicates);
    }

    private static <D> void assertPredicate(List<D> source, List<Predicate<D>> predicate) {
        org.junit.Assert.assertTrue((!source.stream().filter(object -> !predicate.stream().filter(predicate1 -> predicate1.test(object)).findFirst().isPresent()).findAny().isPresent() ? 1 : 0) != 0);
    }

    private static Matcher<Iterable<? super String>> getDefaultClientScopeNameMatcher(ClientRepresentation rep) {
        switch (rep.getClientId()) {
            case "client-with-template": {
                return Matchers.hasItem((Object)"Default_test_template");
            }
        }
        return Matchers.not((Matcher)Matchers.hasItem((Object)"Default_test_template"));
    }

    public static void testClientDefaultClientScopes(RealmResource realm) {
        for (ClientRepresentation rep : realm.clients().findAll(true)) {
            Matcher<Iterable<? super String>> expectedDefaultClientScopeNames = ExportImportUtil.getDefaultClientScopeNameMatcher(rep);
            org.junit.Assert.assertThat((String)("Default client scopes for " + rep.getClientId()), (Object)rep.getDefaultClientScopes(), expectedDefaultClientScopeNames);
        }
    }

    public static void testRealmDefaultClientScopes(RealmResource realm) {
        List clientScopes = realm.clientScopes().findAll();
        Map clientScopesMap = clientScopes.stream().collect(Collectors.toMap(ClientScopeRepresentation::getName, Function.identity()));
        org.junit.Assert.assertThat(clientScopesMap.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"profile", "email", "address", "phone", "offline_access", "roles", "web-origins", "microprofile-jwt", "role_list"}));
        Map<String, ProtocolMapperRepresentation> protocolMappers = ((ClientScopeRepresentation)clientScopesMap.get("email")).getProtocolMappers().stream().collect(Collectors.toMap(protocolMapper -> protocolMapper.getName(), protocolMapper -> protocolMapper));
        Assert.assertNames(protocolMappers.keySet(), "email", "email verified");
        ClientScopeRepresentation offlineScope = (ClientScopeRepresentation)clientScopesMap.get("offline_access");
        Assert.assertTrue((offlineScope.getProtocolMappers() == null || offlineScope.getProtocolMappers().isEmpty() ? 1 : 0) != 0);
        List offlineRoleScopes = realm.clientScopes().get(offlineScope.getId()).getScopeMappings().realmLevel().listAll();
        Assert.assertNames(offlineRoleScopes, "offline_access");
        Set defaultClientScopes = realm.getDefaultDefaultClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(defaultClientScopes, (Matcher)Matchers.hasItems((Object[])new String[]{"profile", "email", "roles", "web-origins"}));
        Set optionalClientScopes = realm.getDefaultOptionalClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(optionalClientScopes, (Matcher)Matchers.hasItems((Object[])new String[]{"address", "phone", "offline_access", "microprofile-jwt"}));
    }
}

