/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.exportimport;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.junit.After;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.dir.DirExportProvider;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.resources.TestingExportImportResource;
import org.keycloak.testsuite.exportimport.ExportImportUtil;
import org.keycloak.testsuite.runonserver.RunHelpers;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ExportImportTest
extends AbstractKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealm1 = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealm1.getUsers().add(this.makeUser("user1"));
        testRealm1.getUsers().add(this.makeUser("user2"));
        testRealm1.getUsers().add(this.makeUser("user3"));
        testRealm1.getUsers().add(UserBuilder.create().username("user-requiredOTP").email("User-requiredOTP@test.com").password("password").requiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name()).build());
        testRealm1.getUsers().add(UserBuilder.create().username("user-requiredWebAuthn").email("User-requiredWebAuthn@test.com").password("password").requiredAction("webauthn-register").build());
        testRealm1.getSmtpServer().put("password", "secret");
        this.setEventsConfig(testRealm1);
        testRealms.add(testRealm1);
        RealmRepresentation testRealm2 = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testrealm.json"), RealmRepresentation.class);
        testRealm2.setId("test-realm");
        testRealms.add(testRealm2);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Override
    public void beforeAbstractKeycloakTestRealmImport() {
        this.removeAllRealmsDespiteMaster();
    }

    private void setEventsConfig(RealmRepresentation realm) {
        realm.setEventsEnabled(true);
        realm.setAdminEventsEnabled(Boolean.valueOf(true));
        realm.setAdminEventsDetailsEnabled(Boolean.valueOf(true));
        realm.setEventsExpiration(600L);
        realm.setEnabledEventTypes(Arrays.asList("REGISTER", "REGISTER_ERROR", "LOGIN", "LOGIN_ERROR", "LOGOUT_ERROR"));
    }

    private void checkEventsConfig(RealmEventsConfigRepresentation config) {
        Assert.assertTrue((boolean)config.isEventsEnabled());
        Assert.assertTrue((boolean)config.isAdminEventsEnabled());
        Assert.assertTrue((boolean)config.isAdminEventsDetailsEnabled());
        Assert.assertEquals((Object)600L, (Object)config.getEventsExpiration());
        Assert.assertNames(new HashSet(config.getEnabledEventTypes()), "REGISTER", "REGISTER_ERROR", "LOGIN", "LOGIN_ERROR", "LOGOUT_ERROR");
    }

    private UserRepresentation makeUser(String userName) {
        return UserBuilder.create().username(userName).email(userName + "@test.com").password("password").build();
    }

    @After
    public void clearExportImportProps() throws LifecycleException {
        this.clearExportImportProperties();
    }

    @Test
    public void testDirFullExportImport() throws Throwable {
        this.testingClient.testing().exportImport().setProvider("dir");
        String targetDirPath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "dirExport";
        DirExportProvider.recursiveDeleteDir((File)new File(targetDirPath));
        this.testingClient.testing().exportImport().setDir(targetDirPath);
        this.testingClient.testing().exportImport().setUsersPerFile(ExportImportConfig.DEFAULT_USERS_PER_FILE);
        this.testFullExportImport();
        RealmResource testRealmRealm = this.adminClient.realm("test-realm");
        ExportImportUtil.assertDataImportedInRealm(this.adminClient, this.testingClient, testRealmRealm.toRepresentation());
        org.junit.Assert.assertEquals((long)6L, (long)new File(targetDirPath).listFiles().length);
    }

    @Test
    public void testDirRealmExportImport() throws Throwable {
        this.testingClient.testing().exportImport().setProvider("dir");
        String targetDirPath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "dirRealmExport";
        DirExportProvider.recursiveDeleteDir((File)new File(targetDirPath));
        this.testingClient.testing().exportImport().setDir(targetDirPath);
        this.testingClient.testing().exportImport().setUsersPerFile(Integer.valueOf(5));
        this.testRealmExportImport();
        RealmResource testRealmRealm = this.adminClient.realm("test-realm");
        ExportImportUtil.assertDataImportedInRealm(this.adminClient, this.testingClient, testRealmRealm.toRepresentation());
        File[] files = new File(targetDirPath).listFiles();
        org.junit.Assert.assertEquals((long)4L, (long)files.length);
    }

    @Test
    public void testSingleFileFullExportImport() throws Throwable {
        this.testingClient.testing().exportImport().setProvider("singleFile");
        String targetFilePath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "singleFile-full.json";
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.testFullExportImport();
    }

    @Test
    public void testSingleFileRealmExportImport() throws Throwable {
        this.testingClient.testing().exportImport().setProvider("singleFile");
        String targetFilePath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "singleFile-realm.json";
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.testRealmExportImport();
    }

    @Test
    public void testSingleFileRealmWithoutBuiltinsImport() throws Throwable {
        this.removeRealm("test-realm");
        this.testingClient.testing().exportImport().setProvider("singleFile");
        URL url = ExportImportTest.class.getResource("/model/testrealm.json");
        String targetFilePath = new File(url.getFile()).getAbsolutePath();
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
        RealmResource testRealmRealm = this.adminClient.realm("test-realm");
        ExportImportUtil.assertDataImportedInRealm(this.adminClient, this.testingClient, testRealmRealm.toRepresentation());
    }

    @Test
    public void testImportFromPartialExport() {
        this.importRealmFromFile("/import/partial-import.json");
        Assert.assertTrue((String)"Imported realm hasn't been found!", (boolean)this.isRealmPresent("partial-import"));
        this.addTestRealmToTestRealmReps("partial-import");
        this.importRealmFromFile("/import/import-without-roles.json");
        Assert.assertTrue((String)"Imported realm hasn't been found!", (boolean)this.isRealmPresent("import-without-roles"));
        this.addTestRealmToTestRealmReps("import-without-roles");
        this.importRealmFromFile("/import/import-without-clients.json");
        Assert.assertTrue((String)"Imported realm hasn't been found!", (boolean)this.isRealmPresent("import-without-clients"));
        this.addTestRealmToTestRealmReps("import-without-clients");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportIgnoreExistingMissingClientId() {
        TestingExportImportResource resource = this.testingClient.testing().exportImport();
        resource.setStrategy(Strategy.IGNORE_EXISTING);
        resource.setProvider("dir");
        String targetDirPath = resource.getExportImportTestDirectory() + File.separator + "dirRealmExport";
        File dest = new File(targetDirPath);
        try {
            DirExportProvider.recursiveDeleteDir((File)dest);
            resource.setDir(targetDirPath);
            resource.setAction("export");
            URL url = ExportImportTest.class.getResource("/model/testrealm.json");
            File testRealm = new File(url.getFile());
            org.junit.Assert.assertThat((Object)testRealm, (Matcher)Matchers.notNullValue());
            File newFile = new File("target", "test-new-realm.json");
            try {
                FileUtils.copyFile((File)testRealm, (File)newFile);
                FileUtils.copyFileToDirectory((File)newFile, (File)dest);
            }
            catch (IOException e) {
                Assert.fail((String)("Cannot copy file. Details: " + e.getMessage()));
            }
            File existingFile = FileUtils.getFile((File)dest, (String[])new String[]{newFile.getName()});
            org.junit.Assert.assertThat((Object)existingFile, (Matcher)Matchers.notNullValue());
            resource.runExport();
            resource.setAction("import");
            try {
                resource.runImport();
                resource.runImport();
            }
            catch (Exception e) {
                Assert.fail((String)("Error with realm importing twice. Details: " + e.getMessage()));
            }
        }
        finally {
            DirExportProvider.recursiveDeleteDir((File)dest);
        }
    }

    private boolean isRealmPresent(String realmId) {
        return this.adminClient.realms().findAll().stream().anyMatch(realm -> realmId.equals(realm.getId()));
    }

    private void addTestRealmToTestRealmReps(String realm) {
        this.testContext.addTestRealmToTestRealmReps(this.adminClient.realms().realm(realm).toRepresentation());
    }

    private void testFullExportImport() throws LifecycleException {
        this.testingClient.testing().exportImport().setAction("export");
        this.testingClient.testing().exportImport().setRealmName("");
        this.testingClient.testing().exportImport().runExport();
        this.removeRealm("test");
        this.removeRealm("test-realm");
        Assert.assertNames(this.adminClient.realms().findAll(), "master");
        HashMap requiredActionsBeforeImport = new HashMap();
        this.adminClient.realm("master").flows().getRequiredActions().stream().forEach(action -> requiredActionsBeforeImport.put(action.getAlias(), action));
        this.assertNotAuthenticated("test", "test-user@localhost", "password");
        this.assertNotAuthenticated("test", "user1", "password");
        this.assertNotAuthenticated("test", "user2", "password");
        this.assertNotAuthenticated("test", "user3", "password");
        this.assertNotAuthenticated("test", "user-requiredOTP", "password");
        this.assertNotAuthenticated("test", "user-requiredWebAuthn", "password");
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "test-realm");
        this.assertAuthenticated("test", "test-user@localhost", "password");
        this.assertAuthenticated("test", "user1", "password");
        this.assertAuthenticated("test", "user2", "password");
        this.assertAuthenticated("test", "user3", "password");
        this.assertAuthenticated("test", "user-requiredOTP", "password");
        this.assertAuthenticated("test", "user-requiredWebAuthn", "password");
        RealmResource testRealmRealm = this.adminClient.realm("test");
        org.junit.Assert.assertTrue((boolean)((String)((UserRepresentation)testRealmRealm.users().search("user-requiredOTP").get(0)).getRequiredActions().get(0)).equals(UserModel.RequiredAction.CONFIGURE_TOTP.name()));
        org.junit.Assert.assertTrue((boolean)((String)((UserRepresentation)testRealmRealm.users().search("user-requiredWebAuthn").get(0)).getRequiredActions().get(0)).equals("webauthn-register"));
        org.junit.Assert.assertEquals((Object)"secret", ((RealmRepresentation)this.testingClient.server("test").fetch(RunHelpers.internalRealm())).getSmtpServer().get("password"));
        List requiredActionsAfterImport = this.adminClient.realm("master").flows().getRequiredActions();
        org.junit.Assert.assertThat((Object)requiredActionsAfterImport.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)requiredActionsBeforeImport.size())));
        requiredActionsAfterImport.stream().forEach(action -> {
            RequiredActionProviderRepresentation beforeImportAction = (RequiredActionProviderRepresentation)requiredActionsBeforeImport.get(action.getAlias());
            org.junit.Assert.assertThat((Object)action.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)beforeImportAction.getName())));
            org.junit.Assert.assertThat((Object)action.getProviderId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)beforeImportAction.getProviderId())));
            org.junit.Assert.assertThat((Object)action.getPriority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)beforeImportAction.getPriority())));
        });
    }

    private void testRealmExportImport() throws LifecycleException {
        this.testingClient.testing().exportImport().setAction("export");
        this.testingClient.testing().exportImport().setRealmName("test");
        this.testingClient.testing().exportImport().runExport();
        List components = this.adminClient.realm("test").components().query();
        KeysMetadataRepresentation keyMetadata = this.adminClient.realm("test").keys().getKeyMetadata();
        String sampleRealmRoleId = this.adminClient.realm("test").roles().get("sample-realm-role").toRepresentation().getId();
        Map roleAttributes = this.adminClient.realm("test").roles().get("attribute-role").toRepresentation().getAttributes();
        String testAppId = ((ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("test-app").get(0)).getId();
        String sampleClientRoleId = this.adminClient.realm("test").clients().get(testAppId).roles().get("sample-client-role").toRepresentation().getId();
        String sampleClientRoleAttribute = (String)((List)this.adminClient.realm("test").clients().get(testAppId).roles().get("sample-client-role").toRepresentation().getAttributes().get("sample-client-role-attribute")).get(0);
        this.adminClient.realm("test").remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "test-realm", "master");
        this.assertNotAuthenticated("test", "test-user@localhost", "password");
        this.assertNotAuthenticated("test", "user1", "password");
        this.assertNotAuthenticated("test", "user2", "password");
        this.assertNotAuthenticated("test", "user3", "password");
        this.assertNotAuthenticated("test", "user-requiredOTP", "password");
        this.assertNotAuthenticated("test", "user-requiredWebAuthn", "password");
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test", "test-realm");
        this.assertAuthenticated("test", "test-user@localhost", "password");
        this.assertAuthenticated("test", "user1", "password");
        this.assertAuthenticated("test", "user2", "password");
        this.assertAuthenticated("test", "user3", "password");
        this.assertAuthenticated("test", "user-requiredOTP", "password");
        this.assertAuthenticated("test", "user-requiredWebAuthn", "password");
        RealmResource testRealmRealm = this.adminClient.realm("test");
        org.junit.Assert.assertTrue((boolean)((String)((UserRepresentation)testRealmRealm.users().search("user-requiredOTP").get(0)).getRequiredActions().get(0)).equals(UserModel.RequiredAction.CONFIGURE_TOTP.name()));
        org.junit.Assert.assertTrue((boolean)((String)((UserRepresentation)testRealmRealm.users().search("user-requiredWebAuthn").get(0)).getRequiredActions().get(0)).equals("webauthn-register"));
        List componentsImported = this.adminClient.realm("test").components().query();
        this.assertComponents(components, componentsImported);
        KeysMetadataRepresentation keyMetadataImported = this.adminClient.realm("test").keys().getKeyMetadata();
        org.junit.Assert.assertEquals((Object)keyMetadata.getActive(), (Object)keyMetadataImported.getActive());
        String importedSampleRealmRoleId = this.adminClient.realm("test").roles().get("sample-realm-role").toRepresentation().getId();
        org.junit.Assert.assertEquals((Object)sampleRealmRoleId, (Object)importedSampleRealmRoleId);
        Map importedRoleAttributes = this.adminClient.realm("test").roles().get("attribute-role").toRepresentation().getAttributes();
        Assert.assertRoleAttributes(roleAttributes, importedRoleAttributes);
        String importedSampleClientRoleId = this.adminClient.realm("test").clients().get(testAppId).roles().get("sample-client-role").toRepresentation().getId();
        org.junit.Assert.assertEquals((Object)sampleClientRoleId, (Object)importedSampleClientRoleId);
        String importedSampleClientRoleAttribute = (String)((List)this.adminClient.realm("test").clients().get(testAppId).roles().get("sample-client-role").toRepresentation().getAttributes().get("sample-client-role-attribute")).get(0);
        org.junit.Assert.assertEquals((Object)sampleClientRoleAttribute, (Object)importedSampleClientRoleAttribute);
        this.checkEventsConfig(this.adminClient.realm("test").getRealmEventsConfig());
    }

    private void assertAuthenticated(String realmName, String username, String password) {
        this.assertAuth(true, realmName, username, password);
    }

    private void assertNotAuthenticated(String realmName, String username, String password) {
        this.assertAuth(false, realmName, username, password);
    }

    private void assertAuth(boolean expectedResult, String realmName, String username, String password) {
        org.junit.Assert.assertEquals((Object)expectedResult, (Object)this.testingClient.testing().validCredentials(realmName, username, password));
    }

    private void assertComponents(List<ComponentRepresentation> expected, List<ComponentRepresentation> actual) {
        expected.sort((o1, o2) -> o1.getId().compareTo(o2.getId()));
        actual.sort((o1, o2) -> o1.getId().compareTo(o2.getId()));
        org.junit.Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            ComponentRepresentation e = expected.get(i);
            ComponentRepresentation a = actual.get(i);
            org.junit.Assert.assertEquals((Object)e.getId(), (Object)a.getId());
            org.junit.Assert.assertEquals((Object)e.getName(), (Object)a.getName());
            org.junit.Assert.assertEquals((Object)e.getProviderId(), (Object)a.getProviderId());
            org.junit.Assert.assertEquals((Object)e.getProviderType(), (Object)a.getProviderType());
            org.junit.Assert.assertEquals((Object)e.getParentId(), (Object)a.getParentId());
            org.junit.Assert.assertEquals((Object)e.getSubType(), (Object)a.getSubType());
            Assert.assertNames(e.getConfig().keySet(), a.getConfig().keySet().toArray(new String[0]));
            for (Map.Entry entry : e.getConfig().entrySet()) {
                List eList = (List)entry.getValue();
                List aList = a.getConfig().getList(entry.getKey());
                Assert.assertNames(eList, aList.toArray(new String[0]));
            }
        }
    }

    private void clearExportImportProperties() {
        Properties systemProps = System.getProperties();
        HashSet<String> propsToRemove = new HashSet<String>();
        for (Object key : systemProps.keySet()) {
            if (!key.toString().startsWith("keycloak.migration.")) continue;
            propsToRemove.add(key.toString());
        }
        for (String propToRemove : propsToRemove) {
            systemProps.remove(propToRemove);
        }
    }

    private void importRealmFromFile(String path) {
        this.testingClient.testing().exportImport().setProvider("singleFile");
        URL url = ExportImportTest.class.getResource(path);
        String targetFilePath = new File(url.getFile()).getAbsolutePath();
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
    }
}

