/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.events;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.events.AbstractEventsTest;

public class AdminEventStoreProviderTest
extends AbstractEventsTest {
    @After
    public void after() {
        this.testing().clearAdminEventStore();
    }

    @Test
    public void save() {
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void query() {
        long oldest = System.currentTimeMillis() - 30000L;
        long newest = System.currentTimeMillis() + 30000L;
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(newest, "realmId", OperationType.ACTION, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(newest, "realmId", OperationType.ACTION, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create("realmId2", OperationType.CREATE, "realmId2", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(oldest, "realmId", OperationType.CREATE, "realmId", "clientId2", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        Assert.assertEquals((long)5L, (long)this.testing().getAdminEvents(null, null, null, "clientId", null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)5L, (long)this.testing().getAdminEvents(null, null, "realmId", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.CREATE}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.CREATE, OperationType.ACTION}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, "userId", null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.ACTION}), null, null, "userId", null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, null, Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, Integer.valueOf(5), null).size());
        Assert.assertEquals((long)newest, (long)((AdminEventRepresentation)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, null, Integer.valueOf(1)).get(0)).getTime());
        Assert.assertEquals((long)oldest, (long)((AdminEventRepresentation)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, Integer.valueOf(5), Integer.valueOf(1)).get(0)).getTime());
        this.testing().clearAdminEventStore("realmId");
        this.testing().clearAdminEventStore("realmId2");
        Assert.assertEquals((long)0L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, null, null).size());
        String d1 = "2015-03-04";
        String d2 = "2015-03-05";
        String d3 = "2015-03-06";
        String d4 = "2015-03-07";
        String d5 = "2015-03-01";
        String d6 = "2015-03-03";
        String d7 = "2015-03-08";
        String d8 = "2015-03-10";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = null;
        Date date2 = null;
        Date date3 = null;
        Date date4 = null;
        try {
            date1 = formatter.parse(d1);
            date2 = formatter.parse(d2);
            date3 = formatter.parse(d3);
            date4 = formatter.parse(d4);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.testing().onAdminEvent(this.create(date1, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date1, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date2, "realmId", OperationType.ACTION, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date2, "realmId", OperationType.ACTION, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date3, "realmId", OperationType.UPDATE, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date3, "realmId", OperationType.DELETE, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date4, "realmId2", OperationType.CREATE, "realmId2", "clientId2", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(date4, "realmId2", OperationType.CREATE, "realmId2", "clientId2", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, "clientId", null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().getAdminEvents(null, null, null, "clientId2", null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, "realmId", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().getAdminEvents(null, null, "realmId2", null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, "userId", null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, "userId2", null, null, null, null, null, null).size());
        Assert.assertEquals((long)2L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.ACTION}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.CREATE, OperationType.ACTION}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.UPDATE}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)1L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.DELETE}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, this.toList(new Enum[]{OperationType.CREATE}), null, null, null, null, null, null, null, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d1, null, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, d4, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d3, null, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, d2, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d7, null, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, d6, null, null).size());
        Assert.assertEquals((long)8L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d1, d4, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d2, d4, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d1, d2, null, null).size());
        Assert.assertEquals((long)4L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d3, d4, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d5, d6, null, null).size());
        Assert.assertEquals((long)0L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, d7, d8, null, null).size());
    }

    @Test
    public void queryResourcePath() {
        long oldest = System.currentTimeMillis() - 30000L;
        long newest = System.currentTimeMillis() + 30000L;
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(newest, "realmId", OperationType.ACTION, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(newest, "realmId", OperationType.ACTION, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create("realmId2", OperationType.CREATE, "realmId2", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(oldest, "realmId", OperationType.CREATE, "realmId", "clientId2", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId2", "127.0.0.1", "/admin/realms/master", "error"), false);
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "/admin/*", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "*/realms/*", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "*/master", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "/admin/realms/*", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "*/realms/master", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "/admin/*/master", null, null, null, null).size());
        Assert.assertEquals((long)6L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, "/ad*/*/master", null, null, null, null).size());
    }

    @Test
    public void clear() {
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 30000L, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 20000L, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis(), "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis(), "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 30000L, "realmId2", OperationType.CREATE, "realmId2", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().clearAdminEventStore("realmId");
        Assert.assertEquals((long)1L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, null, null).size());
    }

    @Test
    public void clearOld() {
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 30000L, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 20000L, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis(), "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis(), "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().onAdminEvent(this.create(System.currentTimeMillis() - 30000L, "realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "error"), false);
        this.testing().clearAdminEventStore("realmId", System.currentTimeMillis() - 10000L);
        Assert.assertEquals((long)2L, (long)this.testing().getAdminEvents(null, null, null, null, null, null, null, null, null, null, null).size());
    }

    @Test
    public void handleCustomResourceTypeEvents() {
        this.testing().onAdminEvent(this.create("realmId", OperationType.CREATE, "realmId", "clientId", "userId", "127.0.0.1", "/admin/realms/master", "my-custom-resource", "error"), false);
        List adminEvents = this.testing().getAdminEvents(null, null, null, "clientId", null, null, null, null, null, null, null);
        Assert.assertEquals((long)1L, (long)adminEvents.size());
        Assert.assertEquals((Object)"my-custom-resource", (Object)((AdminEventRepresentation)adminEvents.get(0)).getResourceType());
    }

    private AdminEventRepresentation create(String realmId, OperationType operation, String authRealmId, String authClientId, String authUserId, String authIpAddress, String resourcePath, String error) {
        return this.create(System.currentTimeMillis(), realmId, operation, authRealmId, authClientId, authUserId, authIpAddress, resourcePath, error);
    }

    private AdminEventRepresentation create(String realmId, OperationType operation, String authRealmId, String authClientId, String authUserId, String authIpAddress, String resourcePath, String resourceType, String error) {
        return this.create(System.currentTimeMillis(), realmId, operation, authRealmId, authClientId, authUserId, authIpAddress, resourcePath, resourceType, error);
    }

    private AdminEventRepresentation create(Date date, String realmId, OperationType operation, String authRealmId, String authClientId, String authUserId, String authIpAddress, String resourcePath, String error) {
        return this.create(date.getTime(), realmId, operation, authRealmId, authClientId, authUserId, authIpAddress, resourcePath, error);
    }

    private AdminEventRepresentation create(long time, String realmId, OperationType operation, String authRealmId, String authClientId, String authUserId, String authIpAddress, String resourcePath, String error) {
        return this.create(time, realmId, operation, authRealmId, authClientId, authUserId, authIpAddress, resourcePath, null, error);
    }

    private AdminEventRepresentation create(long time, String realmId, OperationType operation, String authRealmId, String authClientId, String authUserId, String authIpAddress, String resourcePath, String resourceType, String error) {
        AdminEventRepresentation e = new AdminEventRepresentation();
        e.setTime(time);
        e.setRealmId(realmId);
        e.setOperationType(operation.toString());
        AuthDetailsRepresentation authDetails = new AuthDetailsRepresentation();
        authDetails.setRealmId(authRealmId);
        authDetails.setClientId(authClientId);
        authDetails.setUserId(authUserId);
        authDetails.setIpAddress(authIpAddress);
        e.setAuthDetails(authDetails);
        e.setResourcePath(resourcePath);
        e.setResourceType(resourceType);
        e.setError(error);
        return e;
    }
}

