/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.docker;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.docker.DockerHostIpSupplier;
import org.keycloak.testsuite.docker.DockerHostVersionSupplier;
import org.keycloak.testsuite.docker.DockerTestRealmSetup;
import org.keycloak.testsuite.docker.DockerVersion;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class DockerClientTest
extends AbstractKeycloakTest {
    public static final String REALM_ID = "docker-test-realm";
    public static final String CLIENT_ID = "docker-test-client";
    public static final String DOCKER_USER = "docker-user";
    public static final String DOCKER_USER_PASSWORD = "password";
    public static final String REGISTRY_HOSTNAME = "localhost";
    public static final Integer REGISTRY_PORT = 5000;
    public static final String MINIMUM_DOCKER_VERSION = "1.8.0";
    private GenericContainer dockerRegistryContainer = null;
    private GenericContainer dockerClientContainer = null;
    private static String hostIp;
    private static String authServerPort;

    @BeforeClass
    public static void verifyEnvironment() {
        Object foundHostIp;
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.DOCKER);
        Object dockerVersion = new DockerHostVersionSupplier().get();
        Assume.assumeTrue((String)"Could not determine docker version for host machine.  It either is not present or accessible to the JVM running the test harness.", (boolean)((Optional)dockerVersion).isPresent());
        Assume.assumeTrue((String)"Docker client on host machine is not a supported version.  Please upgrade and try again.", (DockerVersion.COMPARATOR.compare((DockerVersion)((Optional)dockerVersion).get(), DockerVersion.parseVersionString(MINIMUM_DOCKER_VERSION)) >= 0 ? 1 : 0) != 0);
        hostIp = System.getProperty("host.ip");
        if (hostIp == null && ((Optional)(foundHostIp = new DockerHostIpSupplier().get())).isPresent()) {
            hostIp = (String)((Optional)foundHostIp).get();
        }
        Assert.assertNotNull((String)"Could not resolve host machine's IP address for docker adapter, and 'host.ip' system poperty not set. Client will not be able to authenticate against the keycloak server!", (Object)hostIp);
        authServerPort = ServerURLs.AUTH_SERVER_PORT;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation dockerRealm = DockerTestRealmSetup.createRealm(REALM_ID);
        DockerTestRealmSetup.configureDockerRegistryClient(dockerRealm, CLIENT_ID);
        DockerTestRealmSetup.configureUser(dockerRealm, DOCKER_USER, DOCKER_USER_PASSWORD);
        testRealms.add(dockerRealm);
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        String realmCert = null;
        List realmKeys = this.adminClient.realm(REALM_ID).keys().getKeyMetadata().getKeys();
        for (KeysMetadataRepresentation.KeyMetadataRepresentation key : realmKeys) {
            if (!key.getType().equals("RSA")) continue;
            realmCert = key.getCertificate();
        }
        if (realmCert == null) {
            throw new IllegalStateException("Cannot find public realm cert");
        }
        File tmpCertFile = File.createTempFile("keycloak-docker-realm-cert-", ".pem");
        tmpCertFile.deleteOnExit();
        PrintWriter tmpCertWriter = new PrintWriter(tmpCertFile);
        tmpCertWriter.println("-----BEGIN CERTIFICATE-----");
        tmpCertWriter.println(realmCert);
        tmpCertWriter.println("-----END CERTIFICATE-----");
        tmpCertWriter.close();
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("REGISTRY_STORAGE_FILESYSTEM_ROOTDIRECTORY", "/tmp");
        environment.put("REGISTRY_AUTH_TOKEN_REALM", "http://" + hostIp + ":" + authServerPort + "/auth/realms/" + REALM_ID + "/protocol/docker-v2/auth");
        environment.put("REGISTRY_AUTH_TOKEN_SERVICE", CLIENT_ID);
        environment.put("REGISTRY_AUTH_TOKEN_ISSUER", "http://" + hostIp + ":" + authServerPort + "/auth/realms/" + REALM_ID);
        environment.put("REGISTRY_AUTH_TOKEN_ROOTCERTBUNDLE", "/opt/kc-certs/" + tmpCertFile.getCanonicalFile().getName());
        environment.put("INSECURE_REGISTRY", "--insecure-registry localhost:" + REGISTRY_PORT);
        String dockerioPrefix = Boolean.parseBoolean(System.getProperty("docker.io-prefix-explicit")) ? "docker.io/" : "";
        this.dockerRegistryContainer = new GenericContainer(dockerioPrefix + "registry:2").withFileSystemBind(tmpCertFile.getCanonicalPath(), "/opt/kc-certs/" + tmpCertFile.getCanonicalFile().getName(), BindMode.READ_ONLY).withEnv(environment).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"dockerRegistryContainer"))).withNetworkMode("host").withPrivilegedMode(true);
        this.dockerRegistryContainer.start();
        this.dockerClientContainer = new GenericContainer(dockerioPrefix + "docker:dind").withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"dockerClientContainer"))).withNetworkMode("host").withPrivilegedMode(true);
        this.dockerClientContainer.start();
    }

    @Override
    public void afterAbstractKeycloakTest() throws Exception {
        super.afterAbstractKeycloakTest();
        WaitUtils.pause((long)5000L);
        this.dockerClientContainer.close();
        this.dockerRegistryContainer.close();
    }

    @Test
    public void shouldPerformDockerAuthAgainstRegistry() throws Exception {
        this.log.info((Object)"Starting the attempt for login...");
        Container.ExecResult dockerLoginResult = this.dockerClientContainer.execInContainer(new String[]{"docker", "login", "-u", DOCKER_USER, "-p", DOCKER_USER_PASSWORD, "localhost:" + REGISTRY_PORT});
        this.printCommandResult(dockerLoginResult);
        MatcherAssert.assertThat((Object)dockerLoginResult.getStdout(), (Matcher)Matchers.containsString((String)"Login Succeeded"));
    }

    private void printCommandResult(Container.ExecResult result) {
        this.log.infof("Command executed. Output follows:\nSTDOUT: %s\n---\nSTDERR: %s", (Object)result.getStdout(), (Object)result.getStderr());
    }
}

