/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Retry;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.crossdc.ServerSetup;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.util.OAuthClient;

@InitialDcState(authServers=ServerSetup.ALL_NODES_IN_FIRST_DC_NO_NODES_IN_SECOND_DC)
public class SessionsPreloadCrossDCTest
extends AbstractAdminCrossDCTest {
    private static final int SESSIONS_COUNT = 10;

    @Before
    public void beforeSessionsPreloadCrossDCTest() throws Exception {
        this.disableDcOnLoadBalancer(DC.SECOND);
    }

    private void stopAllCacheServersAndAuthServers() {
        this.log.infof("Going to stop all auth servers", new Object[0]);
        CrossDCTestEnricher.forAllBackendNodes(CrossDCTestEnricher::stopAuthServerBackendNode);
        this.loadBalancerCtrl.disableAllBackendNodes();
        this.log.infof("Auth servers stopped successfully. Going to stop all cache servers", new Object[0]);
        DC.validDcsStream().forEach(CrossDCTestEnricher::stopCacheServer);
        this.log.infof("Cache servers stopped successfully", new Object[0]);
    }

    @Test
    public void sessionsPreloadTest() throws Exception {
        int sessionsBefore = this.getTestingClientForStartedNodeInDc(0).testing().cache("sessions").size();
        this.log.infof("sessionsBefore: %d", (Object)sessionsBefore);
        List<OAuthClient.AccessTokenResponse> tokenResponses = this.createInitialSessions(false);
        CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.SECOND, (int)0);
        this.enableLoadBalancerNode(DC.SECOND, 0);
        Set sessions01keys = this.getTestingClientForStartedNodeInDc(0).testing().cache("sessions").enumerateKeys();
        Set sessions02keys = this.getTestingClientForStartedNodeInDc(1).testing().cache("sessions").enumerateKeys();
        this.log.infof("sessions01keys: %s, sessions02keys: %s", (Object)sessions01keys, (Object)sessions02keys);
        Assert.assertThat((Object)sessions01keys, (Matcher)Matchers.equalTo((Object)sessions02keys));
        Assert.assertTrue((boolean)this.getTestingClientForStartedNodeInDc(1).testing().cache("work").contains("distributed::remoteCacheLoad::sessions"));
        for (OAuthClient.AccessTokenResponse resp : tokenResponses) {
            OAuthClient.AccessTokenResponse newResponse = this.oauth.doRefreshTokenRequest(resp.getRefreshToken(), "password");
            Assert.assertNull((Object)newResponse.getError());
            Assert.assertNotNull((Object)newResponse.getAccessToken());
        }
    }

    @Test
    public void offlineSessionsPreloadTest() throws Exception {
        int offlineSessionsBefore = this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").size();
        this.log.infof("offlineSessionsBefore: %d", (Object)offlineSessionsBefore);
        List<OAuthClient.AccessTokenResponse> tokenResponses = this.createInitialSessions(true);
        int offlineSessions01 = this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").size();
        Assert.assertEquals((long)offlineSessions01, (long)(offlineSessionsBefore + 10));
        this.log.infof("offlineSessions01: %d", (Object)offlineSessions01);
        this.stopAllCacheServersAndAuthServers();
        DC.validDcsStream().forEach(CrossDCTestEnricher::startCacheServer);
        CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.FIRST, (int)0);
        this.enableLoadBalancerNode(DC.FIRST, 0);
        CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.SECOND, (int)0);
        this.enableLoadBalancerNode(DC.SECOND, 0);
        Set offlineSessions11keys = this.getTestingClientForStartedNodeInDc(0).testing().cache("offlineSessions").enumerateKeys();
        Set offlineSessions12keys = this.getTestingClientForStartedNodeInDc(1).testing().cache("offlineSessions").enumerateKeys();
        this.log.infof("offlineSessions11keys: %s, offlineSessions12keys: %s", (Object)offlineSessions11keys, (Object)offlineSessions12keys);
        Assert.assertThat((Object)offlineSessions11keys, (Matcher)Matchers.equalTo((Object)offlineSessions12keys));
        Assert.assertTrue((boolean)this.getTestingClientForStartedNodeInDc(0).testing().cache("work").contains("distributed::offlineUserSessions"));
        Assert.assertFalse((boolean)this.getTestingClientForStartedNodeInDc(0).testing().cache("work").contains("distributed::remoteCacheLoad::offlineSessions"));
        Assert.assertFalse((boolean)this.getTestingClientForStartedNodeInDc(1).testing().cache("work").contains("distributed::offlineUserSessions"));
        Assert.assertTrue((boolean)this.getTestingClientForStartedNodeInDc(1).testing().cache("work").contains("distributed::remoteCacheLoad::offlineSessions"));
        for (OAuthClient.AccessTokenResponse resp : tokenResponses) {
            OAuthClient.AccessTokenResponse newResponse = this.oauth.doRefreshTokenRequest(resp.getRefreshToken(), "password");
            Assert.assertNull((Object)newResponse.getError());
            Assert.assertNotNull((Object)newResponse.getAccessToken());
        }
    }

    @Test
    public void loginFailuresPreloadTest() throws Exception {
        try (RealmAttributeUpdater rau = (RealmAttributeUpdater)((RealmAttributeUpdater)((RealmAttributeUpdater)new RealmAttributeUpdater(this.getAdminClientForStartedNodeInDc(0).realms().realm("test")).updateWith(r -> r.setBruteForceProtected(Boolean.valueOf(true)))).updateWith(r -> r.setQuickLoginCheckMilliSeconds(Long.valueOf(20L)))).update();){
            String userId = ApiUtil.findUserByUsername((RealmResource)this.getAdminClientForStartedNodeInDc(0).realms().realm("test"), (String)"test-user@localhost").getId();
            int loginFailuresBefore = (Integer)this.getAdminClientForStartedNodeInDc(0).realm("test").attackDetection().bruteForceUserStatus(userId).get("numFailures");
            this.log.infof("loginFailuresBefore: %d", (Object)loginFailuresBefore);
            for (int i = 0; i < 10; ++i) {
                OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "bad-password");
                Assert.assertNull((Object)response.getAccessToken());
                Assert.assertNotNull((Object)response.getError());
            }
            CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.SECOND, (int)0);
            this.enableLoadBalancerNode(DC.SECOND, 0);
            Retry.execute(() -> {
                Set keys1 = this.getTestingClientForStartedNodeInDc(0).testing().cache("loginFailures").enumerateKeys();
                Set keys2 = this.getTestingClientForStartedNodeInDc(1).testing().cache("loginFailures").enumerateKeys();
                int loginFailures1 = (Integer)this.getAdminClientForStartedNodeInDc(0).realm("test").attackDetection().bruteForceUserStatus(userId).get("numFailures");
                int loginFailures2 = (Integer)this.getAdminClientForStartedNodeInDc(1).realm("test").attackDetection().bruteForceUserStatus(userId).get("numFailures");
                this.log.infof("keys1: %d, keys2: %d, loginFailures1: %d, loginFailures2: %d", new Object[]{keys1, keys2, loginFailures1, loginFailures2});
                Assert.assertThat((Object)keys1, (Matcher)Matchers.equalTo((Object)keys2));
                Assert.assertEquals((long)(loginFailuresBefore + 10), (long)loginFailures1);
                Assert.assertEquals((long)(loginFailuresBefore + 10), (long)loginFailures2);
            }, (int)3, (long)400L);
            Assert.assertTrue((boolean)this.getTestingClientForStartedNodeInDc(1).testing().cache("work").contains("distributed::remoteCacheLoad::loginFailures"));
        }
    }

    private List<OAuthClient.AccessTokenResponse> createInitialSessions(boolean offline) throws Exception {
        if (offline) {
            this.oauth.scope("offline_access");
        }
        LinkedList<OAuthClient.AccessTokenResponse> responses = new LinkedList<OAuthClient.AccessTokenResponse>();
        for (int i = 0; i < 10; ++i) {
            OAuthClient.AccessTokenResponse resp = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
            Assert.assertNull((Object)resp.getError());
            Assert.assertNotNull((Object)resp.getAccessToken());
            responses.add(resp);
        }
        return responses;
    }
}

