/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;

public class LoginCrossDCTest
extends AbstractAdminCrossDCTest {
    @Test
    public void loginTest() throws Exception {
        this.enableDcOnLoadBalancer(DC.SECOND);
        for (int i = 0; i < 30; ++i) {
            OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
            String code = response1.getCode();
            OAuthClient.AccessTokenResponse response2 = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertNotNull((Object)response2.getAccessToken());
            try (CloseableHttpResponse response3 = this.oauth.doLogout(response2.getRefreshToken(), "password");){
                org.junit.Assert.assertThat((Object)response3, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
            }
            this.log.infof("Iteration %d finished", (Object)i);
        }
    }
}

