/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.NotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.common.util.Retry;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.InfinispanStatistics;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanCacheStatistics;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.util.OAuthClient;

public class LastSessionRefreshCrossDCTest
extends AbstractAdminCrossDCTest {
    @Test
    public void testRevokeRefreshToken(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics sessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics sessionCacheDc2Stats, @JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="clientSessions") InfinispanStatistics clientSessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="clientSessions") InfinispanStatistics clientSessionCacheDc2Stats) {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.setRevokeRefreshToken(Boolean.valueOf(true));
        this.testRealm().update(realmRep);
        this.enableDcOnLoadBalancer(DC.SECOND);
        sessionCacheDc1Stats.reset();
        sessionCacheDc2Stats.reset();
        clientSessionCacheDc1Stats.reset();
        clientSessionCacheDc2Stats.reset();
        AtomicLong sessionStoresDc1 = new AtomicLong(this.getStores(sessionCacheDc1Stats));
        AtomicLong sessionStoresDc2 = new AtomicLong(this.getStores(sessionCacheDc2Stats));
        AtomicLong clientSessionStoresDc1 = new AtomicLong(this.getStores(clientSessionCacheDc1Stats));
        AtomicLong clientSessionStoresDc2 = new AtomicLong(this.getStores(clientSessionCacheDc2Stats));
        AtomicInteger lsrDc1 = new AtomicInteger(-1);
        AtomicInteger lsrDc2 = new AtomicInteger(-1);
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        String code = response1.getCode();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        String sessionId = this.oauth.verifyToken(tokenResponse.getAccessToken()).getSessionState();
        String refreshToken1 = tokenResponse.getRefreshToken();
        this.assertStatistics("After session created", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, false);
        this.setTimeOffset(10);
        this.disableDcOnLoadBalancer(DC.SECOND);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken2 = tokenResponse.getRefreshToken();
        this.assertStatistics("After time offset 10", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, false);
        this.disableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        Assert.assertNull((String)"Expecting no access token present", (Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getError());
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken2, "password");
        Assert.assertNull((String)"Expecting no access token present", (Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getError());
        realmRep = this.testRealm().toRepresentation();
        realmRep.setRevokeRefreshToken(Boolean.valueOf(false));
        this.testRealm().update(realmRep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastSessionRefreshUpdate(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="sessions") InfinispanStatistics sessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="sessions") InfinispanStatistics sessionCacheDc2Stats, @JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="clientSessions") InfinispanStatistics clientSessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="clientSessions") InfinispanStatistics clientSessionCacheDc2Stats) {
        this.setInfinispanTestTimeServiceOnAllStartedAuthServers();
        try {
            this.setTimeOffset(10000000);
            this.getTestingClientForStartedNodeInDc(0).testing("test").removeExpired("test");
            this.getTestingClientForStartedNodeInDc(1).testing("test").removeExpired("test");
            this.setTimeOffset(0);
            sessionCacheDc1Stats.reset();
            sessionCacheDc2Stats.reset();
            clientSessionCacheDc1Stats.reset();
            clientSessionCacheDc2Stats.reset();
            this.disableDcOnLoadBalancer(DC.SECOND);
            AtomicLong sessionStoresDc1 = new AtomicLong(this.getStores(sessionCacheDc1Stats));
            AtomicLong sessionStoresDc2 = new AtomicLong(this.getStores(sessionCacheDc2Stats));
            AtomicLong clientSessionStoresDc1 = new AtomicLong(this.getStores(clientSessionCacheDc1Stats));
            AtomicLong clientSessionStoresDc2 = new AtomicLong(this.getStores(clientSessionCacheDc2Stats));
            AtomicInteger lsrDc1 = new AtomicInteger(-1);
            AtomicInteger lsrDc2 = new AtomicInteger(-1);
            OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
            String code = response1.getCode();
            OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
            Assert.assertNotNull((Object)tokenResponse.getAccessToken());
            String sessionId = this.oauth.verifyToken(tokenResponse.getAccessToken()).getSessionState();
            String refreshToken1 = tokenResponse.getRefreshToken();
            this.assertStatistics("After session created", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, false);
            this.setTimeOffset(100);
            tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
            String refreshToken2 = tokenResponse.getRefreshToken();
            Assert.assertNotNull((Object)refreshToken2);
            this.assertStatistics("After refresh at time 100", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, false, false);
            this.setTimeOffset(110);
            tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
            String refreshToken3 = tokenResponse.getRefreshToken();
            Assert.assertNotNull((Object)refreshToken3);
            this.assertStatistics("After refresh at time 110", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, false, false, false);
            this.setTimeOffset(1960);
            boolean sessionValid = (Boolean)this.getTestingClientForStartedNodeInDc(1).server("test").fetch((FetchOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                UserSessionModel userSession = session.sessions().getUserSession(realm, sessionId);
                return AuthenticationManager.isSessionValid((RealmModel)realm, (UserSessionModel)userSession);
            }, Boolean.class);
            Assert.assertTrue((boolean)sessionValid);
            this.getTestingClientForStartedNodeInDc(1).testing("test").removeExpired("test");
            this.assertStatistics("After checking valid at time 1960", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, false, false, false, false);
            this.setTimeOffset(2200);
            sessionValid = (Boolean)this.getTestingClientForStartedNodeInDc(1).server("test").fetch((FetchOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                UserSessionModel userSession = session.sessions().getUserSession(realm, sessionId);
                return AuthenticationManager.isSessionValid((RealmModel)realm, (UserSessionModel)userSession);
            }, Boolean.class);
            Assert.assertFalse((boolean)sessionValid);
            this.setTimeOffset(4200);
            this.getTestingClientForStartedNodeInDc(1).testing("test").removeExpired("test");
            try {
                this.getTestingClientForStartedNodeInDc(0).testing("test").getLastSessionRefresh("test", sessionId, false);
                Assert.fail((String)("It wasn't expected to find the session " + sessionId));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                this.getTestingClientForStartedNodeInDc(1).testing("test").getLastSessionRefresh("test", sessionId, false);
                Assert.fail((String)("It wasn't expected to find the session " + sessionId));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        finally {
            this.revertInfinispanTestTimeServiceOnAllStartedAuthServers();
        }
    }

    @Test
    public void testOfflineSessionsLastSessionRefreshUpdate(@JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineSessions") InfinispanStatistics sessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineSessions") InfinispanStatistics sessionCacheDc2Stats, @JmxInfinispanCacheStatistics(dc=DC.FIRST, managementPortProperty="cache.server.management.port", cacheName="offlineClientSessions") InfinispanStatistics clientSessionCacheDc1Stats, @JmxInfinispanCacheStatistics(dc=DC.SECOND, managementPortProperty="cache.server.2.management.port", cacheName="offlineClientSessions") InfinispanStatistics clientSessionCacheDc2Stats) throws Exception {
        this.setTimeOffset(10000000);
        this.getTestingClientForStartedNodeInDc(0).testing("test").removeExpired("test");
        this.getTestingClientForStartedNodeInDc(1).testing("test").removeExpired("test");
        this.setTimeOffset(0);
        sessionCacheDc1Stats.reset();
        sessionCacheDc2Stats.reset();
        clientSessionCacheDc1Stats.reset();
        clientSessionCacheDc2Stats.reset();
        this.disableDcOnLoadBalancer(DC.SECOND);
        AtomicLong sessionStoresDc1 = new AtomicLong(this.getStores(sessionCacheDc1Stats));
        AtomicLong sessionStoresDc2 = new AtomicLong(this.getStores(sessionCacheDc2Stats));
        AtomicLong clientSessionStoresDc1 = new AtomicLong(this.getStores(clientSessionCacheDc1Stats));
        AtomicLong clientSessionStoresDc2 = new AtomicLong(this.getStores(clientSessionCacheDc2Stats));
        AtomicInteger lsrDc1 = new AtomicInteger(-1);
        AtomicInteger lsrDc2 = new AtomicInteger(-1);
        this.oauth.scope("offline_access");
        OAuthClient.AuthorizationEndpointResponse response1 = this.oauth.doLogin("test-user@localhost", "password");
        String code = response1.getCode();
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        String sessionId = this.oauth.verifyToken(tokenResponse.getAccessToken()).getSessionState();
        String refreshToken1 = tokenResponse.getRefreshToken();
        this.assertStatistics("After session created", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, true);
        this.setTimeOffset(100);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken3 = tokenResponse.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken3);
        this.assertStatistics("After refresh at time 100", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, false, true);
        this.setTimeOffset(110);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken2 = tokenResponse.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken2);
        this.assertStatistics("After refresh at time 110", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, false, false, true);
        this.setTimeOffset(1728000);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken4 = tokenResponse.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken4);
        this.assertStatistics("After refresh at time 1728000", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, true);
        this.setTimeOffset(2592000);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken5 = tokenResponse.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken5);
        this.assertStatistics("After refresh at time 2592000", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, false, true);
        this.setTimeOffset(3456000);
        tokenResponse = this.oauth.doRefreshTokenRequest(refreshToken1, "password");
        String refreshToken6 = tokenResponse.getRefreshToken();
        Assert.assertNotNull((Object)refreshToken6);
        this.assertStatistics("After refresh at time 3456000", sessionId, sessionCacheDc1Stats, sessionCacheDc2Stats, clientSessionCacheDc1Stats, clientSessionCacheDc2Stats, sessionStoresDc1, sessionStoresDc2, clientSessionStoresDc1, clientSessionStoresDc2, lsrDc1, lsrDc2, true, true, true, true);
    }

    private void assertStatistics(String messagePrefix, String sessionId, InfinispanStatistics sessionCacheDc1Stats, InfinispanStatistics sessionCacheDc2Stats, InfinispanStatistics clientSessionCacheDc1Stats, InfinispanStatistics clientSessionCacheDc2Stats, AtomicLong sessionStoresDc1, AtomicLong sessionStoresDc2, AtomicLong clientSessionStoresDc1, AtomicLong clientSessionStoresDc2, AtomicInteger lsrDc1, AtomicInteger lsrDc2, boolean expectedUpdatedLsrDc1, boolean expectedUpdatedLsrDc2, boolean expectedUpdatedRemoteCache, boolean offline) {
        Retry.execute(() -> {
            long newSessionStoresDc1 = this.getStores(sessionCacheDc1Stats);
            long newSessionStoresDc2 = this.getStores(sessionCacheDc2Stats);
            long newClientSessionStoresDc1 = this.getStores(clientSessionCacheDc1Stats);
            long newClientSessionStoresDc2 = this.getStores(clientSessionCacheDc2Stats);
            int newLsrDc1 = this.getTestingClientForStartedNodeInDc(0).testing("test").getLastSessionRefresh("test", sessionId, offline);
            int newLsrDc2 = this.getTestingClientForStartedNodeInDc(1).testing("test").getLastSessionRefresh("test", sessionId, offline);
            this.log.infof(messagePrefix + ": sessionStoresDc1: %d, sessionStoresDc2: %d, clientSessionStoresDc1: %d, clientSessionStoresDc2: %d, lsrDc1: %d, lsrDc2: %d", new Object[]{newSessionStoresDc1, newSessionStoresDc2, newClientSessionStoresDc1, newClientSessionStoresDc2, newLsrDc1, newLsrDc2});
            if (expectedUpdatedLsrDc1) {
                Assert.assertThat((Object)newLsrDc1, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(lsrDc1.get())));
            } else {
                Assert.assertEquals((long)newLsrDc1, (long)lsrDc1.get());
            }
            if (expectedUpdatedLsrDc2) {
                Assert.assertThat((Object)newLsrDc2, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(lsrDc2.get())));
            } else {
                Assert.assertEquals((long)newLsrDc2, (long)lsrDc2.get());
            }
            if (expectedUpdatedRemoteCache) {
                Assert.assertThat((Object)newSessionStoresDc1, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(sessionStoresDc1.get())));
                Assert.assertThat((Object)newSessionStoresDc2, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(sessionStoresDc2.get())));
                Assert.assertThat((Object)newClientSessionStoresDc1, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(clientSessionStoresDc1.get())));
                Assert.assertThat((Object)newClientSessionStoresDc2, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(clientSessionStoresDc2.get())));
            } else {
                Assert.assertEquals((long)newSessionStoresDc1, (long)sessionStoresDc1.get());
                Assert.assertEquals((long)newSessionStoresDc2, (long)sessionStoresDc2.get());
                Assert.assertEquals((long)newClientSessionStoresDc1, (long)clientSessionStoresDc1.get());
                Assert.assertEquals((long)newClientSessionStoresDc2, (long)clientSessionStoresDc2.get());
            }
            sessionStoresDc1.set(newSessionStoresDc1);
            sessionStoresDc2.set(newSessionStoresDc2);
            clientSessionStoresDc1.set(newClientSessionStoresDc1);
            clientSessionStoresDc2.set(newClientSessionStoresDc2);
            lsrDc1.set(newLsrDc1);
            lsrDc2.set(newLsrDc2);
        }, (int)50, (long)50L);
    }

    private long getStores(InfinispanStatistics cacheStats) {
        return (Long)cacheStats.getSingleStatistics("stores");
    }
}

