/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;

public class InvalidationCrossDCTest
extends AbstractAdminCrossDCTest {
    private static final String REALM_NAME = "test";

    @Test
    public void realmInvalidationTest() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        RealmRepresentation realmDc0 = this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).toRepresentation();
        RealmRepresentation realmDc1 = this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME).toRepresentation();
        Assert.assertNull((Object)realmDc0.getDisplayName());
        Assert.assertTrue((boolean)realmDc0.isRegistrationAllowed());
        Assert.assertNull((Object)realmDc1.getDisplayName());
        Assert.assertTrue((boolean)realmDc1.isRegistrationAllowed());
        realmDc0.setRegistrationAllowed(Boolean.valueOf(false));
        realmDc0.setDisplayName("Cool Realm!");
        this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).update(realmDc0);
        realmDc0 = this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).toRepresentation();
        Assert.assertEquals((Object)"Cool Realm!", (Object)realmDc0.getDisplayName());
        Assert.assertFalse((boolean)realmDc0.isRegistrationAllowed());
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            RealmRepresentation realmDcc1 = this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME).toRepresentation();
            Assert.assertEquals((Object)"Cool Realm!", (Object)realmDcc1.getDisplayName());
            Assert.assertFalse((boolean)realmDcc1.isRegistrationAllowed());
        }, (int)50, (long)50L);
        this.log.infof("realmInvalidationTest: Passed after '%d' iterations", (Object)i.get());
    }

    @Test
    public void clientInvalidationTest() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        ClientResource clientResourceDc0 = ApiUtil.findClientByClientId((RealmResource)this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME), (String)"named-test-app");
        ClientResource clientResourceDc1 = ApiUtil.findClientByClientId((RealmResource)this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME), (String)"named-test-app");
        ClientRepresentation clientDc0 = clientResourceDc0.toRepresentation();
        ClientRepresentation clientDc1 = clientResourceDc1.toRepresentation();
        Assert.assertEquals((Object)"My Named Test App", (Object)clientDc0.getName());
        Assert.assertEquals((Object)"My Named Test App", (Object)clientDc1.getName());
        clientDc0.setName("Changed Test App");
        clientResourceDc0.update(clientDc0);
        clientDc0 = clientResourceDc0.toRepresentation();
        Assert.assertEquals((Object)"Changed Test App", (Object)clientDc0.getName());
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            ClientRepresentation clientDcc1 = clientResourceDc1.toRepresentation();
            Assert.assertEquals((Object)"Changed Test App", (Object)clientDcc1.getName());
        }, (int)50, (long)50L);
        this.log.infof("clientInvalidationTest: Passed after '%d' iterations", (Object)i.get());
    }

    @Test
    public void clientListInvalidationTest() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        List dc0List = this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).clients().findAll();
        List dc1List = this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME).clients().findAll();
        Assert.assertEquals((long)dc0List.size(), (long)dc1List.size());
        int initialSize = dc0List.size();
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("some-new-client");
        rep.setEnabled(Boolean.valueOf(true));
        Response response = this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).clients().create(rep);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        dc0List = this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME).clients().findAll();
        Assert.assertEquals((long)(initialSize + 1), (long)dc0List.size());
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            List dc1Listt = this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME).clients().findAll();
            Assert.assertEquals((long)(initialSize + 1), (long)dc1Listt.size());
        }, (int)50, (long)50L);
        this.log.infof("clientListInvalidationTest: Passed after '%d' iterations", (Object)i.get());
    }

    @Test
    public void userInvalidationTest() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        UserResource userResourceDc0 = ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME), (String)"test-user@localhost");
        UserResource userResourceDc1 = ApiUtil.findUserByUsernameId((RealmResource)this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME), (String)"test-user@localhost");
        UserRepresentation userDc0 = userResourceDc0.toRepresentation();
        UserRepresentation userDc1 = userResourceDc1.toRepresentation();
        Assert.assertEquals((Object)"Tom", (Object)userDc0.getFirstName());
        Assert.assertEquals((Object)"Tom", (Object)userDc1.getFirstName());
        userDc0.setFirstName("Brad");
        userResourceDc0.update(userDc0);
        userDc0 = userResourceDc0.toRepresentation();
        Assert.assertEquals((Object)"Brad", (Object)userDc0.getFirstName());
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            UserRepresentation userDcc1 = userResourceDc1.toRepresentation();
            Assert.assertEquals((Object)"Brad", (Object)userDcc1.getFirstName());
        }, (int)50, (long)50L);
        this.log.infof("userInvalidationTest: Passed after '%d' iterations", (Object)i.get());
    }

    @Test
    public void authzResourceInvalidationTest() throws Exception {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        ResourcesResource resourcesDc0Resource = ApiUtil.findClientByClientId((RealmResource)this.getAdminClientForStartedNodeInDc(0).realms().realm(REALM_NAME), (String)"test-app-authz").authorization().resources();
        ResourcesResource resourcesDc1Resource = ApiUtil.findClientByClientId((RealmResource)this.getAdminClientForStartedNodeInDc(1).realms().realm(REALM_NAME), (String)"test-app-authz").authorization().resources();
        ResourceRepresentation resDc0 = (ResourceRepresentation)resourcesDc0Resource.findByName("Premium Resource").get(0);
        ResourceRepresentation resDc1 = (ResourceRepresentation)resourcesDc1Resource.findByName("Premium Resource").get(0);
        Assert.assertEquals((Object)"/protected/premium/*", (Object)resDc0.getUri());
        Assert.assertEquals((Object)"/protected/premium/*", (Object)resDc1.getUri());
        resDc0.setUri("/protected/ultra/premium/*");
        resourcesDc0Resource.resource(resDc0.getId()).update(resDc0);
        resDc0 = (ResourceRepresentation)resourcesDc0Resource.findByName("Premium Resource").get(0);
        Assert.assertEquals((Object)"/protected/ultra/premium/*", (Object)resDc0.getUri());
        AtomicInteger i = new AtomicInteger(0);
        Retry.execute(() -> {
            i.incrementAndGet();
            ResourceRepresentation ressDc1 = (ResourceRepresentation)resourcesDc1Resource.findByName("Premium Resource").get(0);
            Assert.assertEquals((Object)"/protected/ultra/premium/*", (Object)ressDc1.getUri());
        }, (int)50, (long)50L);
        this.log.infof("authzResourceInvalidationTest: Passed after '%d' iterations", (Object)i.get());
    }
}

