/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import javax.ws.rs.NotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.Retry;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class BruteForceCrossDCTest
extends AbstractAdminCrossDCTest {
    private static final String REALM_NAME = "brute-force-test";

    @Before
    public void beforeTest() {
        this.log.debug((Object)"--DC: creating test realm");
        try {
            this.adminClient.realm(REALM_NAME).remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        UserRepresentation user = UserBuilder.create().id("login-test-1").username("login-test-1").email("login-1@test.com").enabled(true).password("password").addRoles("offline_access").build();
        UserRepresentation user2 = UserBuilder.create().id("login-test-2").username("login-test-2").email("login-2@test.com").enabled(true).password("password").addRoles("offline_access").build();
        ClientRepresentation client = ClientBuilder.create().clientId("test-app").directAccessGrants().redirectUris("http://localhost:8180/auth/realms/master/app/*").addWebOrigin("http://localhost:8180").secret("password").build();
        RealmRepresentation realmRep = RealmBuilder.create().name(REALM_NAME).user(user).user(user2).client(client).bruteForceProtected(true).build();
        realmRep.setQuickLoginCheckMilliSeconds(Long.valueOf(0L));
        this.adminClient.realms().create(realmRep);
    }

    @Test
    public void testBruteForceWithUserOperations() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearAllBruteForce();
        this.assertStatistics("After brute force cleared", 0, 0, 0);
        this.createBruteForceFailures(10, "login-test-1");
        this.assertStatistics("After brute force for user1 created", 10, 0, 1);
        this.createBruteForceFailures(10, "login-test-2");
        this.assertStatistics("After brute force for user2 created", 10, 10, 2);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearBruteForceForUser("login-test-1");
        this.assertStatistics("After brute force for user1 cleared", 0, 10, 1);
        this.createBruteForceFailures(10, "login-test-1");
        this.assertStatistics("After brute force for user1 re-created", 10, 10, 2);
        this.adminClient.realms().realm(REALM_NAME).users().get("login-test-1").remove();
        this.assertStatistics("After user1 removed", 0, 10, 1);
    }

    @Test
    public void testBruteForceWithRealmOperations() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearAllBruteForce();
        this.assertStatistics("After brute force cleared", 0, 0, 0);
        this.createBruteForceFailures(10, "login-test-1");
        this.createBruteForceFailures(10, "login-test-2");
        this.assertStatistics("After brute force for users created", 10, 10, 2);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearAllBruteForce();
        this.assertStatistics("After brute force cleared for realm", 0, 0, 0);
        this.createBruteForceFailures(10, "login-test-1");
        this.createBruteForceFailures(10, "login-test-2");
        this.assertStatistics("After brute force for users re-created", 10, 10, 2);
        this.adminClient.realms().realm(REALM_NAME).remove();
        Retry.execute(() -> {
            int dc0CacheSize = this.getTestingClientForStartedNodeInDc(0).testing().cache("loginFailures").size();
            int dc1CacheSize = this.getTestingClientForStartedNodeInDc(1).testing().cache("loginFailures").size();
            Assert.assertEquals((long)0L, (long)dc0CacheSize);
            Assert.assertEquals((long)0L, (long)dc1CacheSize);
        }, (int)50, (long)50L);
    }

    @Test
    public void testDuplicatedPutIfAbsentOperation() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearAllBruteForce();
        this.assertStatistics("After brute force cleared", 0, 0, 0);
        this.addUserLoginFailure(this.getTestingClientForStartedNodeInDc(0));
        this.assertStatistics("After create entry1", 1, 0, 1);
        this.addUserLoginFailure(this.getTestingClientForStartedNodeInDc(1));
        this.assertStatistics("After create entry2", 2, 0, 1);
    }

    @Test
    public void testBruteForceConcurrentUpdate() throws Exception {
        this.enableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.adminClient.realms().realm(REALM_NAME).attackDetection().clearAllBruteForce();
        this.assertStatistics("After brute force cleared", 0, 0, 0);
        this.addUserLoginFailure(this.getTestingClientForStartedNodeInDc(0));
        this.assertStatistics("After create entry1", 1, 0, 1);
        AbstractConcurrencyTest.KeycloakRunnable runnable = (threadIndex, keycloak, realm1) -> this.createBruteForceFailures(1, "login-test-1");
        AbstractConcurrencyTest.run(2, 20, this, runnable);
        Retry.execute(() -> {
            int dc0user1 = (Integer)this.getAdminClientForStartedNodeInDc(0).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-1").get("numFailures");
            int dc1user1 = (Integer)this.getAdminClientForStartedNodeInDc(1).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-1").get("numFailures");
            this.log.infof("After concurrent update entry1: dc0User1=%d, dc1user1=%d", (Object)dc0user1, (Object)dc1user1);
            Assert.assertThat((Object)dc0user1, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(11)));
            Assert.assertThat((Object)dc1user1, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(11)));
        }, (int)50, (long)50L);
    }

    private void assertStatistics(String prefixMessage, int expectedUser1, int expectedUser2, int expectedCacheSize) {
        Retry.execute(() -> {
            int dc0user1 = (Integer)this.getAdminClientForStartedNodeInDc(0).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-1").get("numFailures");
            int dc1user1 = (Integer)this.getAdminClientForStartedNodeInDc(1).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-1").get("numFailures");
            int dc0user2 = (Integer)this.getAdminClientForStartedNodeInDc(0).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-2").get("numFailures");
            int dc1user2 = (Integer)this.getAdminClientForStartedNodeInDc(1).realm(REALM_NAME).attackDetection().bruteForceUserStatus("login-test-2").get("numFailures");
            int dc0CacheSize = this.getTestingClientForStartedNodeInDc(0).testing().cache("loginFailures").size();
            int dc1CacheSize = this.getTestingClientForStartedNodeInDc(1).testing().cache("loginFailures").size();
            this.log.infof("%s: dc0User1=%d, dc0user2=%d, dc1user1=%d, dc1user2=%d, dc0CacheSize=%d, dc1CacheSize=%d", new Object[]{prefixMessage, dc0user1, dc0user2, dc1user1, dc1user2, dc0CacheSize, dc1CacheSize});
            Assert.assertEquals((long)expectedUser1, (long)dc0user1);
            Assert.assertEquals((long)expectedUser2, (long)dc0user2);
            Assert.assertEquals((long)expectedUser1, (long)dc1user1);
            Assert.assertEquals((long)expectedUser2, (long)dc1user2);
            Assert.assertEquals((long)expectedCacheSize, (long)dc0CacheSize);
            Assert.assertEquals((long)expectedCacheSize, (long)dc1CacheSize);
        }, (int)50, (long)50L);
    }

    private void createBruteForceFailures(int count, String username) throws Exception {
        this.oauth.realm(REALM_NAME);
        for (int i = 0; i < count; ++i) {
            OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", username, "bad-password");
            Assert.assertNull((Object)response.getAccessToken());
            Assert.assertNotNull((Object)response.getError());
        }
    }

    private void addUserLoginFailure(KeycloakTestingClient testingClient) throws URISyntaxException, IOException {
        testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(REALM_NAME);
            UserLoginFailureModel loginFailure = session.loginFailures().addUserLoginFailure(realm, "login-test-1");
            loginFailure.incrementFailures();
        });
    }
}

