/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.crossdc;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.CrossDCTestEnricher;
import org.keycloak.testsuite.arquillian.InfinispanStatistics;
import org.keycloak.testsuite.arquillian.annotation.InitialDcState;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanCacheStatistics;
import org.keycloak.testsuite.arquillian.annotation.JmxInfinispanChannelStatistics;
import org.keycloak.testsuite.crossdc.AbstractAdminCrossDCTest;
import org.keycloak.testsuite.crossdc.DC;
import org.keycloak.testsuite.crossdc.ServerSetup;
import org.keycloak.testsuite.page.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.pages.ProceedPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.openqa.selenium.WebDriver;

public class ActionTokenCrossDCTest
extends AbstractAdminCrossDCTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;
    @Page
    protected ProceedPage proceedPage;
    @Page
    protected ErrorPage errorPage;

    private String createUser(UserRepresentation userRep) {
        Response response = this.realm.users().create(userRep);
        String createdId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.getCleanup().addUserId(createdId);
        return createdId;
    }

    @Test
    @InitialDcState(authServers=ServerSetup.ALL_NODES_IN_FIRST_DC_FIRST_NODE_IN_SECOND_DC)
    public void sendResetPasswordEmailSuccessWorksInCrossDc(@JmxInfinispanCacheStatistics(dc=DC.FIRST, dcNodeIndex=0, cacheName="actionTokens") InfinispanStatistics cacheDc0Node0Statistics, @JmxInfinispanCacheStatistics(dc=DC.FIRST, dcNodeIndex=1, cacheName="actionTokens") InfinispanStatistics cacheDc0Node1Statistics, @JmxInfinispanCacheStatistics(dc=DC.SECOND, dcNodeIndex=0, cacheName="actionTokens") InfinispanStatistics cacheDc1Node0Statistics, @JmxInfinispanChannelStatistics InfinispanStatistics channelStatisticsCrossDc) throws Exception {
        this.log.debug((Object)"--DC: START sendResetPasswordEmailSuccessWorksInCrossDc");
        Assume.assumeTrue((String)"Ignoring test as product profile is not enabled", (boolean)Profile.getName().equals("product"));
        cacheDc0Node1Statistics.waitToBecomeAvailable(10, TimeUnit.SECONDS);
        Comparable originalNumberOfEntries = cacheDc0Node0Statistics.getSingleStatistics("numberOfEntriesInMemory");
        this.log.infof("Before creating user. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        this.log.infof("After sending email. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.assertSingleStatistics(cacheDc0Node0Statistics, "numberOfEntriesInMemory", () -> this.driver.navigate().to(link), Matchers::is);
        this.log.infof("After click to the link from email. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        this.proceedPage.assertCurrent();
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.log.infof("After open password update page. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        this.assertStatistics(channelStatisticsCrossDc, () -> this.passwordUpdatePage.changePassword("new-pass", "new-pass"), (oldStats, newStats) -> {
            int oldSent = ((Number)oldStats.get("sent_messages")).intValue();
            int newSent = ((Number)newStats.get("sent_messages")).intValue();
            int oldReceived = ((Number)oldStats.get("received_messages")).intValue();
            int newReceived = ((Number)newStats.get("received_messages")).intValue();
            this.log.infof("oldSent: %d, newSent: %d, oldReceived: %d, newReceived: %d", new Object[]{oldSent, newSent, oldReceived, newReceived});
            Assert.assertTrue((newSent - oldSent > 0 || newReceived - oldReceived > 0 ? 1 : 0) != 0);
        });
        Assert.assertThat((Object)PageUtils.getPageTitle((WebDriver)this.driver), (Matcher)Matchers.containsString((String)"Your account has been updated."));
        this.log.infof("After update password. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        Assert.assertThat((Object)cacheDc0Node0Statistics.getSingleStatistics("numberOfEntriesInMemory"), (Matcher)Matchers.greaterThan((Comparable)originalNumberOfEntries));
        this.disableDcOnLoadBalancer(DC.FIRST);
        this.enableDcOnLoadBalancer(DC.SECOND);
        this.assertSingleStatistics(cacheDc1Node0Statistics, "numberOfEntriesInMemory", () -> this.driver.navigate().to(link), Matchers::greaterThan);
        this.log.infof("After another click to the invalid link. %s", (Object)this.dumpNumberOfEntriesInMemory(cacheDc0Node0Statistics, cacheDc0Node1Statistics, cacheDc1Node0Statistics));
        this.errorPage.assertCurrent();
        this.log.debug((Object)"--DC: END sendResetPasswordEmailSuccessWorksInCrossDc");
    }

    private String dumpNumberOfEntriesInMemory(InfinispanStatistics cacheDc0Node0Statistics, InfinispanStatistics cacheDc0Node1Statistics, InfinispanStatistics cacheDc1Node0Statistics) {
        return "dc0node0 - numberOfEntriesInMemory: " + cacheDc0Node0Statistics.getSingleStatistics("numberOfEntriesInMemory") + ", dc0node1 - numberOfEntriesInMemory: " + cacheDc0Node1Statistics.getSingleStatistics("numberOfEntriesInMemory") + ", dc1node0 - numberOfEntriesInMemory: " + cacheDc1Node0Statistics.getSingleStatistics("numberOfEntriesInMemory");
    }

    @Test
    @InitialDcState(authServers=ServerSetup.FIRST_NODE_IN_FIRST_DC)
    public void sendResetPasswordEmailAfterNewNodeAdded() throws IOException, MessagingException {
        this.log.debug((Object)"--DC: START sendResetPasswordEmailAfterNewNodeAdded");
        this.disableDcOnLoadBalancer(DC.SECOND);
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.disableDcOnLoadBalancer(DC.FIRST);
        CrossDCTestEnricher.startAuthServerBackendNode((DC)DC.SECOND, (int)1);
        CrossDCTestEnricher.stopAuthServerBackendNode((DC)DC.FIRST, (int)0);
        this.enableLoadBalancerNode(DC.SECOND, 1);
        Retry.execute(() -> {
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
        }, (int)3, (long)400L);
        this.log.debug((Object)"--DC: END sendResetPasswordEmailAfterNewNodeAdded");
    }
}

