/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cookies;

import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.URLAssert;
import org.openqa.selenium.Cookie;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class CookieTest
extends AbstractKeycloakTest {
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        RealmBuilder realm = RealmBuilder.edit(realmRepresentation).testEventListener();
        RealmRepresentation testRealm = realm.build();
        testRealms.add(testRealm);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.accountPage.setAuthRealm("test");
    }

    @Test
    public void testCookieValue() throws Exception {
        this.testCookieValue("KEYCLOAK_IDENTITY");
    }

    @Test
    public void testLegacyCookieValue() throws Exception {
        this.testCookieValue("KEYCLOAK_IDENTITY_LEGACY");
    }

    private void testCookieValue(String cookieName) throws Exception {
        String accountClientId = ((ClientRepresentation)this.realmsResouce().realm("test").clients().findByClientId("account").get(0)).getId();
        String clientSecret = this.realmsResouce().realm("test").clients().get(accountClientId).getSecret().getValue();
        OAuthClient.AuthorizationEndpointResponse codeResponse = this.oauth.clientId("account").redirectUri(this.accountPage.buildUri().toString()).doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse accTokenResp = this.oauth.doAccessTokenRequest(codeResponse.getCode(), clientSecret);
        String accessToken = accTokenResp.getAccessToken();
        this.accountPage.navigateTo();
        this.accountPage.assertCurrent();
        try (CloseableHttpClient hc = OAuthClient.newCloseableHttpClient();){
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie cookie = new BasicClientCookie(cookieName, accessToken);
            cookie.setDomain("localhost");
            cookie.setPath("/");
            cookieStore.addCookie((org.apache.http.cookie.Cookie)cookie);
            BasicHttpContext localContext = new BasicHttpContext();
            localContext.setAttribute("http.cookie-store", (Object)cookieStore);
            HttpGet get = new HttpGet(this.oauth.clientId("account").redirectUri(this.accountPage.buildUri().toString()).getLoginFormUrl());
            try (CloseableHttpResponse resp = hc.execute((HttpUriRequest)get, (HttpContext)localContext);){
                String pageContent = EntityUtils.toString((HttpEntity)resp.getEntity());
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"First name")));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Last name")));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.containsString((String)"Sign In"));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.containsString((String)"Forgot Password?"));
            }
        }
    }

    @Test
    public void testCookieValueLoggedOut() throws Exception {
        String accountClientId = ((ClientRepresentation)this.realmsResouce().realm("test").clients().findByClientId("account").get(0)).getId();
        String clientSecret = this.realmsResouce().realm("test").clients().get(accountClientId).getSecret().getValue();
        OAuthClient.AuthorizationEndpointResponse codeResponse = this.oauth.clientId("account").redirectUri(this.accountPage.buildUri().toString()).doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse accTokenResp = this.oauth.doAccessTokenRequest(codeResponse.getCode(), clientSecret);
        String accessToken = accTokenResp.getAccessToken();
        this.accountPage.navigateTo();
        this.accountPage.assertCurrent();
        this.accountPage.logOut();
        try (CloseableHttpClient hc = OAuthClient.newCloseableHttpClient();){
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie cookie = new BasicClientCookie("KEYCLOAK_IDENTITY", accessToken);
            cookie.setDomain("localhost");
            cookie.setPath("/");
            cookieStore.addCookie((org.apache.http.cookie.Cookie)cookie);
            BasicHttpContext localContext = new BasicHttpContext();
            localContext.setAttribute("http.cookie-store", (Object)cookieStore);
            HttpGet get = new HttpGet(this.oauth.clientId("account").redirectUri(this.accountPage.buildUri().toString()).getLoginFormUrl());
            try (CloseableHttpResponse resp = hc.execute((HttpUriRequest)get, (HttpContext)localContext);){
                String pageContent = EntityUtils.toString((HttpEntity)resp.getEntity());
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"First name")));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Last name")));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.containsString((String)"Sign In"));
                Assert.assertThat((Object)pageContent, (Matcher)Matchers.containsString((String)"Forgot Password?"));
            }
        }
    }

    @Test
    public void legacyCookiesTest() {
        ContainerAssume.assumeAuthServerSSL();
        this.accountPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.accountPage);
        this.loginPage.login("test-user@localhost", "password");
        Cookie sameSiteIdentityCookie = this.driver.manage().getCookieNamed("KEYCLOAK_IDENTITY");
        Cookie legacyIdentityCookie = this.driver.manage().getCookieNamed("KEYCLOAK_IDENTITY_LEGACY");
        Cookie sameSiteSessionCookie = this.driver.manage().getCookieNamed("KEYCLOAK_SESSION");
        Cookie legacySessionCookie = this.driver.manage().getCookieNamed("KEYCLOAK_SESSION_LEGACY");
        Cookie sameSiteAuthSessionIdCookie = this.driver.manage().getCookieNamed("AUTH_SESSION_ID");
        Cookie legacyAuthSessionIdCookie = this.driver.manage().getCookieNamed("AUTH_SESSION_ID_LEGACY");
        this.assertSameSiteCookies(sameSiteIdentityCookie, legacyIdentityCookie);
        this.assertSameSiteCookies(sameSiteSessionCookie, legacySessionCookie);
        this.assertSameSiteCookies(sameSiteAuthSessionIdCookie, legacyAuthSessionIdCookie);
    }

    private void assertSameSiteCookies(Cookie sameSiteCookie, Cookie legacyCookie) {
        Assert.assertNotNull((String)"SameSite cookie shouldn't be null", (Object)sameSiteCookie);
        Assert.assertNotNull((String)"Legacy cookie shouldn't be null", (Object)legacyCookie);
        Assert.assertEquals((Object)sameSiteCookie.getValue(), (Object)legacyCookie.getValue());
        Assert.assertEquals((Object)sameSiteCookie.getDomain(), (Object)legacyCookie.getDomain());
        Assert.assertEquals((Object)sameSiteCookie.getPath(), (Object)legacyCookie.getPath());
        Assert.assertEquals((Object)sameSiteCookie.getExpiry(), (Object)legacyCookie.getExpiry());
        Assert.assertTrue((String)"SameSite cookie should always have Secure attribute", (boolean)sameSiteCookie.isSecure());
        Assert.assertFalse((String)"Legacy cookie shouldn't have Secure attribute", (boolean)legacyCookie.isSecure());
        Assert.assertEquals((Object)sameSiteCookie.isHttpOnly(), (Object)legacyCookie.isHttpOnly());
    }
}

