/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.composites;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.composites.AbstractCompositeKeycloakTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class CompositeRoleTest
extends AbstractCompositeKeycloakTest {
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realmBuilder = RealmBuilder.create().name("test").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").ssoSessionIdleTimeout(3000).accessTokenLifespan(10000).ssoSessionMaxLifespan(10000).accessCodeLifespanUserAction(1000).accessCodeLifespan(1000).sslRequired(SslRequired.EXTERNAL.toString());
        RoleRepresentation realmRole1 = RoleBuilder.create().name("REALM_ROLE_1").build();
        RoleRepresentation realmComposite1 = RoleBuilder.create().name("REALM_COMPOSITE_1").composite().realmComposite(realmRole1).build();
        RolesBuilder roles = RolesBuilder.create().realmRole(realmRole1).realmRole(RoleBuilder.create().name("REALM_ROLE_2").build()).realmRole(RoleBuilder.create().name("REALM_ROLE_3").build()).realmRole(realmComposite1);
        realmBuilder.roles(roles);
        UserBuilder realmCompositeUser = UserBuilder.create().username("REALM_COMPOSITE_1_USER").enabled(true).password("password").addRoles(realmComposite1.getName());
        realmBuilder.user(realmCompositeUser);
        UserBuilder realmRole1User = UserBuilder.create().username("REALM_ROLE_1_USER").enabled(true).password("password").addRoles(realmRole1.getName());
        realmBuilder.user(realmRole1User);
        ClientBuilder realmComposite1Application = ClientBuilder.create().clientId("REALM_COMPOSITE_1_APPLICATION").name("REALM_COMPOSITE_1_APPLICATION").fullScopeEnabled(Boolean.FALSE).redirectUris("http://localhost:8180/auth/realms/master/app/*", "https://localhost:8543/auth/realms/master/app/*").baseUrl("http://localhost:8180/auth/realms/master/app/auth").adminUrl("http://localhost:8180/auth/realms/master/app/logout").secret("password");
        realmBuilder.client(realmComposite1Application);
        ClientBuilder realmRole1Application = ClientBuilder.create().clientId("REALM_ROLE_1_APPLICATION").name("REALM_ROLE_1_APPLICATION").fullScopeEnabled(Boolean.FALSE).redirectUris("http://localhost:8180/auth/realms/master/app/*", "https://localhost:8543/auth/realms/master/app/*").baseUrl("http://localhost:8180/auth/realms/master/app/auth").adminUrl("http://localhost:8180/auth/realms/master/app/logout").secret("password");
        realmBuilder.client(realmRole1Application);
        ClientBuilder appRoleApplication = ClientBuilder.create().clientId("APP_ROLE_APPLICATION").name("APP_ROLE_APPLICATION").fullScopeEnabled(Boolean.FALSE).redirectUris("http://localhost:8180/auth/realms/master/app/*", "https://localhost:8543/auth/realms/master/app/*").baseUrl("http://localhost:8180/auth/realms/master/app/auth").adminUrl("http://localhost:8180/auth/realms/master/app/logout").defaultRoles("APP_ROLE_1", "APP_ROLE_2").secret("password");
        realmBuilder.client(appRoleApplication);
        UserBuilder realmAppCompositeUser = UserBuilder.create().username("REALM_APP_COMPOSITE_USER").password("password");
        realmBuilder.user(realmAppCompositeUser);
        UserBuilder realmAppRoleUser = UserBuilder.create().username("REALM_APP_ROLE_USER").password("password").addRoles("APP_ROLE_2");
        realmBuilder.user(realmAppRoleUser);
        ClientBuilder appCompositeApplication = ClientBuilder.create().clientId("APP_COMPOSITE_APPLICATION").name("APP_COMPOSITE_APPLICATION").fullScopeEnabled(Boolean.FALSE).defaultRoles("APP_COMPOSITE_ROLE").redirectUris("http://localhost:8180/auth/realms/master/app/*", "https://localhost:8543/auth/realms/master/app/*").baseUrl("http://localhost:8180/auth/realms/master/app/auth").adminUrl("http://localhost:8180/auth/realms/master/app/logout").secret("password");
        realmBuilder.client(appCompositeApplication);
        UserBuilder appCompositeUser = UserBuilder.create().username("APP_COMPOSITE_USER").password("password").addRoles("REALM_COMPOSITE_1");
        realmBuilder.user(appCompositeUser);
        testRealms.add(realmBuilder.build());
    }

    @Before
    public void before() {
        if (this.testContext.isInitialized()) {
            return;
        }
        this.addRealmLevelScopeMapping("REALM_COMPOSITE_1_APPLICATION", "REALM_COMPOSITE_1");
        this.addRealmLevelScopeMapping("REALM_ROLE_1_APPLICATION", "REALM_ROLE_1");
        this.addClientLevelScopeMapping("APP_COMPOSITE_APPLICATION", "APP_ROLE_APPLICATION", "APP_ROLE_2");
        ClientResource appRoleApplication = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"APP_ROLE_APPLICATION");
        RoleResource appRole1 = appRoleApplication.roles().get("APP_ROLE_1");
        RoleBuilder realmAppCompositeRole = RoleBuilder.create().name("REALM_APP_COMPOSITE_ROLE");
        this.testRealm().roles().create(realmAppCompositeRole.build());
        String id = this.testRealm().roles().get("REALM_APP_COMPOSITE_ROLE").toRepresentation().getId();
        this.testRealm().rolesById().addComposites(id, Collections.singletonList(appRole1.toRepresentation()));
        UserResource userRsc = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"REALM_APP_COMPOSITE_USER");
        RoleRepresentation realmAppCompositeRolee = this.testRealm().roles().get("REALM_APP_COMPOSITE_ROLE").toRepresentation();
        userRsc.roles().realmLevel().add(Collections.singletonList(realmAppCompositeRolee));
        userRsc = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"APP_COMPOSITE_USER");
        userRsc.roles().realmLevel().add(Collections.singletonList(realmAppCompositeRolee));
        ClientResource appCompositeApplication = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"APP_COMPOSITE_APPLICATION");
        RoleResource appCompositeRole = appCompositeApplication.roles().get("APP_COMPOSITE_ROLE");
        LinkedList<RoleRepresentation> toAdd = new LinkedList<RoleRepresentation>();
        toAdd.add(this.testRealm().roles().get("REALM_ROLE_1").toRepresentation());
        toAdd.add(this.testRealm().roles().get("REALM_ROLE_2").toRepresentation());
        toAdd.add(this.testRealm().roles().get("REALM_ROLE_3").toRepresentation());
        ClientResource appRolesApplication = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)"APP_ROLE_APPLICATION");
        RoleRepresentation appRole1Rep = appRolesApplication.roles().get("APP_ROLE_1").toRepresentation();
        toAdd.add(appRole1Rep);
        appCompositeRole.addComposites(toAdd);
        this.testContext.setInitialized(true);
    }

    private void addRealmLevelScopeMapping(String clientId, String roleName) {
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)clientId);
        RoleRepresentation role = this.testRealm().roles().get(roleName).toRepresentation();
        client.getScopeMappings().realmLevel().add(Collections.singletonList(role));
    }

    private void addClientLevelScopeMapping(String targetClientId, String sourceClientId, String roleName) {
        ClientResource targetClient = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)targetClientId);
        ClientResource sourceClient = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)sourceClientId);
        RoleRepresentation role = sourceClient.roles().get(roleName).toRepresentation();
        targetClient.getScopeMappings().clientLevel(sourceClient.toRepresentation().getId()).add(Collections.singletonList(role));
    }

    @Test
    public void testAppCompositeUser() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("APP_COMPOSITE_APPLICATION");
        this.oauth.doLogin("APP_COMPOSITE_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("APP_COMPOSITE_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getResourceAccess("APP_ROLE_APPLICATION").getRoles().size());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess("APP_ROLE_APPLICATION").isUserInRole("APP_ROLE_1"));
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
    }

    @Test
    public void testRealmAppCompositeUser() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("APP_ROLE_APPLICATION");
        this.oauth.doLogin("REALM_APP_COMPOSITE_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_APP_COMPOSITE_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getResourceAccess("APP_ROLE_APPLICATION").getRoles().size());
        Assert.assertTrue((boolean)token.getResourceAccess("APP_ROLE_APPLICATION").isUserInRole("APP_ROLE_1"));
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
    }

    @Test
    public void testRealmOnlyWithUserCompositeAppComposite() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_COMPOSITE_1_APPLICATION");
        this.oauth.doLogin("REALM_COMPOSITE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_COMPOSITE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)2L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_COMPOSITE_1"));
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
    }

    @Test
    public void testRealmOnlyWithUserCompositeAppRole() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_ROLE_1_APPLICATION");
        this.oauth.doLogin("REALM_COMPOSITE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_COMPOSITE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
    }

    @Test
    public void testRealmOnlyWithUserRoleAppComposite() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId("REALM_COMPOSITE_1_APPLICATION");
        this.oauth.doLogin("REALM_ROLE_1_USER", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Bearer", (Object)response.getTokenType());
        AccessToken token = this.oauth.verifyToken(response.getAccessToken());
        Assert.assertEquals((Object)this.getUserId("REALM_ROLE_1_USER"), (Object)token.getSubject());
        Assert.assertEquals((long)1L, (long)token.getRealmAccess().getRoles().size());
        Assert.assertTrue((boolean)token.getRealmAccess().isUserInRole("REALM_ROLE_1"));
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
    }

    @Test
    public void testRecursiveComposites() throws Exception {
        RoleRepresentation realmComposite1 = this.testRealm().roles().get("REALM_COMPOSITE_1").toRepresentation();
        this.testRealm().roles().get("REALM_ROLE_1").addComposites(Collections.singletonList(realmComposite1));
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"REALM_COMPOSITE_1_USER");
        List realmRoles = userResource.roles().realmLevel().listEffective();
        Assert.assertNames(realmRoles, "REALM_COMPOSITE_1", "REALM_ROLE_1");
        userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"REALM_ROLE_1_USER");
        realmRoles = userResource.roles().realmLevel().listEffective();
        Assert.assertNames(realmRoles, "REALM_COMPOSITE_1", "REALM_ROLE_1");
        this.testRealm().roles().get("REALM_ROLE_1").deleteComposites(Collections.singletonList(realmComposite1));
    }
}

