/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;

public class UserInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<UserRepresentation, UserResource> {
    @Override
    protected UserRepresentation createTestEntityRepresentation() {
        String firstName = "user";
        String lastName = RandomStringUtils.randomAlphabetic((int)5);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(firstName + "_" + lastName);
        user.setEmail(user.getUsername() + "@email.test");
        user.setFirstName(firstName);
        user.setLastName(lastName);
        return user;
    }

    protected UsersResource users(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).users();
    }

    @Override
    protected UserResource entityResource(UserRepresentation user, ContainerInfo node) {
        return this.entityResource(user.getId(), node);
    }

    @Override
    protected UserResource entityResource(String id, ContainerInfo node) {
        return this.users(node).get(id);
    }

    @Override
    protected UserRepresentation createEntity(UserRepresentation user, ContainerInfo node) {
        Response response = this.users(node).create(user);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        user.setId(id);
        return this.readEntity(user, node);
    }

    @Override
    protected UserRepresentation readEntity(UserRepresentation user, ContainerInfo node) {
        UserRepresentation u = null;
        try {
            u = this.entityResource(user, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected UserRepresentation updateEntity(UserRepresentation user, ContainerInfo node) {
        this.entityResource(user, node).update(user);
        return this.readEntity(user, node);
    }

    @Override
    protected void deleteEntity(UserRepresentation user, ContainerInfo node) {
        this.entityResource(user, node).remove();
        Assert.assertNull((Object)this.readEntity(user, node));
    }

    @Override
    protected UserRepresentation testEntityUpdates(UserRepresentation user, boolean backendFailover) {
        user.setUsername(user.getUsername() + "_updated");
        user = this.updateEntityOnCurrentFailNode(user, "username");
        this.verifyEntityUpdateDuringFailover(user, backendFailover);
        user.setFirstName(user.getFirstName() + "_updated");
        user.setLastName(user.getLastName() + "_updated");
        user = this.updateEntityOnCurrentFailNode(user, "firstName/lastName");
        this.verifyEntityUpdateDuringFailover(user, backendFailover);
        return user;
    }
}

