/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;
import org.keycloak.testsuite.util.RoleBuilder;

public class RoleInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<RoleRepresentation, RoleResource> {
    @Before
    public void setExcludedComparisonFields() {
        this.excludedComparisonFields.add("composites");
    }

    @Override
    protected RoleRepresentation createTestEntityRepresentation() {
        RoleRepresentation composite1 = this.createEntityOnCurrentFailNode(RoleBuilder.create().name("composite_role_" + RandomStringUtils.randomAlphabetic((int)5)).build());
        RoleRepresentation composite2 = this.createEntityOnCurrentFailNode(RoleBuilder.create().name("composite_role_" + RandomStringUtils.randomAlphabetic((int)5)).build());
        RoleRepresentation role = new RoleRepresentation();
        role.setName("role_" + RandomStringUtils.randomAlphabetic((int)5));
        role.setDescription("description of " + role.getName());
        role.setComposites(new RoleRepresentation.Composites());
        role.getComposites().setRealm(new HashSet());
        role.getComposites().getRealm().add(composite1.getName());
        role.getComposites().getRealm().add(composite2.getName());
        return role;
    }

    protected RolesResource roles(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).roles();
    }

    protected RoleByIdResource roleById(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).rolesById();
    }

    @Override
    protected RoleResource entityResource(RoleRepresentation role, ContainerInfo node) {
        return this.entityResource(role.getName(), node);
    }

    @Override
    protected RoleResource entityResource(String name, ContainerInfo node) {
        return this.roles(node).get(name);
    }

    @Override
    protected RoleRepresentation createEntity(RoleRepresentation role, ContainerInfo node) {
        this.roles(node).create(role);
        if (role.getComposites() != null && role.getComposites().getRealm() != null) {
            List composites = role.getComposites().getRealm().stream().map(realmRoleName -> this.roles(node).get(realmRoleName).toRepresentation()).collect(Collectors.toList());
            this.roleById(node).addComposites(this.readEntity(role, node).getId(), composites);
        }
        return this.readEntity(role, node);
    }

    @Override
    protected RoleRepresentation readEntity(RoleRepresentation role, ContainerInfo node) {
        RoleRepresentation u = null;
        try {
            u = this.entityResource(role, node).toRepresentation();
            if (u.isComposite()) {
                u.setComposites(new RoleRepresentation.Composites());
                u.getComposites().setRealm(new HashSet());
                for (RoleRepresentation roleComposite : this.roleById(node).getRealmRoleComposites(u.getId())) {
                    u.getComposites().getRealm().add(roleComposite.getName());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected RoleRepresentation updateEntity(RoleRepresentation role, ContainerInfo node) {
        return this.updateEntity(role.getName(), role, node);
    }

    private RoleRepresentation updateEntity(String roleName, RoleRepresentation role, ContainerInfo node) {
        this.entityResource(roleName, node).update(role);
        return this.readEntity(role, node);
    }

    @Override
    protected void deleteEntity(RoleRepresentation role, ContainerInfo node) {
        this.entityResource(role, node).remove();
        Assert.assertNull((Object)this.readEntity(role, node));
        this.roles(node).deleteRole((String)role.getComposites().getRealm().stream().findFirst().get());
    }

    @Override
    protected RoleRepresentation testEntityUpdates(RoleRepresentation role, boolean backendFailover) {
        role.setDescription(role.getDescription() + "_- updated");
        role = this.updateEntityOnCurrentFailNode(role, "description");
        this.verifyEntityUpdateDuringFailover(role, backendFailover);
        this.log.info((Object)("Removing one of the composite roles on " + this.getCurrentFailNode()));
        this.roles(this.getCurrentFailNode()).deleteRole((String)role.getComposites().getRealm().stream().findFirst().get());
        role = this.readEntity(role, this.getCurrentFailNode());
        this.verifyEntityUpdateDuringFailover(role, backendFailover);
        return role;
    }

    @Override
    protected void assertEntityOnSurvivorNodesEqualsTo(RoleRepresentation testEntityOnFailNode) {
        super.assertEntityOnSurvivorNodesEqualsTo(testEntityOnFailNode);
        boolean entityDiffers = false;
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            this.log.debug((Object)String.format("Attempt to verify %s on survivor %s (%s)", this.getEntityType(testEntityOnFailNode), survivorNode, survivorNode.getContextRoot()));
            RoleRepresentation testEntityOnSurvivorNode = this.readEntity(testEntityOnFailNode, survivorNode);
            if (EqualsBuilder.reflectionEquals((Object)this.sortFieldsComposites(testEntityOnSurvivorNode.getComposites()), (Object)this.sortFieldsComposites(testEntityOnFailNode.getComposites()))) {
                this.log.info((Object)String.format("Verification of %s on survivor %s PASSED", this.getEntityType(testEntityOnFailNode), survivorNode));
                continue;
            }
            entityDiffers = true;
            this.log.error((Object)String.format("Verification of %s on survivor %s FAILED", this.getEntityType(testEntityOnFailNode), survivorNode));
            String tf = ReflectionToStringBuilder.reflectionToString((Object)testEntityOnFailNode.getComposites(), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            String ts = ReflectionToStringBuilder.reflectionToString((Object)testEntityOnSurvivorNode.getComposites(), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            this.log.error((Object)String.format("\nEntity on fail node: \n%s\n\nEntity on survivor node: \n%s\n\nDifference: \n%s\n", tf, ts, StringUtils.difference((String)tf, (String)ts)));
        }
        Assert.assertFalse((boolean)entityDiffers);
    }

    private RoleRepresentation.Composites sortFieldsComposites(RoleRepresentation.Composites composites) {
        for (Field field : composites.getClass().getDeclaredFields()) {
            try {
                Class type = Reflections.resolveListType((Field)field, (Object)composites);
                if (type == null || !Comparable.class.isAssignableFrom(type)) continue;
                Reflections.setAccessible((AccessibleObject)field);
                Object value = field.get(composites);
                if (value == null) continue;
                Collections.sort((List)value);
            }
            catch (IllegalAccessException cause) {
                throw new RuntimeException("Failed to sort field [" + field + "]", cause);
            }
            finally {
                Reflections.unsetAccessible((AccessibleObject)field);
            }
        }
        return composites;
    }
}

