/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractInvalidationClusterTestWithTestRealm;
import org.keycloak.testsuite.util.GroupBuilder;

public class GroupInvalidationClusterTest
extends AbstractInvalidationClusterTestWithTestRealm<GroupRepresentation, GroupResource> {
    @Before
    public void setExcludedComparisonFields() {
        this.excludedComparisonFields.add("subGroups");
    }

    @Override
    protected GroupRepresentation createTestEntityRepresentation() {
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group_" + RandomStringUtils.randomAlphabetic((int)5));
        group.setAttributes(new HashMap());
        group.getAttributes().put("attr1", Arrays.asList("attr1 value"));
        group.getAttributes().put("attr2", Arrays.asList("attr2 value", "attr2 value2"));
        return group;
    }

    protected GroupsResource groups(ContainerInfo node) {
        return this.getAdminClientFor(node).realm(this.testRealmName).groups();
    }

    @Override
    protected GroupResource entityResource(GroupRepresentation group, ContainerInfo node) {
        return this.entityResource(group.getId(), node);
    }

    @Override
    protected GroupResource entityResource(String id, ContainerInfo node) {
        return this.groups(node).group(id);
    }

    @Override
    protected GroupRepresentation createEntity(GroupRepresentation group, ContainerInfo node) {
        Response response = this.groups(node).add(group);
        String id = ApiUtil.getCreatedId((Response)response);
        response.close();
        group.setId(id);
        return this.readEntity(group, node);
    }

    @Override
    protected GroupRepresentation readEntity(GroupRepresentation group, ContainerInfo node) {
        GroupRepresentation u = null;
        try {
            u = this.entityResource(group, node).toRepresentation();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return u;
    }

    @Override
    protected GroupRepresentation updateEntity(GroupRepresentation group, ContainerInfo node) {
        this.entityResource(group, node).update(group);
        return this.readEntity(group, node);
    }

    @Override
    protected void deleteEntity(GroupRepresentation group, ContainerInfo node) {
        this.entityResource(group, node).remove();
        org.junit.Assert.assertNull((Object)this.readEntity(group, node));
    }

    @Override
    protected GroupRepresentation testEntityUpdates(GroupRepresentation group, boolean backendFailover) {
        group.setName(group.getName() + "_updated");
        group = this.updateEntityOnCurrentFailNode(group, "name");
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        group.getAttributes().put("attr3", Arrays.asList("attr3 value"));
        group = this.updateEntityOnCurrentFailNode(group, "attributes - adding");
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        group.getAttributes().remove("attr3");
        group = this.updateEntityOnCurrentFailNode(group, "attributes - removing");
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        ((List)group.getAttributes().get("attr1")).set(0, (String)((List)group.getAttributes().get("attr1")).get(0) + " - updated");
        group = this.updateEntityOnCurrentFailNode(group, "attributes");
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        ((List)group.getAttributes().get("attr2")).set(1, (String)((List)group.getAttributes().get("attr2")).get(1) + " - updated");
        group = this.updateEntityOnCurrentFailNode(group, "attributes");
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        this.log.info((Object)("Updating Group parent on " + this.getCurrentFailNode()));
        GroupRepresentation parentGroup = new GroupRepresentation();
        parentGroup.setName("parent");
        parentGroup = this.createEntityOnCurrentFailNode(parentGroup);
        org.junit.Assert.assertEquals((Object)("/" + parentGroup.getName()), (Object)parentGroup.getPath());
        Response r = ((GroupResource)this.entityResourceOnCurrentFailNode(parentGroup)).subGroup(group);
        r.close();
        parentGroup = this.readEntityOnCurrentFailNode(parentGroup);
        group = this.readEntityOnCurrentFailNode(group);
        org.junit.Assert.assertTrue((boolean)ApiUtil.groupContainsSubgroup((GroupRepresentation)parentGroup, (GroupRepresentation)group));
        org.junit.Assert.assertEquals((Object)(parentGroup.getPath() + "/" + group.getName()), (Object)group.getPath());
        this.verifyEntityUpdateDuringFailover(group, backendFailover);
        parentGroup = this.readEntityOnCurrentFailNode(parentGroup);
        GroupRepresentation childGroup2 = GroupBuilder.create().name("childGroup2").build();
        r = ((GroupResource)this.entityResourceOnCurrentFailNode(parentGroup)).subGroup(childGroup2);
        String childGroup2Id = ApiUtil.getCreatedId((Response)r);
        childGroup2.setId(childGroup2Id);
        parentGroup = this.readEntityOnCurrentFailNode(parentGroup);
        this.verifyEntityUpdateDuringFailover(parentGroup, backendFailover);
        GroupRepresentation parentGroupOnOtherNode = this.readEntityOnCurrentFailNode(parentGroup);
        Assert.assertNames(parentGroup.getSubGroups(), group.getName(), "childGroup2");
        Assert.assertNames(parentGroupOnOtherNode.getSubGroups(), group.getName(), "childGroup2");
        this.deleteEntityOnCurrentFailNode(childGroup2);
        return group;
    }
}

