/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Before;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.concurrency.ConcurrentLoginTest;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.rest.representation.JGroupsStats;

public class ConcurrentLoginClusterTest
extends ConcurrentLoginTest {
    @ArquillianResource
    protected ContainerController controller;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Override
    @Before
    public void beforeTest() {
        this.log.info((Object)"Starting 2 backend nodes now");
        for (ContainerInfo node : this.suiteContext.getAuthServerBackendsInfo()) {
            if (this.controller.isStarted(node.getQualifier())) continue;
            this.log.info((Object)("Starting backend node: " + node));
            this.controller.start(node.getQualifier());
            Assert.assertTrue((boolean)this.controller.isStarted(node.getQualifier()));
        }
        this.log.info((Object)"Importing realms");
        LinkedList<RealmRepresentation> testRealms = new LinkedList<RealmRepresentation>();
        super.addTestRealms(testRealms);
        for (RealmRepresentation testRealm : testRealms) {
            this.importRealm(testRealm);
        }
        this.log.info((Object)"Realms imported");
        this.createClients();
    }

    @Override
    public void concurrentLoginSingleUser() throws Throwable {
        super.concurrentLoginSingleUser();
        JGroupsStats stats = this.testingClient.testing().cache("sessions").getJgroupsStats();
        this.log.info((Object)("JGroups statistics: " + stats.statsAsString()));
    }
}

