/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.io.IOException;
import javax.mail.MessagingException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.cluster.AbstractFailoverClusterTest;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

public class AuthenticationSessionFailoverClusterTest
extends AbstractFailoverClusterTest {
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected LoginUpdateProfilePage updateProfilePage;

    @Test
    public void failoverDuringAuthentication() throws Exception {
        boolean expectSuccessfulFailover = SESSION_CACHE_OWNERS >= 2;
        this.log.info((Object)("AUTHENTICATION FAILOVER TEST: cluster size = " + this.getClusterSize() + ", session-cache owners = " + SESSION_CACHE_OWNERS + " --> Testsing for " + (expectSuccessfulFailover ? "" : "UN") + "SUCCESSFUL session failover."));
        org.junit.Assert.assertEquals((long)2L, (long)this.getClusterSize());
        this.failoverTest(expectSuccessfulFailover);
    }

    protected void failoverTest(boolean expectSuccessfulFailover) throws IOException, MessagingException {
        this.loginPage.open();
        String cookieValue1 = AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver);
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        Assert.assertEquals((Object)cookieValue1, (Object)AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver));
        this.log.info((Object)("Authentication session cookie: " + cookieValue1));
        this.setCurrentFailNodeForRoute(cookieValue1);
        this.failure();
        WaitUtils.pause((long)REBALANCE_WAIT.intValue());
        this.logFailoverSetup();
        this.updatePasswordPage.changePassword("password", "password");
        if (expectSuccessfulFailover) {
            this.updateProfilePage.assertCurrent();
            String cookieValue2 = AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver);
            this.log.info((Object)("Authentication session cookie after failover: " + cookieValue2));
            Assert.assertEquals((Object)cookieValue1.substring(0, 36), (Object)cookieValue2.substring(0, 36));
            Assert.assertNotEquals((Object)cookieValue1, (Object)cookieValue2);
        } else {
            this.loginPage.assertCurrent();
            String error = this.loginPage.getError();
            this.log.info((Object)("Failover not successful as expected. Error on login page: " + error));
            Assert.assertNotNull((Object)error);
            this.loginPage.login("login-test", "password");
            this.updatePasswordPage.changePassword("password", "password");
        }
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    public static String getAuthSessionCookieValue(WebDriver driver) {
        Cookie authSessionCookie = driver.manage().getCookieNamed("AUTH_SESSION_ID");
        if (authSessionCookie == null) {
            authSessionCookie = driver.manage().getCookieNamed("AUTH_SESSION_ID_LEGACY");
        }
        Assert.assertNotNull((Object)authSessionCookie);
        return authSessionCookie.getValue();
    }
}

