/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.io.Serializable;
import java.util.HashSet;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.infinispan.Cache;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.InfinispanStickySessionEncoderProviderFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.cluster.AbstractClusterTest;
import org.keycloak.testsuite.cluster.AuthenticationSessionFailoverClusterTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.OAuthClient;

public class AuthenticationSessionClusterTest
extends AbstractClusterTest {
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected LoginUpdateProfilePage updateProfilePage;
    @Page
    protected AppPage appPage;

    @Before
    public void setup() {
        try {
            this.adminClient.realm("test").remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        this.adminClient.realms().create(testRealm);
    }

    @After
    public void after() {
        this.adminClient.realm("test").remove();
    }

    @Test
    public void testAuthSessionCookieWithAttachedRoute() throws Exception {
        OAuthClient oAuthClient = new OAuthClient();
        oAuthClient.init(this.driver);
        oAuthClient.baseUrl(UriBuilder.fromUri((String)(this.backendNode(0).getUriBuilder().build(new Object[0]) + "/auth")).build(new Object[]{"test"}).toString());
        String testAppLoginNode1URL = oAuthClient.getLoginFormUrl();
        HashSet<String> visitedRoutes = new HashSet<String>();
        for (int i = 0; i < 20; ++i) {
            this.driver.navigate().to(testAppLoginNode1URL);
            String authSessionCookie = AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver);
            Assert.assertThat((Object)authSessionCookie.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(36)));
            String route = authSessionCookie.substring(37);
            visitedRoutes.add(route);
            this.driver.manage().deleteAllCookies();
        }
        Assert.assertThat(visitedRoutes, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.startsWith((String)"node1"), Matchers.startsWith((String)"node2")}));
    }

    @Test
    public void testAuthSessionCookieWithoutRoute() throws Exception {
        OAuthClient oAuthClient = new OAuthClient();
        oAuthClient.init(this.driver);
        oAuthClient.baseUrl(UriBuilder.fromUri((String)(this.backendNode(0).getUriBuilder().build(new Object[0]) + "/auth")).build(new Object[]{"test"}).toString());
        String testAppLoginNode1URL = oAuthClient.getLoginFormUrl();
        this.getTestingClientFor(this.backendNode(0)).server().run((RunOnServer & Serializable)session -> {
            InfinispanStickySessionEncoderProviderFactory factory = (InfinispanStickySessionEncoderProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(StickySessionEncoderProvider.class, "infinispan");
            factory.setShouldAttachRoute(false);
        });
        for (int i = 0; i < 20; ++i) {
            this.driver.navigate().to(testAppLoginNode1URL);
            String authSessionCookie = AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver);
            Assert.assertEquals((long)36L, (long)authSessionCookie.length());
            this.driver.manage().deleteAllCookies();
            this.getTestingClientFor(this.backendNode(0)).server().run((RunOnServer & Serializable)session -> {
                Cache authSessionCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("authenticationSessions");
                String keyOwner = InfinispanUtil.getTopologyInfo((KeycloakSession)session).getRouteName(authSessionCache, (Object)authSessionCookie);
                Assert.assertTrue((boolean)keyOwner.startsWith("node1"));
            });
        }
        this.getTestingClientFor(this.backendNode(0)).server().run((RunOnServer & Serializable)session -> {
            InfinispanStickySessionEncoderProviderFactory factory = (InfinispanStickySessionEncoderProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(StickySessionEncoderProvider.class, "infinispan");
            factory.setShouldAttachRoute(true);
        });
    }
}

