/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cluster;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.cluster.AbstractClusterTest;

public abstract class AbstractInvalidationClusterTest<T, TR>
extends AbstractClusterTest {
    protected List<String> excludedComparisonFields = new ArrayList<String>();

    protected RealmRepresentation createTestRealmRepresentation() {
        RealmRepresentation testRealm = new RealmRepresentation();
        testRealm.setRealm("test_" + RandomStringUtils.randomAlphabetic((int)5));
        testRealm.setEnabled(Boolean.valueOf(true));
        return testRealm;
    }

    protected abstract T createTestEntityRepresentation();

    @Test
    public void crudWithoutFailover() {
        this.crud(false);
    }

    @Test
    public void crudWithFailover() {
        this.crud(true);
    }

    public void crud(boolean backendFailover) {
        T testEntity = this.createTestEntityRepresentation();
        this.log.info((Object)"(1) createEntityOnCurrentFailNode");
        testEntity = this.createEntityOnCurrentFailNode(testEntity);
        if (backendFailover) {
            this.log.info((Object)"(2) failure");
            this.failure();
        }
        this.log.info((Object)"(3) assertEntityOnSurvivorNodesEqualsTo");
        this.assertEntityOnSurvivorNodesEqualsTo(testEntity);
        this.log.info((Object)"(4) failback");
        this.failback();
        this.log.info((Object)"(5) iterateCurrentFailNode");
        this.iterateCurrentFailNode();
        this.log.info((Object)"(6) testEntityUpdates");
        testEntity = this.testEntityUpdates(testEntity, backendFailover);
        this.log.info((Object)"(7) deleteEntityOnCurrentFailNode");
        this.deleteEntityOnCurrentFailNode(testEntity);
        if (backendFailover) {
            this.log.info((Object)"(8) failure");
            this.failure();
        }
        this.log.info((Object)"(9) assertEntityOnSurvivorNodesIsDeleted");
        this.assertEntityOnSurvivorNodesIsDeleted(testEntity);
    }

    protected abstract TR entityResource(T var1, ContainerInfo var2);

    protected abstract TR entityResource(String var1, ContainerInfo var2);

    protected abstract T createEntity(T var1, ContainerInfo var2);

    protected abstract T readEntity(T var1, ContainerInfo var2);

    protected abstract T updateEntity(T var1, ContainerInfo var2);

    protected abstract void deleteEntity(T var1, ContainerInfo var2);

    protected TR entityResourceOnCurrentFailNode(T testEntity) {
        return this.entityResource(testEntity, this.getCurrentFailNode());
    }

    protected String getEntityType(T entity) {
        return entity.getClass().getSimpleName().replace("Representation", "");
    }

    protected T createEntityOnCurrentFailNode(T entity) {
        this.log.info((Object)("Creating " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        return this.createEntity(entity, this.getCurrentFailNode());
    }

    protected T readEntityOnCurrentFailNode(T entity) {
        this.log.debug((Object)("Reading " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        return this.readEntity(entity, this.getCurrentFailNode());
    }

    protected T updateEntityOnCurrentFailNode(T entity) {
        return this.updateEntityOnCurrentFailNode(entity, "");
    }

    protected T updateEntityOnCurrentFailNode(T entity, String updateType) {
        this.log.info((Object)("Updating " + this.getEntityType(entity) + " " + updateType + " on " + this.getCurrentFailNode()));
        return this.updateEntity(entity, this.getCurrentFailNode());
    }

    protected void deleteEntityOnCurrentFailNode(T entity) {
        this.log.info((Object)("Creating " + this.getEntityType(entity) + " on " + this.getCurrentFailNode()));
        this.deleteEntity(entity, this.getCurrentFailNode());
    }

    protected abstract T testEntityUpdates(T var1, boolean var2);

    protected void verifyEntityUpdateDuringFailover(T testEntity, boolean backendFailover) {
        if (backendFailover) {
            this.failure();
        }
        this.assertEntityOnSurvivorNodesEqualsTo(testEntity);
        this.failback();
        this.iterateCurrentFailNode();
    }

    protected void assertEntityOnSurvivorNodesEqualsTo(T testEntityOnFailNode) {
        boolean entityDiffers = false;
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            this.log.debug((Object)String.format("Attempt to verify %s on survivor %s (%s)", this.getEntityType(testEntityOnFailNode), survivorNode, survivorNode.getContextRoot()));
            T testEntityOnSurvivorNode = this.readEntity(testEntityOnFailNode, survivorNode);
            if (EqualsBuilder.reflectionEquals(this.sortFields(testEntityOnSurvivorNode), this.sortFields(testEntityOnFailNode), this.excludedComparisonFields)) {
                this.log.info((Object)String.format("Verification of %s on survivor %s PASSED", this.getEntityType(testEntityOnFailNode), survivorNode));
                continue;
            }
            entityDiffers = true;
            this.log.error((Object)String.format("Verification of %s on survivor %s FAILED", this.getEntityType(testEntityOnFailNode), survivorNode));
            String tf = ReflectionToStringBuilder.reflectionToString(testEntityOnFailNode, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            String ts = ReflectionToStringBuilder.reflectionToString(testEntityOnSurvivorNode, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            this.log.error((Object)String.format("\nEntity on fail node: \n%s\n\nEntity on survivor node: \n%s\n\nDifference: \n%s\n", tf, ts, StringUtils.difference((String)tf, (String)ts)));
        }
        Assert.assertFalse((boolean)entityDiffers);
    }

    private T sortFields(T entity) {
        for (Field field : entity.getClass().getDeclaredFields()) {
            try {
                Class type = Reflections.resolveListType((Field)field, entity);
                if (type == null || !Comparable.class.isAssignableFrom(type)) continue;
                Reflections.setAccessible((AccessibleObject)field);
                Object value = field.get(entity);
                if (value == null) continue;
                Collections.sort((List)value);
            }
            catch (IllegalAccessException cause) {
                throw new RuntimeException("Failed to sort field [" + field + "]", cause);
            }
            finally {
                Reflections.unsetAccessible((AccessibleObject)field);
            }
        }
        return entity;
    }

    private void assertEntityOnSurvivorNodesIsDeleted(T testEntityOnFailNode) {
        boolean entityExists = false;
        for (ContainerInfo survivorNode : this.getCurrentSurvivorNodes()) {
            T testEntityOnSurvivorNode = this.readEntity(testEntityOnFailNode, survivorNode);
            if (testEntityOnSurvivorNode == null) {
                this.log.info((Object)String.format("Verification of %s deletion on survivor %s PASSED", this.getEntityType(testEntityOnFailNode), survivorNode));
                continue;
            }
            entityExists = true;
            this.log.error((Object)String.format("Verification of %s deletion on survivor %s FAILED", this.getEntityType(testEntityOnFailNode), survivorNode));
        }
        Assert.assertFalse((boolean)entityExists);
    }
}

