/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.testsuite.util.KeycloakModelUtils;

public class SAMLClientRegistrationTest
extends AbstractClientRegistrationTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        RealmRepresentation testRealm = testRealms.get(0);
        ClientRepresentation samlApp = KeycloakModelUtils.createClient(testRealm, "oidc-client");
        samlApp.setSecret("secret");
        samlApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        samlApp.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    @Test
    public void createClient() throws ClientRegistrationException, IOException {
        String entityDescriptor = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/clientreg-test/saml-entity-descriptor.xml"));
        ClientRepresentation response = this.reg.saml().create(entityDescriptor);
        org.junit.Assert.assertThat((Object)response.getRegistrationAccessToken(), (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)response.getClientId(), (Matcher)Matchers.is((Object)"loadbalancer-9.siroe.com"));
        org.junit.Assert.assertThat((Object)response.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp/post", "https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp/soap", "https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp/paos", "https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp/redirect", "https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp/artifact"}));
        org.junit.Assert.assertThat(response.getAttributes().get("saml_single_logout_service_url_redirect"), (Matcher)Matchers.is((Object)"https://LoadBalancer-9.siroe.com:3443/federation/SPSloRedirect/metaAlias/sp"));
        org.junit.Assert.assertThat(response.getAttributes().get("saml.artifact.binding.identifier"), (Matcher)Matchers.is((Object)ArtifactBindingUtils.computeArtifactBindingIdentifierString((String)"loadbalancer-9.siroe.com")));
        Assert.assertNotNull((Object)response.getProtocolMappers());
        Assert.assertEquals((long)1L, (long)response.getProtocolMappers().size());
        ProtocolMapperRepresentation mapper = (ProtocolMapperRepresentation)response.getProtocolMappers().get(0);
        Assert.assertEquals((Object)"saml-user-attribute-mapper", (Object)mapper.getProtocolMapper());
        Assert.assertEquals((Object)"urn:oid:2.5.4.42", mapper.getConfig().get("attribute.name"));
        Assert.assertEquals((Object)"givenName", mapper.getConfig().get("friendly.name"));
        Assert.assertEquals((Object)"URI Reference", mapper.getConfig().get("attribute.nameformat"));
    }

    @Test
    public void testSAMLEndpointCreateWithOIDCClient() throws Exception {
        ClientsResource clientsResource = this.adminClient.realm("test").clients();
        ClientRepresentation oidcClient = (ClientRepresentation)clientsResource.findByClientId("oidc-client").get(0);
        String oidcClientServiceId = clientsResource.get(oidcClient.getId()).getServiceAccountUser().getId();
        String realmManagementId = ((ClientRepresentation)clientsResource.findByClientId("realm-management").get(0)).getId();
        RoleRepresentation role = clientsResource.get(realmManagementId).roles().get("create-client").toRepresentation();
        this.adminClient.realm("test").users().get(oidcClientServiceId).roles().clientLevel(realmManagementId).add(Arrays.asList(role));
        String accessToken = this.oauth.clientId("oidc-client").doClientCredentialsGrantAccessTokenRequest("secret").getAccessToken();
        this.reg.auth(Auth.token((String)accessToken));
        String entityDescriptor = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/clientreg-test/saml-entity-descriptor.xml"));
        this.assertCreateFail(entityDescriptor, 400, "invalid_client");
    }

    private void assertCreateFail(String entityDescriptor, int expectedStatusCode, String expectedErrorContains) {
        block2: {
            try {
                this.reg.saml().create(entityDescriptor);
                Assert.fail((String)"Not expected to successfully register client");
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block2;
                org.junit.Assert.assertTrue((String)"Error response doesn't contain expected text", (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }
}

