/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;

public class RegistrationAccessTokenTest
extends AbstractClientRegistrationTest {
    private ClientRepresentation client;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientRepresentation c = new ClientRepresentation();
        c.setEnabled(Boolean.valueOf(true));
        c.setClientId("RegistrationAccessTokenTest");
        c.setSecret("RegistrationAccessTokenTestClientSecret");
        c.setRootUrl("http://root");
        this.client = this.createClient(c);
        this.getCleanup().addClientUuid(this.client.getId());
        c = new ClientRepresentation();
        c.setEnabled(Boolean.valueOf(true));
        c.setClientId("SomeOtherClient");
        c.setSecret("RegistrationAccessTokenTestClientSecret");
        c.setRootUrl("http://root");
        c = this.createClient(c);
        this.getCleanup().addClientUuid(c.getId());
        this.reg.auth(Auth.token((String)this.client.getRegistrationAccessToken()));
    }

    private ClientRepresentation assertRead(String id, String registrationAccess, boolean expectSuccess) throws ClientRegistrationException {
        if (expectSuccess) {
            this.reg.auth(Auth.token((String)registrationAccess));
            ClientRepresentation rep = this.reg.get(id);
            Assert.assertNotNull((Object)rep);
            return rep;
        }
        this.reg.auth(Auth.token((String)registrationAccess));
        try {
            this.reg.get(this.client.getClientId());
            Assert.fail((String)"Expected 403");
        }
        catch (Exception e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
        return null;
    }

    @Test
    public void getClientWithRegistrationToken() throws ClientRegistrationException {
        this.setTimeOffset(10);
        ClientRepresentation rep = this.reg.get(this.client.getClientId());
        Assert.assertNotNull((Object)rep);
        Assert.assertEquals((Object)this.client.getRegistrationAccessToken(), (Object)rep.getRegistrationAccessToken());
        Assert.assertNotNull((Object)rep.getRegistrationAccessToken());
        this.assertRead(this.client.getClientId(), this.client.getRegistrationAccessToken(), true);
    }

    @Test
    public void getClientWrongClient() throws ClientRegistrationException {
        try {
            this.reg.get("SomeOtherClient");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientMissingClient() throws ClientRegistrationException {
        try {
            this.reg.get("nosuch");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getClientWithBadRegistrationToken() throws ClientRegistrationException {
        String oldToken = this.client.getRegistrationAccessToken();
        this.reg.update(this.client);
        this.reg.auth(Auth.token((String)oldToken));
        try {
            this.reg.get(this.client.getClientId());
            Assert.fail((String)"Expected 401");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void updateClientWithRegistrationToken() throws ClientRegistrationException {
        this.client.setRootUrl("http://newroot");
        ClientRepresentation rep = this.reg.update(this.client);
        Assert.assertEquals((Object)"http://newroot", (Object)this.getClient(this.client.getId()).getRootUrl());
        Assert.assertNotEquals((Object)this.client.getRegistrationAccessToken(), (Object)rep.getRegistrationAccessToken());
        this.assertRead(this.client.getClientId(), this.client.getRegistrationAccessToken(), false);
        this.assertRead(this.client.getClientId(), rep.getRegistrationAccessToken(), true);
    }

    @Test
    public void updateClientWithBadRegistrationToken() throws ClientRegistrationException {
        String oldToken = this.client.getRegistrationAccessToken();
        this.reg.update(this.client);
        this.reg.auth(Auth.token((String)oldToken));
        try {
            this.reg.update(this.client);
            Assert.fail((String)"Expected 401");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
        Assert.assertEquals((Object)"http://root", (Object)this.getClient(this.client.getId()).getRootUrl());
    }

    @Test
    public void deleteClientWithRegistrationToken() throws ClientRegistrationException {
        this.reg.delete(this.client);
        Assert.assertNull((Object)this.getClient(this.client.getId()));
    }

    @Test
    public void deleteClientWithBadRegistrationToken() throws ClientRegistrationException {
        String oldToken = this.client.getRegistrationAccessToken();
        this.reg.update(this.client);
        this.reg.auth(Auth.token((String)oldToken));
        try {
            this.reg.delete(this.client);
            Assert.fail((String)"Expected 401");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
        Assert.assertNotNull((Object)this.getClient(this.client.getId()));
    }
}

