/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.adapters.authentication.JWTClientCredentialsProvider;
import org.keycloak.client.registration.Auth;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class OIDCJwksClientRegistrationTest
extends AbstractClientRegistrationTest {
    private static final String PRIVATE_KEY = "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=";
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";
    private static final String KEEP_GENERATED_KID = "KEEP_GENERATED_KID";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        testRealms.get(0).setPrivateKey(PRIVATE_KEY);
        testRealms.get(0).setPublicKey(PUBLIC_KEY);
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    private OIDCClientRepresentation createRep() {
        OIDCClientRepresentation client = new OIDCClientRepresentation();
        client.setClientName("RegistrationAccessTokenTest");
        client.setClientUri(OAuthClient.APP_ROOT);
        client.setRedirectUris(Collections.singletonList(this.oauth.getRedirectUri()));
        return client;
    }

    @Test
    public void createClientWithJWKS_generatedKid() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep.setTokenEndpointAuthMethod("private_key_jwt");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.generateKeys("RS256");
        JSONWebKeySet keySet = oidcClientEndpointsResource.getJwks();
        clientRep.setJwks(keySet);
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"private_key_jwt", (Object)response.getTokenEndpointAuthMethod());
        Assert.assertNull((Object)response.getClientSecret());
        Assert.assertNull((Object)response.getClientSecretExpiresAt());
        this.assertAuthenticateClientSuccess(generatedKeys, response, KEEP_GENERATED_KID);
    }

    @Test
    public void createClientWithJWKS_nullKid() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep.setTokenEndpointAuthMethod("private_key_jwt");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.generateKeys("RS256");
        JSONWebKeySet keySet = oidcClientEndpointsResource.getJwks();
        clientRep.setJwks(keySet);
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        this.assertAuthenticateClientSuccess(generatedKeys, response, null);
    }

    @Test
    public void createClientWithJWKS_customKid() throws Exception {
        OIDCClientRepresentation response = this.createClientWithManuallySetKid("a1");
        Map generatedKeys = this.testingClient.testApp().oidcClientEndpoints().getKeysAsPem();
        this.assertAuthenticateClientSuccess(generatedKeys, response, "a1");
    }

    private OIDCClientRepresentation createClientWithManuallySetKid(String kid) throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep.setTokenEndpointAuthMethod("private_key_jwt");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.generateKeys("RS256");
        JSONWebKeySet keySet = oidcClientEndpointsResource.getJwks();
        keySet.getKeys()[0].setKeyId(kid);
        clientRep.setJwks(keySet);
        return this.reg.oidc().create(clientRep);
    }

    @Test
    public void testTwoClientsWithSameKid() throws Exception {
        OIDCClientRepresentation response = this.createClientWithManuallySetKid("a1");
        OIDCClientRepresentation clientRep2 = this.createRep();
        clientRep2.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep2.setTokenEndpointAuthMethod("private_key_jwt");
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        PublicKey client2PublicKey = generator.generateKeyPair().getPublic();
        JSONWebKeySet keySet = new JSONWebKeySet();
        keySet.setKeys(new JWK[]{JWKBuilder.create().kid("a1").rs256(client2PublicKey)});
        clientRep2.setJwks(keySet);
        clientRep2 = this.reg.oidc().create(clientRep2);
        Map generatedKeys = this.testingClient.testApp().oidcClientEndpoints().getKeysAsPem();
        this.assertAuthenticateClientSuccess(generatedKeys, response, "a1");
        String expectedCacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)"test", (String)response.getClientId());
        Assert.assertTrue((boolean)this.testingClient.testing().cache("keys").contains(expectedCacheKey));
        this.assertAuthenticateClientError(generatedKeys, clientRep2, "a1");
    }

    @Test
    public void testPublicKeyCacheInvalidatedWhenUpdatingClient() throws Exception {
        OIDCClientRepresentation response = this.createClientWithManuallySetKid("a1");
        Map generatedKeys = this.testingClient.testApp().oidcClientEndpoints().getKeysAsPem();
        this.assertAuthenticateClientSuccess(generatedKeys, response, "a1");
        String expectedCacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)"test", (String)response.getClientId());
        Assert.assertTrue((boolean)this.testingClient.testing().cache("keys").contains(expectedCacheKey));
        response.setJwksUri("http://localhost:4321/non-existent");
        response.setJwks(null);
        this.reg.auth(Auth.token((String)response.getRegistrationAccessToken())).oidc().update(response);
        Assert.assertFalse((boolean)this.testingClient.testing().cache("keys").contains(expectedCacheKey));
        this.assertAuthenticateClientError(generatedKeys, response, "a1");
    }

    @Test
    public void createClientWithJWKSURI() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep.setTokenEndpointAuthMethod("private_key_jwt");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.generateKeys("RS256");
        clientRep.setJwksUri(TestApplicationResourceUrls.clientJwksUri());
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"private_key_jwt", (Object)response.getTokenEndpointAuthMethod());
        Assert.assertNull((Object)response.getClientSecret());
        Assert.assertNull((Object)response.getClientSecretExpiresAt());
        Assert.assertEquals((Object)response.getJwksUri(), (Object)TestApplicationResourceUrls.clientJwksUri());
        this.assertAuthenticateClientSuccess(generatedKeys, response, KEEP_GENERATED_KID);
    }

    @Test
    public void createClientWithJWKSURI_rotateClientKeys() throws Exception {
        OIDCClientRepresentation clientRep = this.createRep();
        clientRep.setGrantTypes(Collections.singletonList("client_credentials"));
        clientRep.setTokenEndpointAuthMethod("private_key_jwt");
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        Map generatedKeys = oidcClientEndpointsResource.generateKeys("RS256");
        clientRep.setJwksUri(TestApplicationResourceUrls.clientJwksUri());
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        Assert.assertEquals((Object)"private_key_jwt", (Object)response.getTokenEndpointAuthMethod());
        Assert.assertNull((Object)response.getClientSecret());
        Assert.assertNull((Object)response.getClientSecretExpiresAt());
        Assert.assertEquals((Object)response.getJwksUri(), (Object)TestApplicationResourceUrls.clientJwksUri());
        this.assertAuthenticateClientSuccess(generatedKeys, response, KEEP_GENERATED_KID);
        Map generatedKeys2 = oidcClientEndpointsResource.generateKeys("RS256");
        this.assertAuthenticateClientError(generatedKeys2, response, KEEP_GENERATED_KID);
        this.setTimeOffset(20);
        this.assertAuthenticateClientSuccess(generatedKeys2, response, KEEP_GENERATED_KID);
    }

    private void assertAuthenticateClientSuccess(Map<String, String> generatedKeys, OIDCClientRepresentation response, String kid) throws Exception {
        KeyPair keyPair = this.getKeyPairFromGeneratedPems(generatedKeys);
        String signedJwt = this.getClientSignedJWT(response.getClientId(), keyPair, kid);
        OAuthClient.AccessTokenResponse accessTokenResponse = this.doClientCredentialsGrantRequest(signedJwt);
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(accessTokenResponse.getAccessToken());
        Assert.assertEquals((Object)response.getClientId(), (Object)accessToken.getIssuedFor());
    }

    private void assertAuthenticateClientError(Map<String, String> generatedKeys, OIDCClientRepresentation response, String kid) throws Exception {
        KeyPair keyPair = this.getKeyPairFromGeneratedPems(generatedKeys);
        String signedJwt = this.getClientSignedJWT(response.getClientId(), keyPair, kid);
        OAuthClient.AccessTokenResponse accessTokenResponse = this.doClientCredentialsGrantRequest(signedJwt);
        Assert.assertEquals((long)400L, (long)accessTokenResponse.getStatusCode());
        Assert.assertNull((Object)accessTokenResponse.getAccessToken());
        Assert.assertNotNull((Object)accessTokenResponse.getError());
    }

    private KeyPair getKeyPairFromGeneratedPems(Map<String, String> generatedKeys) {
        String privateKeyPem = generatedKeys.get("privateKey");
        String publicKeyPem = generatedKeys.get("publicKey");
        PrivateKey privateKey = KeycloakModelUtils.getPrivateKey((String)privateKeyPem);
        PublicKey publicKey = KeycloakModelUtils.getPublicKey((String)publicKeyPem);
        return new KeyPair(publicKey, privateKey);
    }

    private String getClientSignedJWT(String clientId, final KeyPair keyPair, final String kid) {
        String realmInfoUrl = KeycloakUriBuilder.fromUri((URI)this.getAuthServerRoot()).path("/realms/{realm-name}").build(new Object[]{"test"}).toString();
        JWTClientCredentialsProvider jwtProvider = new JWTClientCredentialsProvider(){

            public String createSignedRequestToken(String clientId, String realmInfoUrl) {
                if (OIDCJwksClientRegistrationTest.KEEP_GENERATED_KID.equals(kid)) {
                    return super.createSignedRequestToken(clientId, realmInfoUrl);
                }
                JsonWebToken jwt = this.createRequestToken(clientId, realmInfoUrl);
                return new JWSBuilder().kid(kid).jsonContent((Object)jwt).rsa256(keyPair.getPrivate());
            }

            protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
                JsonWebToken jwt = super.createRequestToken(clientId, realmInfoUrl);
                String tokenEndpointUrl = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((URI)OIDCJwksClientRegistrationTest.this.getAuthServerRoot())).build(new Object[]{"test"}).toString();
                jwt.audience(new String[]{tokenEndpointUrl});
                return jwt;
            }
        };
        jwtProvider.setupKeyPair(keyPair);
        jwtProvider.setTokenTimeout(10);
        return jwtProvider.createSignedRequestToken(clientId, realmInfoUrl);
    }

    private OAuthClient.AccessTokenResponse doClientCredentialsGrantRequest(String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        CloseableHttpResponse response = this.sendRequest(this.oauth.getServiceAccountUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }
}

