/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;

public class MutualTLSClientTest
extends AbstractTestRealmKeycloakTest {
    private static final boolean sslRequired = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));
    private static final String CLIENT_ID = "confidential-x509";
    private static final String DISABLED_CLIENT_ID = "confidential-disabled-x509";
    private static final String EXACT_SUBJECT_DN_CLIENT_ID = "confidential-subjectdn-x509";
    private static final String OBB_SUBJECT_DN_CLIENT_ID = "obb-subjectdn-x509";
    private static final String USER = "keycloak-user@localhost";
    private static final String PASSWORD = "password";
    private static final String REALM = "test";
    private static final String EXACT_CERTIFICATE_SUBJECT_DN = "EMAILADDRESS=contact@keycloak.org, CN=Keycloak Intermediate CA, OU=Keycloak, O=Red Hat, ST=MA, C=US";

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ClientRepresentation properConfiguration = KeycloakModelUtils.createClient(testRealm, CLIENT_ID);
        properConfiguration.setServiceAccountsEnabled(Boolean.TRUE);
        properConfiguration.setRedirectUris(Arrays.asList("https://localhost:8543/auth/realms/master/app/auth"));
        properConfiguration.setClientAuthenticatorType("client-x509");
        properConfiguration.setAttributes(Collections.singletonMap("x509.subjectdn", "(.*?)(?:$)"));
        ClientRepresentation disabledConfiguration = KeycloakModelUtils.createClient(testRealm, DISABLED_CLIENT_ID);
        disabledConfiguration.setServiceAccountsEnabled(Boolean.TRUE);
        disabledConfiguration.setRedirectUris(Arrays.asList("https://localhost:8543/auth/realms/master/app/auth"));
        disabledConfiguration.setClientAuthenticatorType("client-x509");
        disabledConfiguration.setAttributes(Collections.singletonMap("x509.subjectdn", "(.*?)(?:$)"));
        ClientRepresentation exactSubjectDNConfiguration = KeycloakModelUtils.createClient(testRealm, EXACT_SUBJECT_DN_CLIENT_ID);
        exactSubjectDNConfiguration.setServiceAccountsEnabled(Boolean.TRUE);
        exactSubjectDNConfiguration.setRedirectUris(Arrays.asList("https://localhost:8543/auth/realms/master/app/auth"));
        exactSubjectDNConfiguration.setClientAuthenticatorType("client-x509");
        exactSubjectDNConfiguration.setAttributes(Collections.singletonMap("x509.subjectdn", EXACT_CERTIFICATE_SUBJECT_DN));
        ClientRepresentation obbSubjectDNConfiguration = KeycloakModelUtils.createClient(testRealm, OBB_SUBJECT_DN_CLIENT_ID);
        obbSubjectDNConfiguration.setServiceAccountsEnabled(Boolean.TRUE);
        obbSubjectDNConfiguration.setRedirectUris(Arrays.asList("https://localhost:8543/auth/realms/master/app/auth"));
        obbSubjectDNConfiguration.setClientAuthenticatorType("client-x509");
    }

    @BeforeClass
    public static void sslRequired() {
        Assume.assumeTrue((String)"\"auth.server.ssl.required\" is required for Mutual TLS tests", (boolean)sslRequired);
    }

    @Test
    public void testSuccessfulClientInvocationWithProperCertificate() throws Exception {
        Supplier<CloseableHttpClient> clientWithProperCertificate = MutualTLSUtils::newCloseableHttpClientWithDefaultKeyStoreAndTrustStore;
        OAuthClient.AccessTokenResponse token = this.loginAndGetAccessTokenResponse(CLIENT_ID, clientWithProperCertificate);
        this.assertTokenObtained(token);
    }

    @Test
    public void testSuccessfulClientInvocationWithProperCertificateAndSubjectDN() throws Exception {
        Supplier<CloseableHttpClient> clientWithProperCertificate = MutualTLSUtils::newCloseableHttpClientWithDefaultKeyStoreAndTrustStore;
        OAuthClient.AccessTokenResponse token = this.loginAndGetAccessTokenResponse(EXACT_SUBJECT_DN_CLIENT_ID, clientWithProperCertificate);
        this.assertTokenObtained(token);
    }

    @Test
    public void testSuccessfulClientInvocationWithClientIdInQueryParams() throws Exception {
        OAuthClient.AccessTokenResponse token = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            this.login(CLIENT_ID);
            token = this.getAccessTokenResponseWithQueryParams(CLIENT_ID, client);
        }
        this.assertTokenObtained(token);
    }

    @Test
    public void testFailedClientInvocationWithProperCertificateAndWrongSubjectDN() throws Exception {
        Supplier<CloseableHttpClient> clientWithProperCertificate = MutualTLSUtils::newCloseableHttpClientWithOtherKeyStoreAndTrustStore;
        OAuthClient.AccessTokenResponse token = this.loginAndGetAccessTokenResponse(EXACT_SUBJECT_DN_CLIENT_ID, clientWithProperCertificate);
        this.assertTokenNotObtained(token);
    }

    @Test
    public void testFailedClientInvocationWithoutCertificateCertificate() throws Exception {
        Supplier<CloseableHttpClient> clientWithoutCertificate = MutualTLSUtils::newCloseableHttpClientWithoutKeyStoreAndTrustStore;
        OAuthClient.AccessTokenResponse token = this.loginAndGetAccessTokenResponse(CLIENT_ID, clientWithoutCertificate);
        this.assertTokenNotObtained(token);
    }

    @Test
    public void testFailedClientInvocationWithDisabledClient() throws Exception {
        OAuthClient.AccessTokenResponse token = null;
        try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            this.login(DISABLED_CLIENT_ID);
            this.disableClient(DISABLED_CLIENT_ID);
            token = this.getAccessTokenResponse(DISABLED_CLIENT_ID, client);
        }
        this.assertTokenNotObtained(token);
    }

    @Test
    public void testClientInvocationWithOBBClient_rfc2553_resolvedAttributes() throws Exception {
        this.testClientInvocationWithOBBClient("CN=Foo,JURISDICTIONCOUNTRYNAME=BR,BUSINESSCATEGORY=Business Entity,SERIALNUMBER=2009,OU=My Org Unit,O=Red Hat,L=Boston,ST=MA,C=US", true);
    }

    @Test
    public void testClientInvocationWithOBBClient_rfc2553_unresolvedAttributes() throws Exception {
        this.testClientInvocationWithOBBClient("CN=Foo,1.3.6.1.4.1.311.60.2.1.3=#13024252,2.5.4.15=#130f427573696e65737320456e74697479,2.5.4.5=#130432303039,OU=My Org Unit,O=Red Hat,L=Boston,ST=MA,C=US", true);
    }

    @Test
    public void testClientInvocationWithOBBClient_rfc2553_invalidSubjectDN() throws Exception {
        this.testClientInvocationWithOBBClient("CN=Foo,1.3.6.1.4.1.311.60.2.1.3=#13024252,2.5.4.15=#130f427573696e65737320456e74697479,2.5.4.5=#130e3037323337333733303030313230,OU=My Org Unit,O=Red Hat,L=Boston,ST=MA,C=US", false);
    }

    @Test
    public void testClientInvocationWithOBBClient_rfc1779() throws Exception {
        this.testClientInvocationWithOBBClient("CN=Foo, JURISDICTIONCOUNTRYNAME=BR, BUSINESSCATEGORY=Business Entity, SERIALNUMBER=2009, OU=My Org Unit, O=Red Hat, L=Boston, ST=MA, C=US", true);
    }

    private void testClientInvocationWithOBBClient(String expectedSubjectDN, boolean expectSuccess) throws Exception {
        Supplier<CloseableHttpClient> clientWithProperCertificate = MutualTLSUtils::newCloseableHttpClientWithOBBKeyStoreAndTrustStore;
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.testRealm(), (String)OBB_SUBJECT_DN_CLIENT_ID);
        ClientRepresentation clientRep = client.toRepresentation();
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep);
        config.setAllowRegexPatternComparison(false);
        config.setTlsClientAuthSubjectDn(expectedSubjectDN);
        client.update(clientRep);
        OAuthClient.AccessTokenResponse token = this.loginAndGetAccessTokenResponse(OBB_SUBJECT_DN_CLIENT_ID, clientWithProperCertificate);
        if (expectSuccess) {
            this.assertTokenObtained(token);
        } else {
            this.assertTokenNotObtained(token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OAuthClient.AccessTokenResponse loginAndGetAccessTokenResponse(String clientId, Supplier<CloseableHttpClient> client) throws IOException {
        try (CloseableHttpClient closeableHttpClient = client.get();){
            this.login(clientId);
            OAuthClient.AccessTokenResponse accessTokenResponse = this.getAccessTokenResponse(clientId, closeableHttpClient);
            return accessTokenResponse;
        }
    }

    private OAuthClient.AccessTokenResponse getAccessTokenResponse(String clientId, CloseableHttpClient closeableHttpClient) {
        String code = (String)this.oauth.getCurrentQuery().get("code");
        return this.oauth.httpClient(() -> closeableHttpClient).clientId(clientId).doAccessTokenRequest(code, null, closeableHttpClient);
    }

    private void login(String clientId) {
        this.oauth.httpClient(OAuthClient::newCloseableHttpClient).clientId(clientId).doLogin(USER, PASSWORD);
    }

    private void assertTokenObtained(OAuthClient.AccessTokenResponse token) {
        Assert.assertEquals((long)200L, (long)token.getStatusCode());
        Assert.assertNotNull((Object)token.getAccessToken());
    }

    private void assertTokenNotObtained(OAuthClient.AccessTokenResponse token) {
        Assert.assertEquals((long)400L, (long)token.getStatusCode());
        Assert.assertNull((Object)token.getAccessToken());
    }

    private OAuthClient.AccessTokenResponse getAccessTokenResponseWithQueryParams(String clientId, CloseableHttpClient client) throws Exception {
        HttpPost post = new HttpPost(this.oauth.getAccessTokenUrl() + "?client_id=" + clientId);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add(new BasicNameValuePair("code", (String)this.oauth.getCurrentQuery().get("code")));
        parameters.add(new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, Charsets.UTF_8);
        post.setEntity((HttpEntity)formEntity);
        return new OAuthClient.AccessTokenResponse(client.execute((HttpUriRequest)post));
    }

    private void disableClient(String clientId) {
        ClientRepresentation disabledClientRepresentation = (ClientRepresentation)this.adminClient.realm(REALM).clients().findByClientId(clientId).get(0);
        ClientResource disabledClientResource = this.adminClient.realms().realm(REALM).clients().get(disabledClientRepresentation.getId());
        disabledClientRepresentation.setEnabled(Boolean.valueOf(false));
        disabledClientResource.update(disabledClientRepresentation);
    }
}

