/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Arrays;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.representations.idm.ClientRepresentation;

public class ClientRegistrationTester {
    public static void main(String[] args) throws ClientRegistrationException {
        ClientRepresentation rep = ClientRegistrationTester.createRep1();
        ClientRegistration reg = ClientRegistration.create().url("http://localhost:8081/auth", "test").build();
        try {
            ClientRepresentation createdRep = reg.create(rep);
            System.out.println("Created client: " + createdRep.getClientId());
        }
        catch (ClientRegistrationException ex) {
            HttpErrorException httpEx = (HttpErrorException)ex.getCause();
            System.err.println("HttpException when registering client. Status=" + httpEx.getStatusLine().getStatusCode() + ", Details=" + httpEx.getErrorResponse());
        }
    }

    private static ClientRepresentation createRep1() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setRedirectUris(Arrays.asList("http://localhost:8080/app"));
        rep.setDefaultRoles(new String[]{"foo-role"});
        return rep;
    }
}

