/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.RealmBuilder;

public class ClientRedirectTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        RealmBuilder.edit(testRealm).client(ClientBuilder.create().clientId("launchpad-test").baseUrl("").rootUrl("http://example.org/launchpad")).client(ClientBuilder.create().clientId("dummy-test").baseUrl("/base-path").rootUrl("http://example.org/dummy"));
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testClientRedirectEndpoint() throws Exception {
        this.oauth.doLogin("test-user@localhost", "password");
        this.driver.get(this.getAuthServerRoot().toString() + "realms/test/clients/launchpad-test/redirect");
        Assert.assertEquals((Object)"http://example.org/launchpad", (Object)this.driver.getCurrentUrl());
        this.driver.get(this.getAuthServerRoot().toString() + "realms/test/clients/dummy-test/redirect");
        Assert.assertEquals((Object)"http://example.org/dummy/base-path", (Object)this.driver.getCurrentUrl());
        this.driver.get(this.getAuthServerRoot().toString() + "realms/test/clients/account/redirect");
        Assert.assertEquals((Object)(this.getAuthServerRoot().toString() + "realms/test/account/"), (Object)this.driver.getCurrentUrl());
    }

    @Test
    public void testRedirectStatusCode() {
        this.oauth.doLogin("test-user@localhost", "password");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        String token = this.oauth.doAccessTokenRequest(code, "password").getAccessToken();
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        String redirectUrl = this.getAuthServerRoot().toString() + "realms/test/clients/launchpad-test/redirect";
        Response response = client.target(redirectUrl).request().header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((long)303L, (long)response.getStatus());
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedirectToDisabledClientRedirectURI() throws Exception {
        String clientId;
        this.log.debug((Object)"Creating disabled-client with redirect uri \"*\"");
        try (Response create = this.adminClient.realm("test").clients().create(ClientBuilder.create().clientId("disabled-client").enabled(false).redirectUris("*").build());){
            clientId = ApiUtil.getCreatedId((Response)create);
            Assert.assertThat((Object)create, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CREATED));
        }
        try {
            this.log.debug((Object)"log in");
            this.oauth.doLogin("test-user@localhost", "password");
            this.events.expectLogin().assertEvent();
            URI logout = KeycloakUriBuilder.fromUri((URI)this.suiteContext.getAuthServerInfo().getBrowserContextRoot().toURI()).path("auth/realms/{realm-name}/protocol/openid-connect/logout").queryParam("redirect_uri", new Object[]{"http://example.org/redirected"}).build(new Object[]{"test"});
            this.log.debug((Object)("log out using: " + logout.toURL()));
            this.driver.navigate().to(logout.toURL());
            this.log.debug((Object)("Current URL: " + this.driver.getCurrentUrl()));
            this.log.debug((Object)"check logout_error");
            this.events.expectLogoutError("invalid_redirect_uri").assertEvent();
            Assert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.equalTo((Object)"http://example.org/redirected"))));
        }
        finally {
            this.log.debug((Object)"removing disabled-client");
            this.adminClient.realm("test").clients().get(clientId).remove();
        }
    }
}

