/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientPolicyRepresentation;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientPoliciesImportExportTest
extends AbstractClientPoliciesTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Override
    public void beforeAbstractKeycloakTestRealmImport() {
        this.removeAllRealmsDespiteMaster();
    }

    @Test
    public void testSingleFileRealmExportImport() throws Throwable {
        this.testingClient.testing().exportImport().setProvider("singleFile");
        String targetFilePath = this.testingClient.testing().exportImport().getExportImportTestDirectory() + File.separator + "client-policies-exported-realm.json";
        this.testingClient.testing().exportImport().setFile(targetFilePath);
        this.setupValidProfilesAndPolicies();
        this.testRealmExportImport();
    }

    private void testRealmExportImport() throws Exception {
        this.testingClient.testing().exportImport().setAction("export");
        this.testingClient.testing().exportImport().setRealmName("test");
        this.testingClient.testing().exportImport().runExport();
        this.adminClient.realm("test").remove();
        Assert.assertNames(this.adminClient.realms().findAll(), "master");
        this.testingClient.testing().exportImport().setAction("import");
        this.testingClient.testing().exportImport().runImport();
        Assert.assertNames(this.adminClient.realms().findAll(), "master", "test");
        this.assertExpectedLoadedProfiles(reps -> {
            ClientProfileRepresentation rep = this.getProfileRepresentation((ClientProfilesRepresentation)reps, "ordinal-test-profile", false);
            this.assertExpectedProfile(rep, "ordinal-test-profile", "The profile that can be loaded.");
        });
        this.assertExpectedLoadedPolicies(reps -> {
            ClientPolicyRepresentation rep = this.getPolicyRepresentation((ClientPoliciesRepresentation)reps, "new-policy");
            this.assertExpectedPolicy("new-policy", "duplicated profiles are ignored.", true, Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"), rep);
        });
    }
}

