/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Set;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.info.ServerInfoRepresentation;
import org.keycloak.representations.info.SpiInfoRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;

public class ClientPoliciesFeatureTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testFeatureWorksWhenEnabled() {
        this.checkIfFeatureWorks(true);
    }

    @Test
    @UncaughtServerErrorExpected
    @DisableFeature(value=Profile.Feature.CLIENT_POLICIES, skipRestart=true)
    public void testFeatureDoesntWorkWhenDisabled() {
        this.checkIfFeatureWorks(false);
    }

    private void checkIfFeatureWorks(boolean shouldWork) {
        block5: {
            try {
                ClientPoliciesRepresentation clientPolicies = this.testRealm().clientPoliciesPoliciesResource().getPolicies();
                Assert.assertTrue((boolean)clientPolicies.getPolicies().isEmpty());
                if (!shouldWork) {
                    org.junit.Assert.fail((String)"Feature is available, but at this moment should be disabled");
                }
            }
            catch (Exception e) {
                if (!shouldWork) break block5;
                e.printStackTrace();
                org.junit.Assert.fail((String)"Feature is not available");
            }
        }
        ServerInfoRepresentation serverInfo = this.adminClient.serverInfo().getInfo();
        Set executorProviderIds = ((SpiInfoRepresentation)serverInfo.getProviders().get("client-policy-executor")).getProviders().keySet();
        Set conditionProviderIds = ((SpiInfoRepresentation)serverInfo.getProviders().get("client-policy-condition")).getProviders().keySet();
        if (shouldWork) {
            Assert.assertTrue((boolean)executorProviderIds.contains("secure-response-type"));
            Assert.assertTrue((boolean)conditionProviderIds.contains("client-updater-context"));
        } else {
            Assert.assertFalse((boolean)executorProviderIds.contains("secure-response-type"));
            Assert.assertFalse((boolean)conditionProviderIds.contains("client-updater-context"));
        }
    }
}

