/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelRequest;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor.SecureCibaSignedAuthenticationRequestExecutor;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class CIBATest
extends AbstractClientPoliciesTest {
    private static final String TEST_USER_NAME = "test-user@localhost";
    private final String SECOND_TEST_CLIENT_NAME = "test-second-client";
    private final String SECOND_TEST_CLIENT_SECRET = "passwort-test-second-client";
    private static final String ERR_MSG_CLIENT_REG_FAIL = "Failed to send request";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);
    private String cibaBackchannelTokenDeliveryMode;
    private Integer cibaExpiresIn;
    private Integer cibaInterval;
    private String cibaAuthRequestedUserHint;
    private final String TEST_REALM_NAME = "test";
    private final String TEST_CLIENT_NAME = "test-app";
    private final String TEST_CLIENT_PASSWORD = "password";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        UserRepresentation user = UserBuilder.create().username("nutzername-schwarz").email("schwarz@test.example.com").enabled(true).password("passwort-schwarz").addRoles("user", "offline_access").build();
        realm.getUsers().add(user);
        user = UserBuilder.create().username("nutzername-rot").email("rot@test.example.com").enabled(true).password("passwort-rot").addRoles("user", "offline_access").build();
        realm.getUsers().add(user);
        user = UserBuilder.create().username("nutzername-gelb").email("gelb@test.example.com").enabled(true).password("passwort-gelb").addRoles("user", "offline_access").build();
        realm.getUsers().add(user);
        user = UserBuilder.create().username("nutzername-deaktiviert").email("deaktiviert@test.example.com").enabled(false).password("passwort-deaktiviert").addRoles("user", "offline_access").build();
        realm.getUsers().add(user);
        ClientRepresentation confApp = org.keycloak.testsuite.util.KeycloakModelUtils.createClient(realm, "test-second-client");
        confApp.setSecret("passwort-test-second-client");
        confApp.setServiceAccountsEnabled(Boolean.TRUE);
        testRealms.add(realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttackerClientUseVictimAuthReqIdAttack() throws Exception {
        ClientResource victimClientResource = null;
        ClientResource attackerClientResource = null;
        ClientRepresentation victimClientRep = null;
        ClientRepresentation attackerClientRep = null;
        try {
            String username = "nutzername-gelb";
            String victimClientName = "test-app-scope";
            String attackerClientName = "test-app";
            String victimClientPassword = "password";
            String attackerClientPassword = "password";
            String victimClientAuthReqId = null;
            victimClientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app-scope");
            victimClientRep = victimClientResource.toRepresentation();
            this.prepareCIBASettings(victimClientResource, victimClientRep);
            attackerClientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            attackerClientRep = attackerClientResource.toRepresentation();
            this.prepareCIBASettings(attackerClientResource, attackerClientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app-scope", "password", "nutzername-gelb", "asdfghjkl");
            victimClientAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest victimClientAuthenticationChannelReq = this.doAuthenticationChannelRequest("asdfghjkl");
            this.doAuthenticationChannelCallback(victimClientAuthenticationChannelReq);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", victimClientAuthReqId);
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"invalid_grant")));
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"unauthorized client")));
            this.revertCIBASettings(victimClientResource, victimClientRep);
            this.revertCIBASettings(attackerClientResource, attackerClientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(victimClientResource, victimClientRep);
            this.revertCIBASettings(attackerClientResource, attackerClientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttackerClientUseAuthReqIdInCallbackEndpoint() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION");
            int statusCode = this.oauth.doAuthenticationChannelCallback(response.getAuthReqId(), AuthenticationChannelResponse.Status.SUCCEED);
            MatcherAssert.assertThat((Object)statusCode, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)403)));
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"authorization_pending")));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationChannelUnexpectedError() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String signal = "GODOWN";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "GODOWN", null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)503)));
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"invalid_grant")));
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Invalid Auth Req ID")));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackchannelAuthnReqWithDeactivatedUser() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-deaktiviert";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-deaktiviert", null, "acr2");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackchannelAuthnReqWithUnknownUser() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "Unbekannt";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "Unbekannt", "BASTION", "urn:mace:incommon:iap:silver urn:mace:incommon:iap:gold");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackchannelAuthnReqWithoutLoginHint() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = null;
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", username, "BASTION", "ACR1");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginHintTokenRequiredButNotSend() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-schwarz";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaAuthRequestedUserHint", "login_hint_token");
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-schwarz", null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Should never happen because the AD does not send any information about the user but only the status of the authentication")
    public void testDifferentUserAuthenticated() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String usernameToBeAuthenticated = "nutzername-rot";
            String usernameAuthenticated = "nutzername-gelb";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("BASTION");
            MatcherAssert.assertThat((Object)authenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"offline_access")));
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenRevocation() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            this.oauth.scope("offline_access");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("BASTION");
            MatcherAssert.assertThat((Object)authenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"offline_access")));
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(authenticationChannelReq);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, true);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doTokenRevokeByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, true);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeInterval() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String firstUsername = "nutzername-schwarz";
            String secondUsername = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-schwarz", "lbies8e");
            MatcherAssert.assertThat((Object)response.getInterval(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)5)));
            this.doAuthenticationChannelRequest("lbies8e");
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaExpiresIn", String.valueOf(1200));
            attrMap.put("cibaInterval", String.valueOf(10));
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "Keb9eser");
            MatcherAssert.assertThat((Object)response.getInterval(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)10)));
            this.doAuthenticationChannelRequest("Keb9eser");
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessThrottling() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaInterval", String.valueOf(3));
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("BASTION");
            MatcherAssert.assertThat((Object)authenticationChannelReq.getRequest().getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"BASTION")));
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"authorization_pending"));
            tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"slow_down"));
            tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"slow_down"));
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(authenticationChannelReq);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            this.setTimeOffset(3);
            tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, false);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doTokenRevokeByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, false);
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenRequestAfterIntervalButNotYetAuthenticated() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaInterval", String.valueOf(5));
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION");
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"authorization_pending"));
            tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"slow_down"));
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("BASTION");
            MatcherAssert.assertThat((Object)authenticationChannelReq.getRequest().getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"BASTION")));
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(authenticationChannelReq);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            this.setTimeOffset(5);
            tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, false);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doTokenRevokeByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, false);
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    @Test
    public void testCIBAPolicy() {
        try {
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaBackchannelTokenDeliveryMode", null);
            attrMap.put("cibaExpiresIn", null);
            attrMap.put("cibaInterval", null);
            attrMap.put("cibaAuthRequestedUserHint", null);
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            rep = this.testRealm().toRepresentation();
            attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            MatcherAssert.assertThat(attrMap.get("cibaBackchannelTokenDeliveryMode"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"poll")));
            MatcherAssert.assertThat((Object)Integer.parseInt((String)attrMap.get("cibaExpiresIn")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)120)));
            MatcherAssert.assertThat((Object)Integer.parseInt((String)attrMap.get("cibaInterval")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)5)));
            MatcherAssert.assertThat(attrMap.get("cibaAuthRequestedUserHint"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"login_hint")));
            rep = this.backupCIBAPolicy();
            attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaBackchannelTokenDeliveryMode", "poll");
            attrMap.put("cibaExpiresIn", String.valueOf(736));
            attrMap.put("cibaInterval", String.valueOf(7));
            attrMap.put("cibaAuthRequestedUserHint", "login_hint");
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            rep = this.testRealm().toRepresentation();
            MatcherAssert.assertThat(attrMap.get("cibaBackchannelTokenDeliveryMode"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"poll")));
            MatcherAssert.assertThat((Object)Integer.parseInt((String)attrMap.get("cibaExpiresIn")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)736)));
            MatcherAssert.assertThat((Object)Integer.parseInt((String)attrMap.get("cibaInterval")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)7)));
            MatcherAssert.assertThat(attrMap.get("cibaAuthRequestedUserHint"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"login_hint")));
        }
        finally {
            this.restoreCIBAPolicy();
        }
    }

    @Test
    public void testBackchannelAuthenticationFlow() throws Exception {
        this.testBackchannelAuthenticationFlow(false);
    }

    @Test
    public void testBackchannelAuthenticationFlowOfflineAccess() throws Exception {
        this.testBackchannelAuthenticationFlow(true);
    }

    @Test
    public void testBackchannelAuthenticationFlowWithoutBindingMessage() throws Exception {
        this.testBackchannelAuthenticationFlow(false, null);
    }

    @Test
    public void testBackchannelAuthenticationFlowOfflineAccessWithoutBindingMessage() throws Exception {
        this.testBackchannelAuthenticationFlow(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackchannelClientValidations() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            try {
                attributes.put("ciba.backchannel.token.delivery.mode", "ping");
                attributes.put("ciba.backchannel.client.notification.endpoint", null);
                attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
                clientRep.setAttributes(attributes);
                clientResource.update(clientRep);
                org.junit.Assert.fail((String)"Not expected to successfully update client");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            attributes.put("ciba.backchannel.client.notification.endpoint", TestApplicationResourceUrls.cibaClientNotificationEndpointUri());
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            org.junit.Assert.assertEquals((Object)"ping", attributes.get("ciba.backchannel.token.delivery.mode"));
            org.junit.Assert.assertEquals((Object)TestApplicationResourceUrls.cibaClientNotificationEndpointUri(), attributes.get("ciba.backchannel.client.notification.endpoint"));
            try {
                attributes.put("ciba.backchannel.token.delivery.mode", "push");
                clientResource.update(clientRep);
                org.junit.Assert.fail((String)"Not expected to successfully update client");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            try {
                attributes.put("ciba.backchannel.token.delivery.mode", "ping");
                attributes.put("ciba.backchannel.auth.request.signing.alg", "HS256");
                clientResource.update(clientRep);
                org.junit.Assert.fail((String)"Not expected to successfully update client");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            attributes.put("ciba.backchannel.auth.request.signing.alg", "PS256");
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            org.junit.Assert.assertEquals((Object)"PS256", attributes.get("ciba.backchannel.auth.request.signing.alg"));
            attributes.remove("ciba.backchannel.auth.request.signing.alg");
            clientResource.update(clientRep);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPingMode_requestWithInvalidClientNotificationShouldFail() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep, "ping");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION_PING", null, null, Collections.emptyMap());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            String clientNotificationLongerThan1024Characters = "123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789_123456789123456789123465789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789";
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION_PING", null, clientNotificationLongerThan1024Characters, Collections.emptyMap());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPingModeSuccess() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION_PING";
            String clientNotificationToken = "client-notification-token-1";
            HashMap<String, String> additionalParameters = new HashMap<String, String>();
            additionalParameters.put("user_device", "mobile");
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep, "ping");
            long startTime = Time.currentTime();
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "BASTION_PING", "client-notification-token-1", additionalParameters);
            org.junit.Assert.assertTrue((response.getInterval() > 0 ? 1 : 0) != 0);
            TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest("BASTION_PING");
            AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
            MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"BASTION_PING")));
            MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            MatcherAssert.assertThat(authenticationChannelReq.getAdditionalParameters().get("user_device"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"mobile")));
            ClientNotificationEndpointRequest pushedClientNotification = this.testingClient.testApp().oidcClientEndpoints().getPushedCibaClientNotification("client-notification-token-1");
            org.junit.Assert.assertNull((Object)pushedClientNotification.getAuthReqId());
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(testRequest);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            pushedClientNotification = this.testingClient.testApp().oidcClientEndpoints().getPushedCibaClientNotification("client-notification-token-1");
            org.junit.Assert.assertEquals((Object)pushedClientNotification.getAuthReqId(), (Object)response.getAuthReqId());
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
            long currentTime = Time.currentTime();
            long authTime = idToken.getAuth_time();
            org.junit.Assert.assertTrue((startTime - 5L <= authTime ? 1 : 0) != 0);
            org.junit.Assert.assertTrue((authTime <= currentTime + 5L ? 1 : 0) != 0);
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, false);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doLogoutByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, false);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPingMode_clientNotificationSentEvenForUserCancel() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep, "ping");
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "kwq26rfjs73", "client-notification-some", Collections.emptyMap());
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("kwq26rfjs73");
            this.doAuthenticationChannelCallbackError(Response.Status.OK, "test-app", authenticationChannelReq, AuthenticationChannelResponse.Status.CANCELLED, "nutzername-rot", "not_allowed");
            ClientNotificationEndpointRequest pushedClientNotification = this.testingClient.testApp().oidcClientEndpoints().getPushedCibaClientNotification("client-notification-some");
            org.junit.Assert.assertEquals((Object)pushedClientNotification.getAuthReqId(), (Object)response.getAuthReqId());
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode())));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"access_denied"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleUsersBackchannelAuthenticationFlows() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String firstUsername = "nutzername-schwarz";
            String secondUsername = "nutzername-rot";
            String firstUserAuthReqId = null;
            String secondUserAuthReqId = null;
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-schwarz", "Pjb9eD8w");
            firstUserAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest firstUserAuthenticationChannelReq = this.doAuthenticationChannelRequest("Pjb9eD8w");
            EventRepresentation firstUserloginEvent = this.doAuthenticationChannelCallback(firstUserAuthenticationChannelReq);
            String firstUserSessionId = firstUserloginEvent.getSessionId();
            String firstUserSessionCodeId = (String)firstUserloginEvent.getDetails().get("code_id");
            response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "dEkg8vDdsl");
            secondUserAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest secondUserAuthenticationChannelReq = this.doAuthenticationChannelRequest("dEkg8vDdsl");
            EventRepresentation secondUserloginEvent = this.doAuthenticationChannelCallback(secondUserAuthenticationChannelReq);
            String secondUserSessionId = secondUserloginEvent.getSessionId();
            String secondUserSessionCodeId = (String)secondUserloginEvent.getDetails().get("code_id");
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", secondUserAuthReqId);
            tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-schwarz", firstUserAuthReqId);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitConsentRequiredBackchannelAuthenticationFlows() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-gelb";
            String clientName = "third-party";
            String clientPassword = "password";
            String clientAuthReqId = null;
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"third-party");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("third-party", "password", "nutzername-gelb", "asdfghjkl");
            clientAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest clientAuthenticationChannelReq = this.doAuthenticationChannelRequest("asdfghjkl");
            org.junit.Assert.assertTrue((boolean)clientAuthenticationChannelReq.getRequest().getConsentRequired());
            MatcherAssert.assertThat((Object)clientAuthenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            MatcherAssert.assertThat((Object)clientAuthenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"email")));
            MatcherAssert.assertThat((Object)clientAuthenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"profile")));
            MatcherAssert.assertThat((Object)clientAuthenticationChannelReq.getRequest().getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"roles")));
            EventRepresentation clientloginEvent = this.doAuthenticationChannelCallback(clientAuthenticationChannelReq);
            String clientSessionId = clientloginEvent.getSessionId();
            String clientSessionCodeId = (String)clientloginEvent.getDetails().get("code_id");
            OAuthClient.AccessTokenResponse accessTokenResponse = this.doBackchannelAuthenticationTokenRequest("third-party", "password", "nutzername-gelb", clientAuthReqId);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleClientsBackchannelAuthenticationFlows() throws Exception {
        ClientResource firstClientResource = null;
        ClientResource secondClientResource = null;
        ClientRepresentation firstClientRep = null;
        ClientRepresentation secondClientRep = null;
        try {
            String username = "nutzername-gelb";
            String firstClientName = "test-app-scope";
            String secondClientName = "test-app";
            String firstClientPassword = "password";
            String secondClientPassword = "password";
            String firstClientAuthReqId = null;
            String secondClientAuthReqId = null;
            firstClientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app-scope");
            MatcherAssert.assertThat((Object)firstClientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            firstClientRep = firstClientResource.toRepresentation();
            this.prepareCIBASettings(firstClientResource, firstClientRep);
            secondClientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)secondClientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            secondClientRep = secondClientResource.toRepresentation();
            this.prepareCIBASettings(secondClientResource, secondClientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app-scope", "password", "nutzername-gelb", "asdfghjkl");
            firstClientAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest firstClientAuthenticationChannelReq = this.doAuthenticationChannelRequest("asdfghjkl");
            EventRepresentation firstClientloginEvent = this.doAuthenticationChannelCallback(firstClientAuthenticationChannelReq);
            response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-gelb", "qwertyui");
            secondClientAuthReqId = response.getAuthReqId();
            TestAuthenticationChannelRequest secondClientAuthenticationChannelReq = this.doAuthenticationChannelRequest("qwertyui");
            EventRepresentation secondClientloginEvent = this.doAuthenticationChannelCallback(secondClientAuthenticationChannelReq);
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("test-app", "password", "nutzername-gelb", secondClientAuthReqId);
            tokenRes = this.doBackchannelAuthenticationTokenRequest("test-app-scope", "password", "nutzername-gelb", firstClientAuthReqId);
            this.revertCIBASettings(firstClientResource, firstClientRep);
            this.revertCIBASettings(secondClientResource, secondClientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(firstClientResource, firstClientRep);
            this.revertCIBASettings(secondClientResource, secondClientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTokenBeforeAuthenticationNotCompleted() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "kvoDKw98");
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"authorization_pending"));
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("kvoDKw98");
            this.doAuthenticationChannelCallback(authenticationChannelReq);
            this.setTimeOffset(6);
            tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
            IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
            MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"nutzername-rot")));
            AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
            MatcherAssert.assertThat((Object)accessToken, (Matcher)org.hamcrest.Matchers.notNullValue());
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTokenAfterAuthReqIdExpired() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaExpiresIn", String.valueOf(60));
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "obkes8dke1");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("obkes8dke1");
            this.doAuthenticationChannelCallback(authenticationChannelReq);
            this.setTimeOffset(70);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"expired_token"));
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackAfterAuthenticationRequestExpired() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            RealmRepresentation rep = this.backupCIBAPolicy();
            Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
            attrMap.put("cibaExpiresIn", String.valueOf(60));
            rep.setAttributes(attrMap);
            this.testRealm().update(rep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "3FIekcs9");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("3FIekcs9");
            this.setTimeOffset(70);
            int statusCode = this.oauth.doAuthenticationChannelCallback(authenticationChannelReq.getBearerToken(), AuthenticationChannelResponse.Status.SUCCEED);
            MatcherAssert.assertThat((Object)statusCode, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode())));
            this.events.expect(EventType.LOGIN_ERROR).clearDetails().client((String)null).error("invalid_token").user((String)null).session((Matcher<String>)CoreMatchers.nullValue(String.class)).assertEvent();
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            this.restoreCIBAPolicy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicatedTokenRequestWithSameAuthReqId() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-gelb";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-gelb", "kciwje86");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("kciwje86");
            this.doAuthenticationChannelCallback(authenticationChannelReq);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
            IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
            MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"nutzername-gelb")));
            AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
            tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherClientSendTokenRequest() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "ldkq366");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("ldkq366");
            this.doAuthenticationChannelCallback(authenticationChannelReq);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-second-client", "passwort-test-second-client", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    @Test
    public void testAuthenticationChannelUnauthorized() throws Exception {
        this.testAuthenticationChannelErrorCase(Response.Status.OK, Response.Status.BAD_REQUEST, AuthenticationChannelResponse.Status.UNAUTHORIZED, "access_denied", "consent_denied");
    }

    @Test
    public void testAuthenticationChannelCancelled() throws Exception {
        this.testAuthenticationChannelErrorCase(Response.Status.OK, Response.Status.BAD_REQUEST, AuthenticationChannelResponse.Status.CANCELLED, "access_denied", "not_allowed");
    }

    @Test
    public void testAuthenticationChannelUnknown() throws Exception {
        this.testAuthenticationChannelErrorCase(Response.Status.BAD_REQUEST, Response.Status.BAD_REQUEST, null, "authorization_pending", "invalid_request");
    }

    @Test
    public void testInvalidConsumptionDeviceRegistration() throws Exception {
        try {
            this.createClientDynamically("invalid-CIBA-CD", clientRep -> clientRep.setBackchannelTokenDeliveryMode("pushpush"));
            org.junit.Assert.fail();
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((Object)ERR_MSG_CLIENT_REG_FAIL, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCibaGrantDeactivated() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", null);
            attributes.put("ciba.backchannel.auth.request.signing.alg", "RS256");
            clientRep.setAttributes(attributes);
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            org.junit.Assert.assertNull(clientRep.getAttributes().get("oidc.ciba.grant.enabled"));
            org.junit.Assert.assertThat(clientRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"), (Matcher)org.hamcrest.Matchers.is((Object)"RS256"));
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "gilwekDe3", "acr2");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)401)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Client not allowed OIDC CIBA Grant"));
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            attributes = clientRep.getAttributes();
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            attributes.put("ciba.backchannel.auth.request.signing.alg", "ES256");
            clientRep.setAttributes(attributes);
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            org.junit.Assert.assertThat(clientRep.getAttributes().get("oidc.ciba.grant.enabled"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.TRUE.toString()));
            org.junit.Assert.assertThat(clientRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"), (Matcher)org.hamcrest.Matchers.is((Object)"ES256"));
            response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "Fkb4T3s");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("Fkb4T3s");
            this.doAuthenticationChannelCallback(authenticationChannelReq);
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            attributes = clientRep.getAttributes();
            attributes.put("oidc.ciba.grant.enabled", Boolean.FALSE.toString());
            attributes.put("ciba.backchannel.auth.request.signing.alg", "none");
            clientRep.setAttributes(attributes);
            clientResource.update(clientRep);
            clientRep = clientResource.toRepresentation();
            org.junit.Assert.assertThat(clientRep.getAttributes().get("oidc.ciba.grant.enabled"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE.toString()));
            org.junit.Assert.assertThat(clientRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"), (Matcher)org.hamcrest.Matchers.is((Object)"none"));
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-second-client", "passwort-test-second-client", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Client not allowed OIDC CIBA Grant"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    @Test
    public void testCibaGrantSettingByDynamicClientRegistration() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName("valid-CIBA-CD"), clientRep -> {});
        OIDCClientRepresentation rep = this.getClientDynamically(clientId);
        org.junit.Assert.assertFalse((boolean)rep.getGrantTypes().contains("urn:openid:params:grant-type:ciba"));
        org.junit.Assert.assertNull((Object)rep.getBackchannelAuthenticationRequestSigningAlg());
        this.updateClientDynamically(clientId, clientRep -> {
            List grantTypes = Optional.ofNullable(clientRep.getGrantTypes()).orElse(new ArrayList());
            grantTypes.add("urn:openid:params:grant-type:ciba");
            clientRep.setGrantTypes(grantTypes);
            clientRep.setBackchannelAuthenticationRequestSigningAlg("PS256");
        });
        rep = this.getClientDynamically(clientId);
        org.junit.Assert.assertTrue((boolean)rep.getGrantTypes().contains("urn:openid:params:grant-type:ciba"));
        org.junit.Assert.assertThat((Object)rep.getBackchannelAuthenticationRequestSigningAlg(), (Matcher)org.hamcrest.Matchers.is((Object)"PS256"));
    }

    @Test
    public void testBackchannelAuthenticationFlowWithSignedAuthenticationRequestParam() throws Exception {
        this.testBackchannelAuthenticationFlowWithSignedAuthenticationRequest(false, "PS256");
    }

    @Test
    public void testBackchannelAuthenticationFlowWithSignedAuthenticationRequestUriParam() throws Exception {
        this.testBackchannelAuthenticationFlowWithSignedAuthenticationRequest(true, "ES256");
    }

    @Test
    public void testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequestUriParam() throws Exception {
        this.testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(true, "none", 400, "None signed algorithm is not allowed");
    }

    @Test
    public void testSecureCibaSessionEnforceExecutor() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName("valid-CIBA-CD"), clientRep -> {
            List grantTypes = Optional.ofNullable(clientRep.getGrantTypes()).orElse(new ArrayList());
            grantTypes.add("urn:openid:params:grant-type:ciba");
            clientRep.setGrantTypes(grantTypes);
        });
        OIDCClientRepresentation rep = this.getClientDynamically(clientId);
        String clientSecret = rep.getClientSecret();
        String username = "nutzername-rot";
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("user_device", "mobile");
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Le Premier Profil").addExecutor("secure-ciba-session", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientId, clientSecret, username, null, null, null, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
        MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter: binding_message"));
    }

    @Test
    public void testSecureCibaSessionEnforceExecutorWithSignedAuthenticationRequestParam() throws Exception {
        this.testSecureCibaSessionEnforceExecutor(false);
    }

    @Test
    public void testSecureCibaSessionEnforceExecutorWithSignedAuthenticationRequestUriParam() throws Exception {
        this.testSecureCibaSessionEnforceExecutor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest() throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            boolean useRequestUri = false;
            String sigAlg = "PS256";
            String username = "nutzername-rot";
            String bindingMessage = "Flughafen-Frankfurt-am-Main";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Le Premier Profil").addExecutor("secure-ciba-signed-authn-req", null).toRepresentation()).toString();
            this.updateProfiles(json);
            json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
            this.updatePolicies(json);
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.nbf(requestObject.getIat());
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the signed authentication request: exp"));
            useRequestUri = true;
            bindingMessage = "Flughafen-Wien-Schwechat";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the signed authentication request: nbf"));
            useRequestUri = false;
            bindingMessage = "Stuttgart-Hauptbahnhof";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + (long)SecureCibaSignedAuthenticationRequestExecutor.DEFAULT_AVAILABLE_PERIOD.intValue() + 10L));
            requestObject.nbf(requestObject.getIat());
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"signed authentication request's available period is long"));
            useRequestUri = true;
            bindingMessage = "Flughafen-Wien-Schwechat";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(null);
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the 'request' object: aud"));
            useRequestUri = false;
            bindingMessage = "Stuttgart-Hauptbahnhof";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{"https://example.com"});
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Invalid parameter in the 'request' object: aud"));
            useRequestUri = true;
            bindingMessage = "Flughafen-Wien-Schwechat";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the 'request' object: iss"));
            useRequestUri = false;
            bindingMessage = "Stuttgart-Hauptbahnhof";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
            requestObject.issuer("test-apptest-app");
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Invalid parameter in the 'request' object: iss"));
            useRequestUri = true;
            bindingMessage = "Flughafen-Wien-Schwechat";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
            requestObject.issuer("test-app");
            requestObject.iat(null);
            requestObject.id(null);
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the signed authentication request: iat"));
            useRequestUri = false;
            bindingMessage = "Stuttgart-Hauptbahnhof";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
            requestObject.issuer("test-app");
            requestObject.iat(Long.valueOf(Time.currentTime()));
            requestObject.id(null);
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter in the signed authentication request: jti"));
            useRequestUri = true;
            bindingMessage = "Brno-hlavni-nadrazif";
            requestObject = this.createPartialAuthorizationEndpointRequestObject("nutzername-rot", bindingMessage);
            requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
            requestObject.nbf(requestObject.getIat());
            requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
            requestObject.issuer("test-app");
            requestObject.id(KeycloakModelUtils.generateId());
            requestObject.iat(Long.valueOf(Time.currentTime()));
            this.registerSharedAuthenticationRequest(requestObject, "test-app", sigAlg, useRequestUri);
            response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage);
            TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest(bindingMessage);
            AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
            MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)bindingMessage)));
            MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            this.doAuthenticationChannelCallback(testRequest);
            this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    private TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject createPartialAuthorizationEndpointRequestObject(String username, String bindingMessage) throws Exception {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.setScope("openid");
        requestObject.setMax_age(Integer.valueOf(600));
        requestObject.setOtherClaims("custom_claim_zwei", (Object)"gelb");
        requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
        requestObject.setLoginHint(username);
        requestObject.setBindingMessage(bindingMessage);
        return requestObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSecureCibaSessionEnforceExecutor(boolean useRequestUri) throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String sigAlg = "PS256";
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject sharedAuthenticationRequest = this.createValidSharedAuthenticationRequest();
            sharedAuthenticationRequest.setLoginHint("nutzername-rot");
            this.registerSharedAuthenticationRequest(sharedAuthenticationRequest, "test-app", sigAlg, useRequestUri);
            String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Le Premier Profil").addExecutor("secure-ciba-session", null).toRepresentation()).toString();
            this.updateProfiles(json);
            json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
            this.updatePolicies(json);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", null, null, null, null);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_request"));
            MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Missing parameter: binding_message"));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    private RealmResource testRealm() {
        return this.adminClient.realm("test");
    }

    @Test
    public void testBackchannelAuthenticationFlowRegisterDifferentSigAlgInAdvanceWithSignedAuthenticationRequestParam() throws Exception {
        this.testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(false, "ES256", "PS256", 400, "invalid_request", "Client requested algorithm not registered in advance or request signed with different algorithm other than client requested algorithm", "test-app", "password");
    }

    @Test
    public void testBackchannelAuthenticationFlowRegisterDifferentSigAlgInAdvanceWithSignedAuthenticationRequestUriParam() throws Exception {
        this.testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(true, "PS256", "ES256", 400, "invalid_request", "Client requested algorithm not registered in advance or request signed with different algorithm other than client requested algorithm", "test-app", "password");
    }

    @Test
    public void testBackchannelAuthenticationFlowNotRegisterSigAlgInAdvanceWithSignedAuthenticationRequestParam() throws Exception {
        this.testBackchannelAuthenticationFlowNotRegisterSigAlgInAdvanceWithSignedAuthentication("valid-CIBA-CD-Ein", false, null, "ES256", 400, "Client requested algorithm not registered in advance or request signed with different algorithm other than client requested algorithm");
    }

    @Test
    public void testBackchannelAuthenticationFlowNotRegisterSigAlgInAdvanceWithSignedAuthenticationRequestUriParam() throws Exception {
        this.testBackchannelAuthenticationFlowNotRegisterSigAlgInAdvanceWithSignedAuthentication("valid-CIBA-CD-Zwei", true, null, "PS256", 400, "Client requested algorithm not registered in advance or request signed with different algorithm other than client requested algorithm");
    }

    @Test
    public void testExtendedClientPolicyInterfacesForBackchannelAuthenticationRequest() throws Exception {
        String clientId = this.generateSuffixedName("confidential-app");
        String clientSecret = "app-secret";
        this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            clientRep.setAttributes(attributes);
        });
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleName = "sample-client-role-alpha";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        clientResource.roles().create(RoleBuilder.create().name(roleName).build());
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientId, clientSecret, TEST_USER_NAME, "Pjb9eD8w", null, null, null);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatusCode());
        org.junit.Assert.assertEquals((Object)ClientPolicyEvent.BACKCHANNEL_AUTHENTICATION_REQUEST.toString(), (Object)response.getError());
        org.junit.Assert.assertEquals((Object)"Exception thrown intentionally", (Object)response.getErrorDescription());
    }

    @Test
    public void testExtendedClientPolicyInterfacesForBackchannelTokenRequest() throws Exception {
        String clientId = this.generateSuffixedName("confidential-app");
        String clientSecret = "app-secret";
        this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            clientRep.setAttributes(attributes);
        });
        String bindingMessage = "BASTION";
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("user_device", "mobile");
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientId, clientSecret, TEST_USER_NAME, "BASTION", null, null, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        org.junit.Assert.assertNotNull((Object)response.getAuthReqId());
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        TestAuthenticationChannelRequest authenticationChannelReq = oidcClientEndpointsResource.getAuthenticationChannel("BASTION");
        int statusCode = this.oauth.doAuthenticationChannelCallback(authenticationChannelReq.getBearerToken(), AuthenticationChannelResponse.Status.SUCCEED);
        MatcherAssert.assertThat((Object)statusCode, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleName = "sample-client-role-alpha";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        clientResource.roles().create(RoleBuilder.create().name(roleName).build());
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientId, clientSecret, response.getAuthReqId());
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
        MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Exception thrown intentionally"));
    }

    @Test
    public void testSecureCibaAuthenticationRequestSigningAlgorithmEnforceExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-ciba-req-sig-algorithm", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forsta Policyn", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByInitialAccessToken", "ByRegistrationAccessToken"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName("App-by-Admin"), clientRep -> {
                clientRep.setSecret("secret");
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("ciba.backchannel.auth.request.signing.alg", "none");
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String cAppAdminId = this.createClientByAdmin(this.generateSuffixedName("App-by-Admin"), clientRep -> {
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("ciba.backchannel.auth.request.signing.alg", "ES256");
        });
        ClientRepresentation cRep = this.getClientByAdmin(cAppAdminId);
        org.junit.Assert.assertEquals((Object)"ES256", cRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        String cAppAdmin2Id = this.createClientByAdmin(this.generateSuffixedName("App-by-Admin2"), client2Rep -> {});
        ClientRepresentation cRep2 = this.getClientByAdmin(cAppAdmin2Id);
        org.junit.Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        try {
            this.updateClientByAdmin(cAppAdminId, clientRep -> {
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("ciba.backchannel.auth.request.signing.alg", "RS512");
            });
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)cpe.getError());
        }
        cRep = this.getClientByAdmin(cAppAdminId);
        org.junit.Assert.assertEquals((Object)"ES256", cRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        this.updateClientByAdmin(cAppAdminId, clientRep -> {
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("ciba.backchannel.auth.request.signing.alg", "PS384");
        });
        cRep = this.getClientByAdmin(cAppAdminId);
        org.junit.Assert.assertEquals((Object)"PS384", cRep.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-ciba-req-sig-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureCibaAuthenticationRequestSigningAlgorithmExecutorConfig("ES256")).toRepresentation()).toString();
        this.updateProfiles(json);
        this.updateClientByAdmin(cAppAdmin2Id, client2Rep -> client2Rep.getAttributes().remove("ciba.backchannel.auth.request.signing.alg"));
        cRep2 = this.getClientByAdmin(cAppAdmin2Id);
        org.junit.Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("ciba.backchannel.auth.request.signing.alg"));
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-ciba-req-sig-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureCibaAuthenticationRequestSigningAlgorithmExecutorConfig("RS512")).toRepresentation()).toString();
        this.updateProfiles(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName("App-in-Dynamic"), clientRep -> {
                clientRep.setSecret("secret");
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("ciba.backchannel.auth.request.signing.alg", "RS384");
            });
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException e) {
            org.junit.Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String cAppDynamicClientId = this.createClientDynamically(this.generateSuffixedName("App-in-Dynamic"), clientRep -> clientRep.setBackchannelAuthenticationRequestSigningAlg("ES256"));
        this.events.expect(EventType.CLIENT_REGISTER).client(cAppDynamicClientId).user((Matcher<String>)org.hamcrest.Matchers.isEmptyOrNullString()).assertEvent();
        try {
            this.updateClientDynamically(cAppDynamicClientId, clientRep -> clientRep.setBackchannelAuthenticationRequestSigningAlg("RS256"));
            org.junit.Assert.fail();
        }
        catch (ClientRegistrationException e) {
            org.junit.Assert.assertEquals((Object)ERR_MSG_CLIENT_REG_FAIL, (Object)e.getMessage());
        }
        org.junit.Assert.assertEquals((Object)"ES256", (Object)this.getClientDynamically(cAppDynamicClientId).getBackchannelAuthenticationRequestSigningAlg());
        this.updateClientDynamically(cAppDynamicClientId, clientRep -> clientRep.setBackchannelAuthenticationRequestSigningAlg("ES384"));
        org.junit.Assert.assertEquals((Object)"ES384", (Object)this.getClientDynamically(cAppDynamicClientId).getBackchannelAuthenticationRequestSigningAlg());
        this.restartAuthenticatedClientRegistrationSetting();
        String cAppDynamicClient2Id = this.createClientDynamically(this.generateSuffixedName("App-in-Dynamic"), client2Rep -> {});
        OIDCClientRepresentation cAppDynamicClient2Rep = this.getClientDynamically(cAppDynamicClient2Id);
        org.junit.Assert.assertEquals((Object)"PS256", (Object)cAppDynamicClient2Rep.getBackchannelAuthenticationRequestSigningAlg());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-ciba-req-sig-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureCibaAuthenticationRequestSigningAlgorithmExecutorConfig("ES256")).toRepresentation()).toString();
        this.updateProfiles(json);
        this.updateClientDynamically(cAppDynamicClient2Id, client2Rep -> client2Rep.setBackchannelAuthenticationRequestSigningAlg(null));
        cAppDynamicClient2Rep = this.getClientDynamically(cAppDynamicClient2Id);
        org.junit.Assert.assertEquals((Object)"ES256", (Object)cAppDynamicClient2Rep.getBackchannelAuthenticationRequestSigningAlg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHolderOfKeyEnforceExecutor() throws Exception {
        Assume.assumeTrue((String)"This test must be executed with enabled TLS.", (boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Az Elso Profil").addExecutor("holder-of-key-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createHolderOfKeyEnforceExecutorConfig(Boolean.FALSE)).addExecutor("secure-signature-algorithm-signed-jwt", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmForSignedJwtEnforceExecutorConfig(Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Az Elso Politika", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            CloseableHttpResponse logoutResponse;
            OAuthClient.AccessTokenResponse accessTokenResponse;
            String username = "nutzername-rot";
            String bindingMessage = "ThisIsBindingMessage";
            HashMap<String, String> additionalParameters = new HashMap<String, String>();
            additionalParameters.put("user_device", "mobile");
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseMtlsHoKToken(true);
            clientResource.update(clientRep);
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", username, bindingMessage, null, additionalParameters);
            TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest(bindingMessage);
            AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
            MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)bindingMessage)));
            MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            MatcherAssert.assertThat(authenticationChannelReq.getAdditionalParameters().get("user_device"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"mobile")));
            this.doAuthenticationChannelCallback(testRequest);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("test-app", "password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"invalid_grant")));
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Client Certification missing for MTLS HoK Token Binding")));
            this.events.expect(EventType.AUTHREQID_TO_TOKEN_ERROR).clearDetails().user((String)null).client("test-app").error("invalid_request").assertEvent();
            try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
                accessTokenResponse = this.doBackchannelAuthenticationTokenRequest("test-app", "password", username, response.getAuthReqId(), client);
                AccessToken accessToken = (AccessToken)this.oauth.verifyToken(accessTokenResponse.getAccessToken(), AccessToken.class);
                MatcherAssert.assertThat((Object)accessTokenResponse.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
                MatcherAssert.assertThat((Object)accessToken.getCertConf().getCertThumbprint(), (Matcher)org.hamcrest.Matchers.notNullValue());
            }
            try (CloseableHttpClient client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
                logoutResponse = this.oauth.doLogout(accessTokenResponse.getRefreshToken(), "password", client);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            org.junit.Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        }
        finally {
            this.updatePolicies("{}");
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseMtlsHoKToken(false);
            clientResource.update(clientRep);
            this.revertCIBASettings(clientResource, clientRep);
        }
    }

    @Test
    public void testConfidentialClientAcceptExecutorExecutor() throws Exception {
        String clientPublicId = this.generateSuffixedName("public-app");
        String cidPublic = this.createClientByAdmin(clientPublicId, clientRep -> {
            clientRep.setSecret("app-secret");
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.TRUE);
            clientRep.setBearerOnly(Boolean.FALSE);
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            clientRep.setAttributes(attributes);
        });
        String username = "nutzername-rot";
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("user_device", "mobile");
        String bindingMessage = "bmbmbmbm";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Erstes Profil").addExecutor("confidential-client", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientPublicId, "app-secret", username, bindingMessage, null, null, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_client"));
        MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid client access type"));
        String clientConfidentialId = this.generateSuffixedName("confidential-app");
        String clientConfidentialSecret = "app-secret";
        String cidConfidential = this.createClientByAdmin(clientConfidentialId, clientRep -> {
            clientRep.setSecret(clientConfidentialSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            clientRep.setAttributes(attributes);
        });
        response = this.doBackchannelAuthenticationRequest(clientConfidentialId, clientConfidentialSecret, username, bindingMessage, null, additionalParameters);
        this.updateClientByAdmin(cidConfidential, cRep -> cRep.setPublicClient(Boolean.TRUE));
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientConfidentialId, clientConfidentialSecret, response.getAuthReqId());
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
        MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid client access type"));
    }

    @Test
    public void testClientScopesCondition() throws Exception {
        String username = "nutzername-rot";
        String bindingMessage = "ThisIsBindingMessage";
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("user_device", "mobile");
        String clientConfidentialId = this.generateSuffixedName("confidential-app");
        String clientConfidentialSecret = "app-secret";
        String cidConfidential = this.createClientByAdmin(clientConfidentialId, clientRep -> {
            clientRep.setSecret(clientConfidentialSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
            Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attributes.put("ciba.backchannel.token.delivery.mode", "poll");
            attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
            clientRep.setAttributes(attributes);
        });
        this.oauth.clientId(clientConfidentialId);
        this.oauth.scope("microprofile-jwt");
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Het Eerste Profiel").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Het Eerste Beleid", Boolean.TRUE).addCondition("client-scopes", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientScopesConditionConfig("Optional", Arrays.asList("microprofile-jwt"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientConfidentialId, clientConfidentialSecret, username, bindingMessage, null, null, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)ClientPolicyEvent.BACKCHANNEL_AUTHENTICATION_REQUEST.name()));
        MatcherAssert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Exception thrown intentionally"));
        this.updatePolicies("{}");
        response = this.oauth.doBackchannelAuthenticationRequest(clientConfidentialId, clientConfidentialSecret, username, bindingMessage, null, null, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        org.junit.Assert.assertNotNull((Object)response.getAuthReqId());
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Het Eerste Beleid", Boolean.TRUE).addCondition("client-scopes", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientScopesConditionConfig("Optional", Arrays.asList("microprofile-jwt"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientConfidentialId, clientConfidentialSecret, response.getAuthReqId());
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)"invalid_grant"));
        MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)"Exception thrown intentionally"));
        this.updatePolicies("{}");
        TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest(bindingMessage);
        AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
        MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)bindingMessage)));
        MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
        MatcherAssert.assertThat(authenticationChannelReq.getAdditionalParameters().get("user_device"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"mobile")));
        this.doAuthenticationChannelCallback(testRequest);
        tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientConfidentialId, clientConfidentialSecret, response.getAuthReqId());
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
        MatcherAssert.assertThat((Object)accessToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientConfidentialId)));
        RefreshToken refreshToken = this.oauth.parseRefreshToken(tokenRes.getRefreshToken());
        MatcherAssert.assertThat((Object)refreshToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientConfidentialId)));
        MatcherAssert.assertThat((Object)refreshToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)refreshToken.getIssuer())));
        IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
        MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)idToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientConfidentialId)));
        MatcherAssert.assertThat((Object)idToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)idToken.getIssuedFor())));
    }

    private void testBackchannelAuthenticationFlowNotRegisterSigAlgInAdvanceWithSignedAuthentication(String clientName, boolean useRequestUri, String requestedSigAlg, String sigAlg, int statusCode, String errorDescription) throws Exception {
        String clientId = this.createClientDynamically(clientName, clientRep -> {
            List grantTypes = Optional.ofNullable(clientRep.getGrantTypes()).orElse(new ArrayList());
            grantTypes.add("urn:openid:params:grant-type:ciba");
            clientRep.setGrantTypes(grantTypes);
        });
        OIDCClientRepresentation rep = this.getClientDynamically(clientId);
        String clientSecret = rep.getClientSecret();
        this.testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(useRequestUri, requestedSigAlg, sigAlg, statusCode, "invalid_request", errorDescription, clientId, clientSecret);
    }

    private void testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(boolean useRequestUri, String sigAlg, int statusCode, String errorDescription) throws Exception {
        this.testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(useRequestUri, sigAlg, sigAlg, 400, "invalid_request", errorDescription, "test-app", "password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBackchannelAuthenticationFlowWithInvalidSignedAuthenticationRequest(boolean useRequestUri, String requestedSigAlg, String sigAlg, int statusCode, String error, String errorDescription, String clientId, String clientSecret) throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject sharedAuthenticationRequest = this.createValidSharedAuthenticationRequest();
            sharedAuthenticationRequest.setLoginHint("nutzername-rot");
            sharedAuthenticationRequest.setBindingMessage("BASTION");
            this.registerSharedAuthenticationRequest(sharedAuthenticationRequest, clientId, requestedSigAlg, sigAlg, useRequestUri, clientSecret);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientId, clientSecret, null, null, null);
            org.junit.Assert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)statusCode)));
            org.junit.Assert.assertThat((Object)response.getError(), (Matcher)org.hamcrest.Matchers.is((Object)error));
            org.junit.Assert.assertThat((Object)response.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Object)errorDescription));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    protected void registerSharedInvalidAuthenticationRequest(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, String sigAlg, boolean isUseRequestUri) throws URISyntaxException, IOException {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        Map attr = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
        attr.put("ciba.backchannel.auth.request.signing.alg", sigAlg);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
        clientResource.update(clientRep);
        oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        oidcClientEndpointsResource.registerOIDCRequest(encodedRequestObject, sigAlg);
        if (isUseRequestUri) {
            this.oauth.request(null);
            this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        } else {
            this.oauth.requestUri(null);
            this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBackchannelAuthenticationFlowWithSignedAuthenticationRequest(boolean useRequestUri, String sigAlg) throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            String bindingMessage = "BASTION";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject sharedAuthenticationRequest = this.createValidSharedAuthenticationRequest();
            sharedAuthenticationRequest.setLoginHint("nutzername-rot");
            sharedAuthenticationRequest.setBindingMessage("BASTION");
            this.registerSharedAuthenticationRequest(sharedAuthenticationRequest, "test-app", sigAlg, useRequestUri);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", null, null);
            TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest("BASTION");
            AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
            org.junit.Assert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"BASTION")));
            org.junit.Assert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(testRequest);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, false);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doLogoutByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, false);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    private TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject createValidSharedAuthenticationRequest() throws URISyntaxException {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
        requestObject.nbf(requestObject.getIat());
        requestObject.setScope("openid");
        requestObject.setMax_age(Integer.valueOf(600));
        requestObject.setOtherClaims("custom_claim_zwei", (Object)"gelb");
        requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)"test"), "https://example.com"});
        return requestObject;
    }

    protected void registerSharedAuthenticationRequest(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, String sigAlg, boolean isUseRequestUri) throws URISyntaxException, IOException {
        this.registerSharedAuthenticationRequest(requestObject, clientId, sigAlg, isUseRequestUri, null);
    }

    protected void registerSharedAuthenticationRequest(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, String sigAlg, boolean isUseRequestUri, String clientSecret) throws URISyntaxException, IOException {
        this.registerSharedAuthenticationRequest(requestObject, clientId, sigAlg, sigAlg, isUseRequestUri, clientSecret);
    }

    private boolean isSymmetricSigAlg(String sigAlg) {
        if ("HS256".equals(sigAlg)) {
            return true;
        }
        if ("HS384".equals(sigAlg)) {
            return true;
        }
        return "HS512".equals(sigAlg);
    }

    protected void registerSharedAuthenticationRequest(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, String requestedSigAlg, String sigAlg, boolean isUseRequestUri, String clientSecret) throws URISyntaxException, IOException {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        if (requestedSigAlg != null) {
            Map attr = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
            attr.put("ciba.backchannel.auth.request.signing.alg", requestedSigAlg);
            clientRep.setAttributes(attr);
        }
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
        clientResource.update(clientRep);
        oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        if (this.isSymmetricSigAlg(sigAlg)) {
            oidcClientEndpointsResource.registerOIDCRequestSymmetricSig(encodedRequestObject, sigAlg, clientSecret);
        } else {
            if (!"none".equals(sigAlg)) {
                oidcClientEndpointsResource.generateKeys(sigAlg);
            }
            oidcClientEndpointsResource.registerOIDCRequest(encodedRequestObject, sigAlg);
        }
        if (isUseRequestUri) {
            this.oauth.request(null);
            this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        } else {
            this.oauth.requestUri(null);
            this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAuthenticationChannelErrorCase(Response.Status statusCallback, Response.Status statusTokenEndpont, AuthenticationChannelResponse.Status authStatus, String error, String errorEvent) throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", "kwq26rfjs73");
            TestAuthenticationChannelRequest authenticationChannelReq = this.doAuthenticationChannelRequest("kwq26rfjs73");
            this.doAuthenticationChannelCallbackError(statusCallback, "test-app", authenticationChannelReq, authStatus, "nutzername-rot", errorEvent);
            OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest("password", response.getAuthReqId());
            MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)statusTokenEndpont.getStatusCode())));
            MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Object)error));
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }

    private void prepareCIBASettings(ClientResource clientResource, ClientRepresentation clientRep) {
        this.prepareCIBASettings(clientResource, clientRep, "poll");
    }

    private void prepareCIBASettings(ClientResource clientResource, ClientRepresentation clientRep, String mode) {
        Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
        attributes.put("ciba.backchannel.token.delivery.mode", mode);
        attributes.put("ciba.backchannel.client.notification.endpoint", TestApplicationResourceUrls.cibaClientNotificationEndpointUri());
        attributes.put("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
        clientRep.setAttributes(attributes);
        ArrayList<String> requestUris = new ArrayList<String>(OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestUris());
        requestUris.add(TestApplicationResourceUrls.clientRequestUri());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(requestUris);
        clientResource.update(clientRep);
    }

    private void revertCIBASettings(ClientResource clientResource, ClientRepresentation clientRep) {
        Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
        attributes.remove("ciba.backchannel.token.delivery.mode");
        attributes.remove("oidc.ciba.grant.enabled", Boolean.TRUE.toString());
        attributes.remove("ciba.backchannel.client.notification.endpoint");
        clientRep.setAttributes(attributes);
        ArrayList requestUris = new ArrayList(OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).getRequestUris());
        requestUris.remove(TestApplicationResourceUrls.clientRequestUri());
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(requestUris);
        clientResource.update(clientRep);
    }

    private RealmRepresentation backupCIBAPolicy() {
        RealmRepresentation rep = this.testRealm().toRepresentation();
        Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
        this.cibaBackchannelTokenDeliveryMode = (String)attrMap.get("cibaBackchannelTokenDeliveryMode");
        this.cibaExpiresIn = Integer.parseInt((String)attrMap.get("cibaExpiresIn"));
        this.cibaInterval = Integer.parseInt((String)attrMap.get("cibaInterval"));
        this.cibaAuthRequestedUserHint = (String)attrMap.get("cibaAuthRequestedUserHint");
        return rep;
    }

    private void restoreCIBAPolicy() {
        RealmRepresentation rep = this.testRealm().toRepresentation();
        Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
        attrMap.put("cibaBackchannelTokenDeliveryMode", this.cibaBackchannelTokenDeliveryMode);
        attrMap.put("cibaExpiresIn", String.valueOf(this.cibaExpiresIn));
        attrMap.put("cibaInterval", String.valueOf(this.cibaInterval));
        attrMap.put("cibaAuthRequestedUserHint", this.cibaAuthRequestedUserHint);
        rep.setAttributes(attrMap);
        this.testRealm().update(rep);
    }

    private OAuthClient.AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequest(String clientId, String clientSecret, String username, String bindingMessage) throws Exception {
        return this.doBackchannelAuthenticationRequest(clientId, clientSecret, username, bindingMessage, null, null);
    }

    private OAuthClient.AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequest(String clientId, String clientSecret, String username, String bindingMessage, String clientNotificationToken, Map<String, String> additionalParameters) throws Exception {
        OAuthClient.AuthenticationRequestAcknowledgement response = this.oauth.doBackchannelAuthenticationRequest(clientId, clientSecret, username, bindingMessage, null, clientNotificationToken, additionalParameters);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        org.junit.Assert.assertNotNull((Object)response.getAuthReqId());
        return response;
    }

    private TestAuthenticationChannelRequest doAuthenticationChannelRequest(String bindingMessage) {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        TestAuthenticationChannelRequest authenticationChannelReq = oidcClientEndpointsResource.getAuthenticationChannel(bindingMessage);
        return authenticationChannelReq;
    }

    private EventRepresentation doAuthenticationChannelCallback(TestAuthenticationChannelRequest request) throws Exception {
        int statusCode = this.oauth.doAuthenticationChannelCallback(request.getBearerToken(), AuthenticationChannelResponse.Status.SUCCEED);
        MatcherAssert.assertThat((Object)statusCode, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        EventRepresentation representation = new EventRepresentation();
        representation.setDetails(Collections.emptyMap());
        return representation;
    }

    private EventRepresentation doAuthenticationChannelCallbackError(Response.Status status, String clientId, TestAuthenticationChannelRequest authenticationChannelReq, AuthenticationChannelResponse.Status authStatus, String username, String error) throws Exception {
        int statusCode = this.oauth.doAuthenticationChannelCallback(authenticationChannelReq.getBearerToken(), authStatus);
        MatcherAssert.assertThat((Object)statusCode, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)status.getStatusCode())));
        return this.events.expect(EventType.LOGIN_ERROR).clearDetails().client(clientId).error(error).user((String)null).session((Matcher<String>)CoreMatchers.nullValue(String.class)).assertEvent();
    }

    private OAuthClient.AccessTokenResponse doBackchannelAuthenticationTokenRequest(String username, String authReqId) throws Exception {
        return this.doBackchannelAuthenticationTokenRequest("test-app", "password", username, authReqId);
    }

    private OAuthClient.AccessTokenResponse doBackchannelAuthenticationTokenRequest(String clientId, String clientSecret, String username, String authReqId) throws Exception {
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientId, clientSecret, authReqId);
        this.verifyBackchannelAuthenticationTokenRequest(tokenRes, clientId, username);
        return tokenRes;
    }

    private OAuthClient.AccessTokenResponse doBackchannelAuthenticationTokenRequest(String clientId, String clientSecret, String username, String authReqId, CloseableHttpClient httpClient) throws Exception {
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doBackchannelAuthenticationTokenRequest(clientId, clientSecret, authReqId, httpClient);
        this.verifyBackchannelAuthenticationTokenRequest(tokenRes, clientId, username);
        return tokenRes;
    }

    private void verifyBackchannelAuthenticationTokenRequest(OAuthClient.AccessTokenResponse tokenRes, String clientId, String username) {
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        EventRepresentation event = this.events.expectAuthReqIdToToken(null, null).clearDetails().user(AssertEvents.isUUID()).client(clientId).assertEvent();
        AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
        MatcherAssert.assertThat((Object)accessToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientId)));
        RefreshToken refreshToken = this.oauth.parseRefreshToken(tokenRes.getRefreshToken());
        MatcherAssert.assertThat((Object)refreshToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientId)));
        MatcherAssert.assertThat((Object)refreshToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)refreshToken.getIssuer())));
        IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
        MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)idToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)clientId)));
        MatcherAssert.assertThat((Object)idToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)idToken.getIssuedFor())));
    }

    private String doIntrospectAccessTokenWithClientCredential(OAuthClient.AccessTokenResponse tokenRes, String username) throws IOException {
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", tokenRes.getAccessToken());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        MatcherAssert.assertThat((Object)jsonNode.get("active").asBoolean(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)jsonNode.get("username").asText(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)jsonNode.get("client_id").asText(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        MatcherAssert.assertThat((Object)rep.isActive(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)rep.getClientId(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)rep.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        this.events.expect(EventType.INTROSPECT_TOKEN).user((String)null).clearDetails().assertEvent();
        tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", tokenRes.getRefreshToken());
        jsonNode = objectMapper.readTree(tokenResponse);
        MatcherAssert.assertThat((Object)jsonNode.get("active").asBoolean(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)jsonNode.get("client_id").asText(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        MatcherAssert.assertThat((Object)rep.isActive(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)rep.getClientId(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)rep.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)rep.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)rep.getIssuer())));
        this.events.expect(EventType.INTROSPECT_TOKEN).user((String)null).clearDetails().assertEvent();
        tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("test-app", "password", tokenRes.getIdToken());
        jsonNode = objectMapper.readTree(tokenResponse);
        MatcherAssert.assertThat((Object)jsonNode.get("active").asBoolean(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)jsonNode.get("client_id").asText(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        MatcherAssert.assertThat((Object)rep.isActive(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)true)));
        MatcherAssert.assertThat((Object)rep.getUserName(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)rep.getClientId(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)rep.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)rep.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)rep.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)rep.getIssuedFor())));
        this.events.expect(EventType.INTROSPECT_TOKEN).user((String)null).clearDetails().assertEvent();
        return tokenResponse;
    }

    private OAuthClient.AccessTokenResponse doRefreshTokenRequest(String oldRefreshToken, String username, String sessionId, boolean isOfflineAccess) {
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doRefreshTokenRequest(oldRefreshToken, "password");
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)200)));
        AccessToken accessToken = this.oauth.verifyToken(tokenRes.getAccessToken());
        MatcherAssert.assertThat((Object)accessToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        this.checkTokenExpiration((JsonWebToken)accessToken, tokenRes.getExpiresIn());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(tokenRes.getRefreshToken());
        MatcherAssert.assertThat((Object)refreshToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)refreshToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)refreshToken.getIssuer())));
        if (!isOfflineAccess) {
            this.checkTokenExpiration((JsonWebToken)refreshToken, tokenRes.getRefreshExpiresIn());
        }
        IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
        MatcherAssert.assertThat((Object)idToken.getPreferredUsername(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)username)));
        MatcherAssert.assertThat((Object)idToken.getIssuedFor(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"test-app")));
        MatcherAssert.assertThat((Object)idToken.getAudience()[0], (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)idToken.getIssuedFor())));
        this.checkTokenExpiration((JsonWebToken)idToken, tokenRes.getExpiresIn());
        this.events.expectRefresh(tokenRes.getRefreshToken(), sessionId).session((Matcher<String>)CoreMatchers.notNullValue(String.class)).user(AssertEvents.isUUID()).clearDetails().assertEvent();
        return tokenRes;
    }

    private void checkTokenExpiration(JsonWebToken token, long expiresIn) {
        MatcherAssert.assertThat((Object)token, (Matcher)org.hamcrest.Matchers.notNullValue());
        Long tokenExp = token.getExp();
        Long tokenIat = token.getIat();
        MatcherAssert.assertThat((Object)tokenExp, (Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((Object)tokenIat, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertExpiration(tokenExp, tokenIat + expiresIn);
    }

    private EventRepresentation doLogoutByRefreshToken(String refreshToken, String sessionId, String userId, boolean isOfflineAccess) throws IOException {
        try (CloseableHttpResponse res = this.oauth.doLogout(refreshToken, "password");){
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.NO_CONTENT));
        }
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doRefreshTokenRequest(refreshToken, "password");
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"invalid_grant")));
        if (isOfflineAccess) {
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Offline user session not found")));
        } else {
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Session not active")));
        }
        return this.events.expectLogout(sessionId).client("test-app").user(AssertEvents.isUUID()).session(AssertEvents.isUUID()).clearDetails().assertEvent();
    }

    private EventRepresentation doTokenRevokeByRefreshToken(String refreshToken, String sessionId, String userId, boolean isOfflineAccess) throws IOException {
        try (CloseableHttpResponse res = this.oauth.doTokenRevoke(refreshToken, "refresh_token", "password");){
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        }
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doRefreshTokenRequest(refreshToken, "password");
        MatcherAssert.assertThat((Object)tokenRes.getStatusCode(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)tokenRes.getError(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"invalid_grant")));
        if (isOfflineAccess) {
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Offline user session not found")));
        } else {
            MatcherAssert.assertThat((Object)tokenRes.getErrorDescription(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"Session not active")));
        }
        return this.events.expect(EventType.REVOKE_GRANT).clearDetails().client("test-app").user(AssertEvents.isUUID()).assertEvent();
    }

    private void testBackchannelAuthenticationFlow(boolean isOfflineAccess) throws Exception {
        this.testBackchannelAuthenticationFlow(isOfflineAccess, "BASTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBackchannelAuthenticationFlow(boolean isOfflineAccess, String bindingMessage) throws Exception {
        ClientResource clientResource = null;
        ClientRepresentation clientRep = null;
        try {
            String username = "nutzername-rot";
            HashMap<String, String> additionalParameters = new HashMap<String, String>();
            additionalParameters.put("user_device", "mobile");
            clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
            MatcherAssert.assertThat((Object)clientResource, (Matcher)org.hamcrest.Matchers.notNullValue());
            clientRep = clientResource.toRepresentation();
            this.prepareCIBASettings(clientResource, clientRep);
            if (isOfflineAccess) {
                this.oauth.scope("offline_access");
            }
            long startTime = Time.currentTime();
            OAuthClient.AuthenticationRequestAcknowledgement response = this.doBackchannelAuthenticationRequest("test-app", "password", "nutzername-rot", bindingMessage, null, additionalParameters);
            TestAuthenticationChannelRequest testRequest = this.doAuthenticationChannelRequest(bindingMessage);
            AuthenticationChannelRequest authenticationChannelReq = testRequest.getRequest();
            MatcherAssert.assertThat((Object)authenticationChannelReq.getBindingMessage(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)bindingMessage)));
            if (isOfflineAccess) {
                MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"offline_access")));
            }
            MatcherAssert.assertThat((Object)authenticationChannelReq.getScope(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.containsString((String)"openid")));
            MatcherAssert.assertThat(authenticationChannelReq.getAdditionalParameters().get("user_device"), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)"mobile")));
            EventRepresentation loginEvent = this.doAuthenticationChannelCallback(testRequest);
            String sessionId = loginEvent.getSessionId();
            String codeId = (String)loginEvent.getDetails().get("code_id");
            String userId = loginEvent.getUserId();
            OAuthClient.AccessTokenResponse tokenRes = this.doBackchannelAuthenticationTokenRequest("nutzername-rot", response.getAuthReqId());
            IDToken idToken = this.oauth.verifyIDToken(tokenRes.getIdToken());
            long currentTime = Time.currentTime();
            long authTime = idToken.getAuth_time();
            org.junit.Assert.assertTrue((startTime - 5L <= authTime ? 1 : 0) != 0);
            org.junit.Assert.assertTrue((authTime <= currentTime + 5L ? 1 : 0) != 0);
            String tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            tokenRes = this.doRefreshTokenRequest(tokenRes.getRefreshToken(), "nutzername-rot", sessionId, isOfflineAccess);
            tokenResponse = this.doIntrospectAccessTokenWithClientCredential(tokenRes, "nutzername-rot");
            EventRepresentation eventRepresentation = this.doLogoutByRefreshToken(tokenRes.getRefreshToken(), sessionId, userId, isOfflineAccess);
            this.revertCIBASettings(clientResource, clientRep);
        }
        catch (Throwable throwable) {
            this.revertCIBASettings(clientResource, clientRep);
            throw throwable;
        }
    }
}

