/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcRegUpdateTest
extends AbstractRegCliTest {
    @Test
    public void testUpdateThoroughly() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            String realm = "test";
            this.loginAsUser(configFile.getFile(), this.serverUrl, "test", "user1", "userpass");
            KcRegExec exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' -o -s clientId=my_client"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"enabled", (Object)true, (Object)client.isEnabled());
            Assert.assertEquals((String)"publicClient", (Object)false, (Object)client.isPublicClient());
            Assert.assertEquals((String)"bearerOnly", (Object)false, (Object)client.isBearerOnly());
            Assert.assertTrue((String)"redirectUris is empty", (boolean)client.getRedirectUris().isEmpty());
            exe = KcRegExec.execute((String)("update my_client --config '" + configFile.getName() + "' -o  -s enabled=false -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]'"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"enabled", (Object)false, (Object)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
            exe = KcRegExec.execute((String)("update my_client --config '" + configFile.getName() + "' -o -d redirectUris -s webOrigins+=http://localhost:8980/myapp -s webOrigins+=http://localhost:8981/myapp -d webOrigins[0]"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertTrue((String)"redirectUris is empty", (boolean)client.getRedirectUris().isEmpty());
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8981/myapp"), (Object)client.getWebOrigins());
            exe = KcRegExec.execute((String)("update my_client --nonexisting --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
            Assert.assertEquals((String)"error message", (Object)"Unsupported option: --nonexisting", exe.stderrLines().get(0));
            Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help update' for more information"), exe.stderrLines().get(1));
            exe = KcRegExec.execute((String)("update my_client --config '" + configFile.getName() + "' -o -s enabled=true -e oidc"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
            Assert.assertEquals((String)"error message", (Object)"Failed to set attribute 'enabled' on document type 'oidc'", exe.stderrLines().get(0));
            exe = (KcRegExec)KcRegExec.newBuilder().argsLine("update my_client --config '" + configFile.getName() + "' -o  -s clientId=my_client -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]' -f -").stdin((InputStream)new ByteArrayInputStream("{ \"enabled\": false }".getBytes())).execute();
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8981/myapp"), (Object)client.getWebOrigins());
            Assert.assertFalse((String)"enabled is false", (boolean)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
            exe = (KcRegExec)KcRegExec.newBuilder().argsLine("update my_client --config '" + configFile.getName() + "' -o -s enabled=true -m -f -").stdin((InputStream)new ByteArrayInputStream("{ \"webOrigins\": [\"http://localhost:8980/myapp\"] }".getBytes())).execute();
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp"), (Object)client.getWebOrigins());
            Assert.assertTrue((String)"enabled is true", (boolean)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server " + this.serverUrl + " --realm " + "test" + " --client my_client -d"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            Assert.assertNull((String)"my_client registration token", handler.loadConfig().ensureRealmConfigData(this.serverUrl, "test").getClients().get("my_client"));
        }
    }
}

