/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TempFileResource;

public class KcRegTruststoreTest
extends AbstractRegCliTest {
    @Test
    public void testTruststore() throws IOException {
        File truststore = new File("src/test/resources/keystore/keycloak.truststore");
        KcRegExec exe = KcRegExec.execute((String)("config truststore --no-config '" + truststore.getAbsolutePath() + "'"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Unsupported option: --no-config", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config truststore' for more information"), exe.stderrLines().get(1));
        if (!ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            System.out.println("TEST SKIPPED - This test requires HTTPS. Run with '-Pauth-server-wildfly -Dauth.server.ssl.required=true'");
            return;
        }
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            if (KcRegTruststoreTest.runIntermittentlyFailingTests()) {
                exe = KcRegExec.execute((String)("config truststore --config '" + configFile.getName() + "' '" + truststore.getAbsolutePath() + "'"));
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
                exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config credentials --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm test --user user1 --config '" + configFile.getName() + "'").executeAsync();
                exe.waitForStdout("Enter password: ");
                exe.sendToStdin("userpass" + OsUtil.EOL);
                exe.waitForStdout("Enter truststore password: ");
                exe.sendToStdin("secret" + OsUtil.EOL);
                exe.waitCompletion();
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 2, 1);
                exe = KcRegExec.execute((String)("config truststore --config '" + configFile.getName() + "' --trustpass secret '" + truststore.getAbsolutePath() + "'"));
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
                exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config credentials --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm test --user user1 --config '" + configFile.getName() + "'").executeAsync();
                exe.waitForStdout("Enter password: ");
                exe.sendToStdin("userpass" + OsUtil.EOL);
                exe.waitCompletion();
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            } else {
                System.out.println("TEST SKIPPED PARTIALLY - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it in full.");
            }
        }
        exe = KcRegExec.execute((String)("config truststore --trustpass secret '" + truststore.getAbsolutePath() + "'"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm test --user user1 --password userpass"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
        exe = KcRegExec.execute((String)"config truststore --delete");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        exe = KcRegExec.execute((String)("config truststore --delete '" + truststore.getAbsolutePath() + "'"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"incompatible", (Object)"Option --delete is mutually exclusive with specifying a TRUSTSTORE", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config truststore' for more information"), exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)"config truststore --delete --trustpass secret");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"no truststore error", (Object)"Options --trustpass and --delete are mutually exclusive", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config truststore' for more information"), exe.stderrLines().get(1));
        FileConfigHandler cfghandler = new FileConfigHandler();
        FileConfigHandler.setConfigFile((String)ConfigUtil.DEFAULT_CONFIG_FILE_PATH);
        ConfigData config = cfghandler.loadConfig();
        Assert.assertNull((String)"truststore null", (Object)config.getTruststore());
        Assert.assertNull((String)"trustpass null", (Object)config.getTrustpass());
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass", " --truststore '" + truststore.getAbsolutePath() + "' --trustpass secret", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    public void testUpdateTokenTruststore() {
    }
}

