/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

public class KcRegTest
extends AbstractRegCliTest {
    @Test
    public void testNoArgs() {
        KcRegExec exe = KcRegExec.execute((String)"");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        List lines = exe.stdoutLines();
        Assert.assertTrue((String)"stdout output not empty", (lines.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Client Registration CLI", lines.get(0));
        Assert.assertEquals((String)"stdout one but last line", (Object)("Use '" + KcRegExec.CMD + " help <command>' for more information about a given command."), lines.get(lines.size() - 2));
        Assert.assertEquals((String)"stdout last line", (Object)"", lines.get(lines.size() - 1));
        exe = KcRegExec.execute((String)"config");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"error message", (Object)("Sub-command required by '" + OsUtil.CMD + " config' - one of: 'credentials', 'truststore', 'initial-token', 'registration-token'"), exe.stderrLines().get(0));
        exe = KcRegExec.execute((String)"config credentials");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config credentials --server SERVER_URL --realm REALM [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config initial-token");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config initial-token --server SERVER --realm REALM [--delete | TOKEN] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config registration-token");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config registration-token --server SERVER --realm REALM --client CLIENT [--delete | TOKEN] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config truststore");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"create");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " create [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"get");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " get CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"update");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " update CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"delete");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " delete CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"attrs");
        Assert.assertEquals((String)"exit code", (long)0L, (long)exe.exitCode());
        Assert.assertTrue((String)"stdout has response", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"first line", (Object)"Attributes for default format:", exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"update-token");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " update-token CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        lines = exe.stdoutLines();
        Assert.assertTrue((String)"stdout output not empty", (lines.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Client Registration CLI", lines.get(0));
        Assert.assertEquals((String)"stdout one but last line", (Object)("Use '" + KcRegExec.CMD + " help <command>' for more information about a given command."), lines.get(lines.size() - 2));
        Assert.assertEquals((String)"stdout last line", (Object)"", lines.get(lines.size() - 1));
    }

    @Test
    public void testHelpGlobalOption() {
        KcRegExec exe = KcRegExec.execute((String)"--help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Client Registration CLI", exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"create --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " create [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"get --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " get CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"update --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " update CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"delete --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " delete CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"attrs --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " attrs [ATTRIBUTE] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"update-token --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " update-token CLIENT [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config SUB_COMMAND [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config credentials --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config credentials --server SERVER_URL --realm REALM [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config initial-token --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config initial-token --server SERVER --realm REALM [--delete | TOKEN] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config registration-token --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config registration-token --server SERVER --realm REALM --client CLIENT [--delete | TOKEN] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcRegExec.execute((String)"config truststore --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
    }

    @Test
    public void testBadCommand() {
        KcRegExec exe = KcRegExec.execute((String)"nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)"Unknown command: nonexistent", exe.stderrLines().get(0));
    }

    @Test
    public void testBadOptionInPlaceOfCommand() {
        KcRegExec exe = KcRegExec.execute((String)"--nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)"Unknown command: --nonexistent", exe.stderrLines().get(0));
    }

    @Test
    public void testBadOption() {
        KcRegExec exe = KcRegExec.execute((String)"get my_client --nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Invalid option: --nonexistent", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help get' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsServerAndRealmWithDefaultConfig() {
        KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
    }

    @Test
    public void testCredentialsNoServerWithDefaultConfig() {
        KcRegExec exe = KcRegExec.execute((String)"config credentials --realm master --user admin --password admin");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Required option not specified: --server", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsNoRealmWithDefaultConfig() {
        KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Required option not specified: --realm", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsWithNoConfig() {
        KcRegExec exe = KcRegExec.execute((String)("config credentials --no-config --server " + this.serverUrl + " --realm master --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Unsupported option: --no-config", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserLoginWithDefaultConfig() {
        KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserLoginWithDefaultConfigInteractive() throws IOException {
        if (!KcRegTest.runIntermittentlyFailingTests()) {
            System.out.println("TEST SKIPPED - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it.");
            return;
        }
        KcRegExec exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm master --user admin").executeAsync();
        exe.waitForStdout("Enter password: ");
        exe.sendToStdin("admin" + OsUtil.EOL);
        exe.waitCompletion();
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
        File tmpFile = new File(KcRegExec.WORK_DIR + "/" + UUID.randomUUID().toString() + ".tmp");
        try {
            FileOutputStream tmpos = new FileOutputStream(tmpFile);
            tmpos.write("admin".getBytes());
            tmpos.write(OsUtil.EOL.getBytes());
            tmpos.close();
            exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin < '" + tmpFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            Assert.assertTrue((String)"Enter password prompt", (boolean)((String)exe.stdoutLines().get(0)).startsWith("Enter password: "));
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientLoginWithDefaultConfigInteractive() throws IOException {
        if (!KcRegTest.runIntermittentlyFailingTests()) {
            System.out.println("TEST SKIPPED - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it.");
            return;
        }
        KcRegExec exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm test --client reg-cli-secret").executeAsync();
        exe.waitForStdout("Enter client secret: ");
        exe.sendToStdin("password" + OsUtil.EOL);
        exe.waitCompletion();
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as service-account-reg-cli-secret of realm test"), exe.stderrLines().get(0));
        File tmpFile = new File(KcRegExec.WORK_DIR + "/" + UUID.randomUUID().toString() + ".tmp");
        try {
            FileOutputStream tmpos = new FileOutputStream(tmpFile);
            tmpos.write("password".getBytes());
            tmpos.write(OsUtil.EOL.getBytes());
            tmpos.close();
            exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm test --client reg-cli-secret < '" + tmpFile.getName() + "'").execute();
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            Assert.assertTrue((String)"Enter client secret prompt", (boolean)((String)exe.stdoutLines().get(0)).startsWith("Enter client secret: "));
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as service-account-reg-cli-secret of realm test"), exe.stderrLines().get(0));
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserLoginWithCustomConfig() {
        FileConfigHandler handler = this.initCustomConfigFile();
        File configFile = new File(handler.getConfigFile());
        try {
            KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
            ConfigData config = handler.loadConfig();
            Assert.assertEquals((String)"serverUrl", (Object)this.serverUrl, (Object)config.getServerUrl());
            Assert.assertEquals((String)"realm", (Object)"master", (Object)config.getRealm());
            RealmConfigData realmcfg = config.sessionRealmConfigData();
            Assert.assertNotNull((String)"realm config data no null", (Object)realmcfg);
            Assert.assertEquals((String)"realm cfg serverUrl", (Object)this.serverUrl, (Object)realmcfg.serverUrl());
            Assert.assertEquals((String)"realm cfg realm", (Object)"master", (Object)realmcfg.realm());
            Assert.assertEquals((String)"client id", (Object)"admin-cli", (Object)realmcfg.getClientId());
            Assert.assertNotNull((String)"token not null", (Object)realmcfg.getToken());
            Assert.assertNotNull((String)"refresh token not null", (Object)realmcfg.getRefreshToken());
            Assert.assertNotNull((String)"token expires not null", (Object)realmcfg.getExpiresAt());
            Assert.assertNotNull((String)"token expires in future", (Object)(realmcfg.getExpiresAt() > System.currentTimeMillis() ? 1 : 0));
            Assert.assertNotNull((String)"refresh token expires not null", (Object)realmcfg.getRefreshExpiresAt());
            Assert.assertNotNull((String)"refresh token expires in future", (Object)(realmcfg.getRefreshExpiresAt() > System.currentTimeMillis() ? 1 : 0));
            Assert.assertTrue((String)"clients is empty", (boolean)realmcfg.getClients().isEmpty());
        }
        finally {
            configFile.delete();
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCustomConfigLoginCreateDelete() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            ConfigData config1 = handler.loadConfig();
            exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' -s clientId=test-client -o"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ConfigData config2 = handler.loadConfig();
            this.assertFieldsEqualWithExclusions(config1, config2, "endpoints." + this.serverUrl + ".master.clients.test-client");
            Assert.assertNotNull(config2.sessionRealmConfigData().getClients().get("test-client"));
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client.getClientId());
            Assert.assertNotNull((String)"registrationAccessToken", (Object)client.getRegistrationAccessToken());
            Assert.assertEquals((String)"registrationAccessToken in returned json same as in config", config2.sessionRealmConfigData().getClients().get("test-client"), (Object)client.getRegistrationAccessToken());
            exe = KcRegExec.execute((String)("delete test-client --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            ConfigData config3 = handler.loadConfig();
            this.assertFieldsEqualWithExclusions(config2, config3, "endpoints." + this.serverUrl + ".master.clients.test-client");
            Assert.assertTrue((String)"clients empty", (boolean)config3.sessionRealmConfigData().getClients().isEmpty());
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCRUDWithOnTheFlyUserAuth() throws IOException {
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCRUDWithOnTheFlyUserAuthWithClientSecret() throws IOException {
        KcRegExec exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client reg-cli-secret --secret password"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Client not allowed for direct access grants [unauthorized_client]", exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password wrong --client reg-cli-secret-direct --secret password"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid user credentials [invalid_grant]", exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client reg-cli-secret-direct --secret wrong"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid client secret [unauthorized_client]", exe.stderrLines().get(1));
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass --client reg-cli-secret-direct --secret password", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCRUDWithOnTheFlyUserAuthWithSignedJwtClient() throws IOException {
        File keystore = new File(System.getProperty("user.dir") + "/src/test/resources/cli/kcreg/reg-cli-keystore.jks");
        Assert.assertTrue((String)"reg-cli-keystore.jks exists", (boolean)keystore.isFile());
        KcRegExec exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client reg-cli-jwt --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias reg-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Client not allowed for direct access grants [unauthorized_client]", exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password wrong --client reg-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias reg-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid user credentials [invalid_grant]", exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client reg-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass wrong --keypass keypass --alias reg-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Failed to load private key: Keystore was tampered with, or password was incorrect", exe.stderrLines().get(1));
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass  --client reg-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias reg-cli", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCRUDWithOnTheFlyServiceAccountWithClientSecret() throws IOException {
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--client reg-cli-secret --secret password", "", "Logging into " + this.serverUrl + " as service-account-reg-cli-secret of realm test");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCRUDWithOnTheFlyServiceAccountWithSignedJwtClient() throws IOException {
        File keystore = new File(System.getProperty("user.dir") + "/src/test/resources/cli/kcreg/reg-cli-keystore.jks");
        Assert.assertTrue((String)"reg-cli-keystore.jks exists", (boolean)keystore.isFile());
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--client reg-cli-jwt --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias reg-cli", "", "Logging into " + this.serverUrl + " as service-account-reg-cli-jwt of realm test");
    }

    @Test
    public void testCreateDeleteWithInitialAndRegistrationTokensWithUnsecureOption() throws IOException {
        this.testCreateDeleteWithInitialAndRegistrationTokensWithUnsecureOption(true);
    }

    @Test
    public void testCreateDeleteWithInitialAndRegistrationTokensWithUnsecureOptionNoConfig() throws IOException {
        this.testCreateDeleteWithInitialAndRegistrationTokensWithUnsecureOption(false);
    }

    private void testCreateDeleteWithInitialAndRegistrationTokensWithUnsecureOption(boolean useConfig) throws IOException {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            String token = this.issueInitialAccessToken("master");
            String realm = "master";
            KcRegExec exe = KcRegExec.execute((String)("create " + (useConfig ? "--config '" + configFile.getAbsolutePath() + "'" : "--no-config") + " --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm " + "master" + " -s clientId=test-client2 -o -t " + token));
            Assert.assertEquals((String)"exitCode == 0", (long)0L, (long)exe.exitCode());
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"clientId", (Object)"test-client2", (Object)client.getClientId());
            Assert.assertNotNull((String)"registrationAccessToken", (Object)client.getRegistrationAccessToken());
            if (useConfig) {
                ConfigData config = handler.loadConfig();
                Assert.assertEquals((String)"Registration Access Token in config file", (Object)client.getRegistrationAccessToken(), config.ensureRealmConfigData(OAuthClient.AUTH_SERVER_ROOT, "master").getClients().get("test-client2"));
            } else {
                Assert.assertFalse((String)"There should be no config file", (boolean)configFile.isFile());
            }
            exe = KcRegExec.execute((String)("delete test-client2 " + (useConfig ? "--config '" + configFile.getAbsolutePath() + "'" : "--no-config") + " --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm " + "master" + " -t " + client.getRegistrationAccessToken()));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 2);
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCreateWithAllowedHostsWithoutAuthenticationNoConfig() throws IOException {
        this.testCreateWithAllowedHostsWithoutAuthentication("test", false);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testCreateWithAllowedHostsWithoutAuthentication() throws IOException {
        this.testCreateWithAllowedHostsWithoutAuthentication("test", true);
    }

    private void testCreateWithAllowedHostsWithoutAuthentication(String realm, boolean useConfig) throws IOException {
        this.addLocalhostToAllowedHosts(realm);
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("create " + (useConfig ? "--config '" + configFile.getAbsolutePath() + "'" : "--no-config") + " --server " + this.serverUrl + " --realm " + realm + " -s clientId=test-client -o"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client.getClientId());
            Assert.assertNotNull((String)"registrationAccessToken", (Object)client.getRegistrationAccessToken());
            exe = KcRegExec.execute((String)("delete test-client " + (useConfig ? "--config '" + configFile.getAbsolutePath() + "'" : "--no-config") + " --server " + this.serverUrl + " --realm " + realm + " -t " + client.getRegistrationAccessToken()));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        }
    }
}

