/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

public class KcRegCreateTest
extends AbstractRegCliTest {
    @Before
    public void assumeTLSEnabled() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @Test
    public void testCreateWithRealmOverride() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("config credentials -x --config '" + configFile.getName() + "' --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm master --user admin --password admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 3);
            String token = this.issueInitialAccessToken("test");
            exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm test -s clientId=my_first_client -t " + token));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 3);
        }
    }

    @Test
    public void testCreateThoroughly() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            ClientRepresentation client;
            String token = this.issueInitialAccessToken("test");
            String realm = "test";
            KcRegExec exe = KcRegExec.execute((String)("config initial-token -x --config '" + configFile.getName() + "' --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm " + "test" + " " + token));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            ConfigData config = handler.loadConfig();
            Assert.assertEquals((String)"Config serverUrl", (Object)OAuthClient.AUTH_SERVER_ROOT, (Object)config.getServerUrl());
            Assert.assertEquals((String)"Config realm", (Object)"test", (Object)config.getRealm());
            Assert.assertEquals((String)"Config initial access token", (Object)token, (Object)config.ensureRealmConfigData(OAuthClient.AUTH_SERVER_ROOT, "test").getInitialToken());
            String content = "{\n        \"clientId\": \"my_client\",\n        \"enabled\": true,\n        \"redirectUris\": [\"http://localhost:8980/myapp/*\"],\n        \"serviceAccountsEnabled\": true,\n        \"name\": \"My Client App\",\n        \"implicitFlowEnabled\": false,\n        \"publicClient\": true,\n        \"protocol\": \"openid-connect\",\n        \"webOrigins\": [\"http://localhost:8980/myapp\"],\n        \"consentRequired\": false,\n        \"baseUrl\": \"http://localhost:8980/myapp\",\n        \"rootUrl\": \"http://localhost:8980/myapp\",\n        \"bearerOnly\": true,\n        \"standardFlowEnabled\": true\n}";
            try (TempFileResource tmpFile = new TempFileResource(this.initTempFile(".json", content));){
                exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -o -f - < '" + tmpFile.getName() + "'"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 2);
                client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
                Assert.assertNotNull((String)"id", (Object)client.getId());
                Assert.assertEquals((String)"clientId", (Object)"my_client", (Object)client.getClientId());
                Assert.assertEquals((String)"enabled", (Object)true, (Object)client.isEnabled());
                Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
                Assert.assertEquals((String)"serviceAccountsEnabled", (Object)true, (Object)client.isServiceAccountsEnabled());
                Assert.assertEquals((String)"name", (Object)"My Client App", (Object)client.getName());
                Assert.assertEquals((String)"implicitFlowEnabled", (Object)false, (Object)client.isImplicitFlowEnabled());
                Assert.assertEquals((String)"publicClient", (Object)true, (Object)client.isPublicClient());
                Assert.assertEquals((String)"protocol", (Object)"openid-connect", (Object)client.getProtocol());
                Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp"), (Object)client.getWebOrigins());
                Assert.assertEquals((String)"consentRequired", (Object)false, (Object)client.isConsentRequired());
                Assert.assertEquals((String)"baseUrl", (Object)"http://localhost:8980/myapp", (Object)client.getBaseUrl());
                Assert.assertEquals((String)"rootUrl", (Object)"http://localhost:8980/myapp", (Object)client.getRootUrl());
                Assert.assertEquals((String)"bearerOnly", (Object)true, (Object)client.isStandardFlowEnabled());
                Assert.assertNull((String)"mappers are null", (Object)client.getProtocolMappers());
                exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -o -f '" + tmpFile.getName() + "' -s clientId=my_client2 -s enabled=false -s 'redirectUris=[\"http://localhost:8980/myapp2/*\"]' -s 'name=My Client App II' -s protocol=openid-connect -s 'webOrigins=[\"http://localhost:8980/myapp2\"]' -s baseUrl=http://localhost:8980/myapp2 -s rootUrl=http://localhost:8980/myapp2"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 2);
                ClientRepresentation client2 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
                Assert.assertNotNull((String)"id", (Object)client2.getId());
                Assert.assertEquals((String)"clientId", (Object)"my_client2", (Object)client2.getClientId());
                Assert.assertEquals((String)"enabled", (Object)false, (Object)client2.isEnabled());
                Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp2/*"), (Object)client2.getRedirectUris());
                Assert.assertEquals((String)"serviceAccountsEnabled", (Object)true, (Object)client2.isServiceAccountsEnabled());
                Assert.assertEquals((String)"name", (Object)"My Client App II", (Object)client2.getName());
                Assert.assertEquals((String)"implicitFlowEnabled", (Object)false, (Object)client2.isImplicitFlowEnabled());
                Assert.assertEquals((String)"publicClient", (Object)true, (Object)client2.isPublicClient());
                Assert.assertEquals((String)"protocol", (Object)"openid-connect", (Object)client2.getProtocol());
                Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp2"), (Object)client2.getWebOrigins());
                Assert.assertEquals((String)"consentRequired", (Object)false, (Object)client2.isConsentRequired());
                Assert.assertEquals((String)"baseUrl", (Object)"http://localhost:8980/myapp2", (Object)client2.getBaseUrl());
                Assert.assertEquals((String)"rootUrl", (Object)"http://localhost:8980/myapp2", (Object)client2.getRootUrl());
                Assert.assertEquals((String)"bearerOnly", (Object)true, (Object)client2.isStandardFlowEnabled());
                Assert.assertNull((String)"mappers are null", (Object)client2.getProtocolMappers());
                exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' -o -f '" + tmpFile.getName() + "' -s client_id=my_client3"));
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
                Assert.assertEquals((Object)"Failed to set attribute 'client_id' on document type 'default'", exe.stderrLines().get(0));
            }
            exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -i -s clientId=my_client3"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 2);
            Assert.assertEquals((String)"only clientId returned", (Object)"my_client3", exe.stdoutLines().get(0));
            exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -s clientId=my_client4"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 3);
            Assert.assertEquals((String)"only clientId returned", (Object)"Registered new client with client_id 'my_client4'", exe.stderrLines().get(2));
            content = "        {\n            \"redirect_uris\" : [ \"http://localhost:8980/myapp/*\" ],\n            \"grant_types\" : [ \"authorization_code\", \"client_credentials\", \"refresh_token\" ],\n            \"response_types\" : [ \"code\", \"none\" ],\n            \"client_name\" : \"My Client App\",\n            \"client_uri\" : \"http://localhost:8980/myapp\"\n        }";
            tmpFile = new TempFileResource(this.initTempFile(".json", content));
            var10_12 = null;
            try {
                exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -s 'client_name=My Client App V'  -s 'redirect_uris=[\"http://localhost:8980/myapp5/*\"]' -s client_uri=http://localhost:8980/myapp5 -o -f - < '" + tmpFile.getName() + "'"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 2);
                client = (OIDCClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), OIDCClientRepresentation.class);
                Assert.assertNotNull((String)"clientId", (Object)client.getClientId());
                Assert.assertEquals((String)"redirect_uris", Arrays.asList("http://localhost:8980/myapp5/*"), (Object)client.getRedirectUris());
                Assert.assertEquals((String)"grant_types", Arrays.asList("authorization_code", "client_credentials", "refresh_token"), (Object)client.getGrantTypes());
                Assert.assertEquals((String)"response_types", Arrays.asList("code", "none"), (Object)client.getResponseTypes());
                Assert.assertEquals((String)"client_name", (Object)"My Client App V", (Object)client.getClientName());
                Assert.assertEquals((String)"client_uri", (Object)"http://localhost:8980/myapp5", (Object)client.getClientUri());
                exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' -e default -f '" + tmpFile.getName() + "'"));
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
                Assert.assertEquals((String)"Error message", (Object)"Attribute 'redirect_uris' not supported on document type 'default'", exe.stderrLines().get(0));
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (tmpFile != null) {
                    if (var10_12 != null) {
                        try {
                            tmpFile.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        tmpFile.close();
                    }
                }
            }
            File samlSpMetaFile = new File(System.getProperty("user.dir") + "/src/test/resources/cli/kcreg/saml-sp-metadata.xml");
            Assert.assertTrue((String)"saml-sp-metadata.xml exists", (boolean)samlSpMetaFile.isFile());
            exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -o -f - < '" + samlSpMetaFile.getAbsolutePath() + "'"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 2);
            ClientRepresentation client2 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertNotNull((String)"id", (Object)client2.getId());
            Assert.assertEquals((String)"clientId", (Object)"http://localhost:8080/sales-post-enc/", (Object)client2.getClientId());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8081/sales-post-enc/saml"), (Object)client2.getRedirectUris());
            Assert.assertEquals((String)"attributes.saml_name_id_format", (Object)"username", client2.getAttributes().get("saml_name_id_format"));
            Assert.assertEquals((String)"attributes.saml_assertion_consumer_url_post", (Object)"http://localhost:8081/sales-post-enc/saml", client2.getAttributes().get("saml_assertion_consumer_url_post"));
            Assert.assertEquals((String)"attributes.saml.signature.algorithm", (Object)"RSA_SHA256", client2.getAttributes().get("saml.signature.algorithm"));
            exe = KcRegExec.execute((String)("config initial-token --config '" + configFile.getName() + "' --insecure --server " + this.serverUrl + " --realm " + "test" + " --delete"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            config = handler.loadConfig();
            Assert.assertNull((String)"initial token == null", (Object)config.ensureRealmConfigData(this.serverUrl, "test").getInitialToken());
        }
    }

    @Test
    public void testCreateWithAuthorizationServices() throws IOException {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("config credentials -x --config '" + configFile.getName() + "' --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm master --user admin --password admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 3);
            String token = this.issueInitialAccessToken("test");
            exe = KcRegExec.execute((String)("create --config '" + configFile.getName() + "' --insecure --server " + OAuthClient.AUTH_SERVER_ROOT + " --realm test -s clientId=authz-client -s authorizationServicesEnabled=true -t " + token));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 3);
            RealmResource realm = this.adminClient.realm("test");
            ClientsResource clients = realm.clients();
            ClientRepresentation clientRep = (ClientRepresentation)clients.findByClientId("authz-client").get(0);
            ClientResource client = clients.get(clientRep.getId());
            clientRep = client.toRepresentation();
            Assert.assertTrue((boolean)clientRep.getAuthorizationServicesEnabled());
            ResourceServerRepresentation settings = client.authorization().getSettings();
            Assert.assertEquals((Object)PolicyEnforcementMode.ENFORCING, (Object)settings.getPolicyEnforcementMode());
            Assert.assertTrue((boolean)settings.isAllowRemoteResourceManagement());
            List roles = client.roles().list();
            Assert.assertEquals((long)1L, (long)roles.size());
            Assert.assertEquals((Object)"uma_protection", (Object)((RoleRepresentation)roles.get(0)).getName());
            String content = "        {\n            \"redirect_uris\" : [ \"http://localhost:8980/myapp/*\" ],\n            \"grant_types\" : [ \"authorization_code\", \"client_credentials\", \"refresh_token\", \"urn:ietf:params:oauth:grant-type:uma-ticket\" ],\n            \"response_types\" : [ \"code\", \"none\" ],\n            \"client_name\" : \"My Reg Authz\",\n            \"client_uri\" : \"http://localhost:8980/myapp\"\n        }";
            try (TempFileResource tmpFile = new TempFileResource(this.initTempFile(".json", content));){
                exe = KcRegExec.execute((String)("create --insecure --config '" + configFile.getName() + "' -s 'client_name=My Reg Authz' --realm test -t " + token + " -s 'redirect_uris=[\"http://localhost:8980/myapp5/*\"]' -s client_uri=http://localhost:8980/myapp5 -o -f - < '" + tmpFile.getName() + "'"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 2);
                OIDCClientRepresentation oidcClient = (OIDCClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), OIDCClientRepresentation.class);
                Assert.assertNotNull((String)"clientId", (Object)oidcClient.getClientId());
                Assert.assertEquals((String)"redirect_uris", Arrays.asList("http://localhost:8980/myapp5/*"), (Object)oidcClient.getRedirectUris());
                Assert.assertThat((String)"grant_types", (Object)oidcClient.getGrantTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"authorization_code", "client_credentials", "refresh_token", "urn:ietf:params:oauth:grant-type:uma-ticket"}));
                Assert.assertEquals((String)"response_types", Arrays.asList("code", "none"), (Object)oidcClient.getResponseTypes());
                Assert.assertEquals((String)"client_name", (Object)"My Reg Authz", (Object)oidcClient.getClientName());
                Assert.assertEquals((String)"client_uri", (Object)"http://localhost:8980/myapp5", (Object)oidcClient.getClientUri());
                client = clients.get(oidcClient.getClientId());
                clientRep = client.toRepresentation();
                Assert.assertTrue((boolean)clientRep.getAuthorizationServicesEnabled());
                settings = client.authorization().getSettings();
                Assert.assertEquals((Object)PolicyEnforcementMode.ENFORCING, (Object)settings.getPolicyEnforcementMode());
                Assert.assertTrue((boolean)settings.isAllowRemoteResourceManagement());
                roles = client.roles().list();
                Assert.assertEquals((long)1L, (long)roles.size());
                Assert.assertEquals((Object)"uma_protection", (Object)((RoleRepresentation)roles.get(0)).getName());
                UserRepresentation serviceAccount = (UserRepresentation)realm.users().search("service-account-" + clientRep.getClientId()).get(0);
                Assert.assertNotNull((Object)serviceAccount);
                List serviceAccountRoles = realm.users().get(serviceAccount.getId()).roles().clientLevel(clientRep.getId()).listAll();
                Assert.assertTrue((boolean)serviceAccountRoles.stream().anyMatch(roleRepresentation -> "uma_protection".equals(roleRepresentation.getName())));
            }
        }
    }
}

