/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.config.FileConfigHandler;
import org.keycloak.client.admin.cli.config.RealmConfigData;
import org.keycloak.client.admin.cli.util.OsUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcAdmExec;
import org.keycloak.testsuite.cli.admin.AbstractAdmCliTest;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcAdmTest
extends AbstractAdmCliTest {
    @Test
    public void testBadCommand() {
        KcAdmExec exe = KcAdmExec.execute((String)"nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)"Unknown command: nonexistent", exe.stderrLines().get(0));
    }

    @Test
    public void testNoArgs() {
        KcAdmExec exe = KcAdmExec.execute((String)"");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        List lines = exe.stdoutLines();
        Assert.assertTrue((String)"stdout output not empty", (lines.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Admin CLI", lines.get(0));
        Assert.assertEquals((String)"stdout one but last line", (Object)("Use '" + KcAdmExec.CMD + " help <command>' for more information about a given command."), lines.get(lines.size() - 2));
        Assert.assertEquals((String)"stdout last line", (Object)"", lines.get(lines.size() - 1));
        exe = KcAdmExec.execute((String)"config");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"error message", (Object)("Sub-command required by '" + OsUtil.CMD + " config' - one of: 'credentials', 'truststore'"), exe.stderrLines().get(0));
        exe = KcAdmExec.execute((String)"config credentials");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config credentials --server SERVER_URL --realm REALM --user USER [--password PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"config truststore");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"create");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " create ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"get");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " get ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"update");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " update ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"delete");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " delete ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"add-roles");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " add-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"remove-roles");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " remove-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"set-password");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 1, 0);
        Assert.assertTrue((String)"help message returned", (exe.stdoutLines().size() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"help message", (Object)("Usage: " + OsUtil.CMD + " set-password (--username USERNAME | --userid ID) [--new-password PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        lines = exe.stdoutLines();
        Assert.assertTrue((String)"stdout output not empty", (lines.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Admin CLI", lines.get(0));
        Assert.assertEquals((String)"stdout one but last line", (Object)("Use '" + KcAdmExec.CMD + " help <command>' for more information about a given command."), lines.get(lines.size() - 2));
        Assert.assertEquals((String)"stdout last line", (Object)"", lines.get(lines.size() - 1));
    }

    @Test
    public void testHelpGlobalOption() {
        KcAdmExec exe = KcAdmExec.execute((String)"--help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)"Keycloak Admin CLI", exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"create --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " create ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"get --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " get ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"update --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " update ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"delete --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " delete ENDPOINT_URI [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"get-roles --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " get-roles [--cclientid CLIENT_ID | --cid ID] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"add-roles --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " add-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"remove-roles --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " remove-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"set-password --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " set-password (--username USERNAME | --userid ID) [--new-password PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"config --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config SUB_COMMAND [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"config credentials --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config credentials --server SERVER_URL --realm REALM --user USER [--password PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
        exe = KcAdmExec.execute((String)"config truststore --help");
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        Assert.assertEquals((String)"stdout first line", (Object)("Usage: " + OsUtil.CMD + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWORD] [ARGUMENTS]"), exe.stdoutLines().get(0));
    }

    @Test
    public void testBadOptionInPlaceOfCommand() {
        KcAdmExec exe = KcAdmExec.execute((String)"--nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)"Unknown command: --nonexistent", exe.stderrLines().get(0));
    }

    @Test
    public void testBadOption() {
        KcAdmExec exe = KcAdmExec.execute((String)"get users --nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Invalid option: --nonexistent", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help get' for more information"), exe.stderrLines().get(1));
        exe = KcAdmExec.execute((String)"set-password --nonexistent");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Invalid option: --nonexistent", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help set-password' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsServerAndRealmWithDefaultConfig() {
        KcAdmExec exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
    }

    @Test
    public void testCredentialsNoServerWithDefaultConfig() {
        KcAdmExec exe = KcAdmExec.execute((String)"config credentials --realm master --user admin --password admin");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Required option not specified: --server", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsNoRealmWithDefaultConfig() {
        KcAdmExec exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Required option not specified: --realm", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testCredentialsWithNoConfig() {
        KcAdmExec exe = KcAdmExec.execute((String)("config credentials --no-config --server " + this.serverUrl + " --realm master --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Unsupported option: --no-config", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config credentials' for more information"), exe.stderrLines().get(1));
    }

    @Test
    public void testUserLoginWithDefaultConfig() {
        KcAdmExec exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserLoginWithDefaultConfigInteractive() throws IOException {
        if (!KcAdmTest.runIntermittentlyFailingTests()) {
            System.out.println("TEST SKIPPED - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it.");
            return;
        }
        KcAdmExec exe = (KcAdmExec)KcAdmExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm master --user admin").executeAsync();
        exe.waitForStdout("Enter password: ");
        exe.sendToStdin("admin" + OsUtil.EOL);
        exe.waitCompletion();
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
        File tmpFile = new File(KcAdmExec.WORK_DIR + "/" + UUID.randomUUID().toString() + ".tmp");
        try {
            FileOutputStream tmpos = new FileOutputStream(tmpFile);
            tmpos.write("admin".getBytes());
            tmpos.write(OsUtil.EOL.getBytes());
            tmpos.close();
            exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin < '" + tmpFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            Assert.assertTrue((String)"Enter password prompt", (boolean)((String)exe.stdoutLines().get(0)).startsWith("Enter password: "));
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientLoginWithDefaultConfigInteractive() throws IOException {
        if (!KcAdmTest.runIntermittentlyFailingTests()) {
            System.out.println("TEST SKIPPED - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it.");
            return;
        }
        KcAdmExec exe = (KcAdmExec)KcAdmExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm test --client admin-cli-secret").executeAsync();
        exe.waitForStdout("Enter client secret: ");
        exe.sendToStdin("password" + OsUtil.EOL);
        exe.waitCompletion();
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
        Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as service-account-admin-cli-secret of realm test"), exe.stderrLines().get(0));
        File tmpFile = new File(KcAdmExec.WORK_DIR + "/" + UUID.randomUUID().toString() + ".tmp");
        try {
            FileOutputStream tmpos = new FileOutputStream(tmpFile);
            tmpos.write("password".getBytes());
            tmpos.write(OsUtil.EOL.getBytes());
            tmpos.close();
            exe = (KcAdmExec)KcAdmExec.newBuilder().argsLine("config credentials --server " + this.serverUrl + " --realm test --client admin-cli-secret < '" + tmpFile.getName() + "'").execute();
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            Assert.assertTrue((String)"Enter client secret prompt", (boolean)((String)exe.stdoutLines().get(0)).startsWith("Enter client secret: "));
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as service-account-admin-cli-secret of realm test"), exe.stderrLines().get(0));
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserLoginWithCustomConfig() {
        FileConfigHandler handler = this.initCustomConfigFile();
        File configFile = new File(handler.getConfigFile());
        try {
            KcAdmExec exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            Assert.assertEquals((String)"stderr first line", (Object)("Logging into " + this.serverUrl + " as user admin of realm master"), exe.stderrLines().get(0));
            ConfigData config = handler.loadConfig();
            Assert.assertEquals((String)"serverUrl", (Object)this.serverUrl, (Object)config.getServerUrl());
            Assert.assertEquals((String)"realm", (Object)"master", (Object)config.getRealm());
            RealmConfigData realmcfg = config.sessionRealmConfigData();
            Assert.assertNotNull((String)"realm config data no null", (Object)realmcfg);
            Assert.assertEquals((String)"realm cfg serverUrl", (Object)this.serverUrl, (Object)realmcfg.serverUrl());
            Assert.assertEquals((String)"realm cfg realm", (Object)"master", (Object)realmcfg.realm());
            Assert.assertEquals((String)"client id", (Object)"admin-cli", (Object)realmcfg.getClientId());
            Assert.assertNotNull((String)"token not null", (Object)realmcfg.getToken());
            Assert.assertNotNull((String)"refresh token not null", (Object)realmcfg.getRefreshToken());
            Assert.assertNotNull((String)"token expires not null", (Object)realmcfg.getExpiresAt());
            Assert.assertNotNull((String)"token expires in future", (Object)(realmcfg.getExpiresAt() > System.currentTimeMillis() ? 1 : 0));
            Assert.assertNotNull((String)"refresh token expires not null", (Object)realmcfg.getRefreshExpiresAt());
            Assert.assertNotNull((String)"refresh token expires in future", (Object)(realmcfg.getRefreshExpiresAt() > System.currentTimeMillis() ? 1 : 0));
        }
        finally {
            configFile.delete();
        }
    }

    @Test
    public void testCustomConfigLoginCreateDelete() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcAdmExec exe = KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            ConfigData config1 = handler.loadConfig();
            exe = KcAdmExec.execute((String)("create --config '" + configFile.getName() + "' clients -s clientId=test-client -o"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ConfigData config2 = handler.loadConfig();
            this.assertFieldsEqualWithExclusions(config1, config2, new String[0]);
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client.getClientId());
            exe = KcAdmExec.execute((String)("delete clients/" + client.getId() + " --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            ConfigData config3 = handler.loadConfig();
            this.assertFieldsEqualWithExclusions(config2, config3, new String[0]);
        }
    }

    @Test
    public void testCRUDWithOnTheFlyUserAuth() throws IOException {
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    public void testCRUDWithOnTheFlyUserAuthWithClientSecret() throws IOException {
        KcAdmExec exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client admin-cli-secret --secret password"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Client not allowed for direct access grants [unauthorized_client]", exe.stderrLines().get(1));
        exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password wrong --client admin-cli-secret-direct --secret password"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid user credentials [invalid_grant]", exe.stderrLines().get(1));
        exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client admin-cli-secret-direct --secret wrong"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid client secret [unauthorized_client]", exe.stderrLines().get(1));
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass --client admin-cli-secret-direct --secret password", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    public void testCRUDWithOnTheFlyUserAuthWithSignedJwtClient() throws IOException {
        File keystore = new File(System.getProperty("user.dir") + "/src/test/resources/cli/kcadm/admin-cli-keystore.jks");
        Assert.assertTrue((String)"admin-cli-keystore.jks exists", (boolean)keystore.isFile());
        KcAdmExec exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client admin-cli-jwt --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias admin-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Client not allowed for direct access grants [unauthorized_client]", exe.stderrLines().get(1));
        exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password wrong --client admin-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias admin-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Invalid user credentials [invalid_grant]", exe.stderrLines().get(1));
        exe = KcAdmExec.execute((String)("get clients --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass --client admin-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass wrong --keypass keypass --alias admin-cli"));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"login message", (Object)("Logging into " + this.serverUrl + " as user user1 of realm test"), exe.stderrLines().get(0));
        Assert.assertEquals((String)"error message", (Object)"Failed to load private key: Keystore was tampered with, or password was incorrect", exe.stderrLines().get(1));
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--user user1 --password userpass  --client admin-cli-jwt-direct --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias admin-cli", "", "Logging into " + this.serverUrl + " as user user1 of realm test");
    }

    @Test
    public void testCRUDWithOnTheFlyServiceAccountWithClientSecret() throws IOException {
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--client admin-cli-secret --secret password", "", "Logging into " + this.serverUrl + " as service-account-admin-cli-secret of realm test");
    }

    @Test
    public void testCRUDWithOnTheFlyServiceAccountWithSignedJwtClient() throws IOException {
        File keystore = new File(System.getProperty("user.dir") + "/src/test/resources/cli/kcadm/admin-cli-keystore.jks");
        Assert.assertTrue((String)"admin-cli-keystore.jks exists", (boolean)keystore.isFile());
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, "--client admin-cli-jwt --keystore '" + keystore.getAbsolutePath() + "' --storepass storepass --keypass keypass --alias admin-cli", "", "Logging into " + this.serverUrl + " as service-account-admin-cli-jwt of realm test");
    }

    @Test
    public void testCRUDWithToken() throws Exception {
        this.oauth.baseUrl(this.serverUrl);
        this.oauth.realm("master");
        this.oauth.clientId("admin-cli");
        String token = this.oauth.doGrantAccessTokenRequest("", "admin", "admin").getAccessToken();
        this.testCRUDWithOnTheFlyAuth(this.serverUrl, " --token " + token, "", "");
    }

    @Test
    public void testGetUserNameExact() {
        KcAdmExec.execute((String)("config credentials --server " + this.serverUrl + " --realm master --user admin --password admin"));
        KcAdmExec.execute((String)"create realms -s realm=demorealm -s enabled=true");
        KcAdmExec.execute((String)"create users -r demorealm -s username=testuser");
        KcAdmExec.execute((String)"create users -r demorealm -s username=anothertestuser");
        KcAdmExec.execute((String)"create users -r demorealm -s username=onemoretestuser");
        KcAdmExec exec = KcAdmExec.execute((String)"add-roles --uusername=testuser --rolename offline_access --target-realm=demorealm");
        Assert.assertEquals((long)0L, (long)exec.exitCode());
    }
}

