/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.admin.cli.config.FileConfigHandler;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcAdmExec;
import org.keycloak.testsuite.cli.admin.AbstractAdmCliTest;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.util.TempFileResource;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcAdmSessionTest
extends AbstractAdmCliTest {
    static TypeReference<List<ObjectNode>> LIST_OF_JSON = new TypeReference<List<ObjectNode>>(){};

    @Test
    public void test() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            this.loginAsUser(configFile.getFile(), this.serverUrl, "master", "admin", "admin");
            KcAdmExec exe = KcAdmExec.execute((String)("create realms --config '" + configFile.getName() + "' -s realm=demorealm -s enabled=true"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            Assert.assertTrue((boolean)((String)exe.stderrLines().get(0)).startsWith("Created "));
            exe = KcAdmExec.execute((String)("create users --config '" + configFile.getName() + "' -r demorealm -s username=testuser -s enabled=true -i"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 0);
            String userId = (String)exe.stdoutLines().get(0);
            exe = KcAdmExec.execute((String)("add-roles --config '" + configFile.getName() + "' -r demorealm --uusername testuser --cclientid realm-management --rolename realm-admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("set-password --config '" + configFile.getName() + "' -r demorealm --username testuser -p password"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            this.loginAsUser(configFile.getFile(), this.serverUrl, "demorealm", "testuser", "password");
            exe = KcAdmExec.execute((String)("get-roles --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            List<ObjectNode> roles = AbstractAdminTest.loadJson(exe.stdout(), LIST_OF_JSON);
            Assert.assertThat((String)"expected three realm roles available", (Object)roles.size(), (Matcher)Matchers.equalTo((Object)3));
            exe = KcAdmExec.execute((String)("create roles --config '" + configFile.getName() + "' -s name=testrole -s 'description=Test role' -o"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ObjectNode role = AbstractAdminTest.loadJson(exe.stdout(), ObjectNode.class);
            Assert.assertEquals((Object)"testrole", (Object)role.get("name").asText());
            String roleId = role.get("id").asText();
            exe = KcAdmExec.execute((String)("get-roles --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            roles = AbstractAdminTest.loadJson(exe.stdout(), LIST_OF_JSON);
            Assert.assertThat((String)"expected four realm roles available", (Object)roles.size(), (Matcher)Matchers.equalTo((Object)4));
            exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -s clientId=testclient -i"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 0);
            String idOfClient = (String)exe.stdoutLines().get(0);
            exe = KcAdmExec.execute((String)("create clients/" + idOfClient + "/roles --config '" + configFile.getName() + "' -s name=clientrole  -s 'description=Test client role'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            Assert.assertTrue((boolean)((String)exe.stderrLines().get(0)).startsWith("Created "));
            exe = KcAdmExec.execute((String)("get-roles --config '" + configFile.getName() + "' --cclientid testclient"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            roles = AbstractAdminTest.loadJson(exe.stdout(), LIST_OF_JSON);
            Assert.assertThat((String)"expected one role", (Object)roles.size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertEquals((Object)"clientrole", (Object)roles.get(0).get("name").asText());
            exe = KcAdmExec.execute((String)("add-roles --config '" + configFile.getName() + "' --uusername testuser --cclientid testclient --rolename clientrole"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("get-roles --config '" + configFile.getName() + "' --uusername testuser --all"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ObjectNode node = AbstractAdminTest.loadJson(exe.stdout(), ObjectNode.class);
            Assert.assertNotNull((Object)node.get("realmMappings"));
            List realmMappings = StreamSupport.stream(node.get("realmMappings").spliterator(), false).map(o -> o.get("name").asText()).sorted().collect(Collectors.toList());
            Assert.assertEquals(Arrays.asList("default-roles-demorealm"), realmMappings);
            ObjectNode clientRoles = (ObjectNode)node.get("clientMappings");
            List fields = StreamSupport.stream(clientRoles.spliterator(), false).map(o -> o.get("client").asText()).sorted().collect(Collectors.toList());
            Assert.assertEquals(Arrays.asList("realm-management", "testclient"), fields);
            realmMappings = StreamSupport.stream(clientRoles.get("realm-management").get("mappings").spliterator(), false).map(o -> o.get("name").asText()).sorted().collect(Collectors.toList());
            Assert.assertEquals(Arrays.asList("realm-admin"), realmMappings);
            realmMappings = StreamSupport.stream(clientRoles.get("testclient").get("mappings").spliterator(), false).map(o -> o.get("name").asText()).sorted().collect(Collectors.toList());
            Assert.assertEquals(Arrays.asList("clientrole"), realmMappings);
            exe = KcAdmExec.execute((String)("add-roles --config '" + configFile.getName() + "' --uusername testuser --rolename testrole"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("get-roles --config '" + configFile.getName() + "' --uusername testuser --all"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            node = AbstractAdminTest.loadJson(exe.stdout(), ObjectNode.class);
            Assert.assertNotNull((Object)node.get("realmMappings"));
            realmMappings = StreamSupport.stream(node.get("realmMappings").spliterator(), false).map(o -> o.get("name").asText()).sorted().collect(Collectors.toList());
            Assert.assertEquals(Arrays.asList("default-roles-demorealm", "testrole"), realmMappings);
            exe = KcAdmExec.execute((String)("create groups --config '" + configFile.getName() + "' -s name=TestUsers -i"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            String groupId = (String)exe.stdoutLines().get(0);
            exe = KcAdmExec.execute((String)("create groups/" + groupId + "/children --config '" + configFile.getName() + "' -s name=TestPowerUsers -i"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            String subGroupId = (String)exe.stdoutLines().get(0);
            exe = KcAdmExec.execute((String)("update users/" + userId + "/groups/" + subGroupId + " --config '" + configFile.getName() + "' -s realm=demorealm -s userId=" + userId + " -s groupId=" + subGroupId + " -n"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete groups/" + subGroupId + " --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete groups/" + groupId + " --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete clients/" + idOfClient + " --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete roles/testrole --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete users/" + userId + " --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcAdmExec.execute((String)("delete realms/demorealm --config '" + configFile.getName() + "' --realm master"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        }
    }

    @Test
    public void testCompositeRoleCreationWithHigherVolumeOfRoles() throws Exception {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            this.loginAsUser(configFile.getFile(), this.serverUrl, "master", "admin", "admin");
            String realmName = "HigherVolumeRolesRealm";
            KcAdmExec exe = KcAdmExec.execute((String)String.format("create realms --config '%s' -s realm=%s -s enabled=true", configFile.getName(), "HigherVolumeRolesRealm"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            for (int i = 0; i < 20; ++i) {
                exe = KcAdmExec.execute((String)String.format("create roles --config '%s' -r %s -s name=ROLE%d", configFile.getName(), "HigherVolumeRolesRealm", i));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 1);
            }
            exe = KcAdmExec.execute((String)String.format("add-roles --config '%s' -r %s --rname ROLE11 --cclientid realm-management --rolename impersonation --rolename view-users --rolename view-realm --rolename manage-users", configFile.getName(), "HigherVolumeRolesRealm"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        }
    }
}

