/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class UsernameTemplateMapperTest
extends AbstractBaseBrokerTest {
    private String idpUserId;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Before
    public void addClients() {
        this.addClientsToProviderAndConsumer();
    }

    @Before
    public void addIdentityProviderToConsumerRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderRepresentation idp = this.bc.setUpIdentityProvider();
        realm.identityProviders().create(idp).close();
        IdentityProviderResource idpResource = realm.identityProviders().get(idp.getAlias());
        for (IdentityProviderMapperRepresentation mapper : this.createIdentityProviderMappers()) {
            mapper.setIdentityProviderAlias(this.bc.getIDPAlias());
            idpResource.addMapper(mapper).close();
        }
    }

    @Before
    public void createUserInIdp() {
        this.idpUserId = this.createUser(this.bc.providerRealmName(), this.bc.getUserLogin(), this.bc.getUserPassword(), "First", "Last", this.bc.getUserEmail());
    }

    protected Iterable<IdentityProviderMapperRepresentation> createIdentityProviderMappers() {
        IdentityProviderMapperRepresentation userTemplateImporterMapper = new IdentityProviderMapperRepresentation();
        userTemplateImporterMapper.setName("custom-username-import-mapper");
        userTemplateImporterMapper.setIdentityProviderMapper("oidc-username-idp-mapper");
        userTemplateImporterMapper.setConfig((Map)ImmutableMap.builder().put((Object)"template", (Object)"${ALIAS}:${CLAIM.sub}").build());
        IdentityProviderMapperRepresentation jwtClaimsAttrMapper = new IdentityProviderMapperRepresentation();
        jwtClaimsAttrMapper.setName("jwt-claims-mapper");
        jwtClaimsAttrMapper.setIdentityProviderMapper("oidc-user-attribute-idp-mapper");
        jwtClaimsAttrMapper.setConfig((Map)ImmutableMap.builder().put((Object)"claim", (Object)"sub").put((Object)"user.attribute", (Object)"mappedSub").put((Object)"claim.value", (Object)"${CLAIM.sub};test").build());
        return Lists.newArrayList((Object[])new IdentityProviderMapperRepresentation[]{userTemplateImporterMapper, jwtClaimsAttrMapper});
    }

    @Test
    public void usernameShouldBeDerivedFromAliasAndIdpSubClaim() {
        this.logInAsUserInIDP();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        UserRepresentation user = (UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserEmail(), Integer.valueOf(0), Integer.valueOf(1)).get(0);
        String username = user.getUsername();
        Assert.assertEquals((String)"Should render alias:sub as Username", (Object)(this.bc.getIDPAlias() + ":" + this.idpUserId), (Object)username);
    }

    @Test
    public void userAttributeShouldBeDerivedFromIdpSubClaim() {
        this.logInAsUserInIDP();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        UserRepresentation user = (UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserEmail(), Integer.valueOf(0), Integer.valueOf(1)).get(0);
        Assert.assertEquals((String)"Should render idpSub as mappedSub attribute", (Object)this.idpUserId, ((List)user.getAttributes().get("mappedSub")).get(0));
    }
}

