/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.auth.page.login.UpdateAccount;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.social.AbstractSocialLoginPage;
import org.keycloak.testsuite.pages.social.BitbucketLoginPage;
import org.keycloak.testsuite.pages.social.FacebookLoginPage;
import org.keycloak.testsuite.pages.social.GitHubLoginPage;
import org.keycloak.testsuite.pages.social.GitLabLoginPage;
import org.keycloak.testsuite.pages.social.GoogleLoginPage;
import org.keycloak.testsuite.pages.social.InstagramLoginPage;
import org.keycloak.testsuite.pages.social.LinkedInLoginPage;
import org.keycloak.testsuite.pages.social.MicrosoftLoginPage;
import org.keycloak.testsuite.pages.social.OpenShiftLoginPage;
import org.keycloak.testsuite.pages.social.PayPalLoginPage;
import org.keycloak.testsuite.pages.social.StackOverflowLoginPage;
import org.keycloak.testsuite.pages.social.TwitterLoginPage;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class SocialLoginTest
extends AbstractKeycloakTest {
    public static final String SOCIAL_CONFIG = "social.config";
    public static final String REALM = "social";
    public static final String EXCHANGE_CLIENT = "exchange-client";
    private static final Properties config = new Properties();
    @Page
    private LoginPage loginPage;
    @Page
    private UpdateAccount updateAccountPage;
    private Provider currentTestProvider = null;
    private AbstractSocialLoginPage currentSocialLoginPage = null;

    @BeforeClass
    public static void loadConfig() throws Exception {
        Assume.assumeTrue((boolean)System.getProperties().containsKey(SOCIAL_CONFIG));
        config.load(new FileInputStream(System.getProperty(SOCIAL_CONFIG)));
    }

    @Before
    public void beforeSocialLoginTest() {
        this.accountPage.setAuthRealm(REALM);
    }

    @After
    public void afterSocialLoginTest() {
        this.currentTestProvider = null;
    }

    private void removeUser() {
        List users = this.adminClient.realm(REALM).users().search(null, null, null);
        for (UserRepresentation user : users) {
            if (user.getServiceAccountClientId() != null) continue;
            this.log.infof("removing test user '%s'", (Object)user.getUsername());
            this.adminClient.realm(REALM).users().get(user.getId()).remove();
        }
    }

    private void setTestProvider(Provider provider) {
        this.adminClient.realm(REALM).identityProviders().create(this.buildIdp(provider));
        this.log.infof("added '%s' identity provider", (Object)provider.id());
        this.currentTestProvider = provider;
        this.currentSocialLoginPage = (AbstractSocialLoginPage)Graphene.createPageFragment(this.currentTestProvider.pageObjectClazz(), (WebElement)this.driver.findElement(By.tagName((String)"html")));
        if (provider == Provider.OPENSHIFT4 || provider == Provider.OPENSHIFT4_KUBE_ADMIN) {
            ((OpenShiftLoginPage)this.currentSocialLoginPage).setUserLoginLinkTitle(this.getConfig(this.currentTestProvider, "loginBtnTitle"));
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation rep = RealmBuilder.create().name(REALM).build();
        testRealms.add(rep);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    public static void setupClientExchangePermissions(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM);
        ClientModel client = session.clients().getClientByClientId(realm, EXCHANGE_CLIENT);
        if (client != null) {
            return;
        }
        client = realm.addClient(EXCHANGE_CLIENT);
        client.setSecret("secret");
        client.setPublicClient(false);
        client.setProtocol("openid-connect");
        client.setEnabled(true);
        client.setDirectAccessGrantsEnabled(true);
        ClientPolicyRepresentation clientPolicyRep = new ClientPolicyRepresentation();
        clientPolicyRep.setName("client-policy");
        clientPolicyRep.addClient(new String[]{client.getId()});
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        management.users().setPermissionsEnabled(true);
        ResourceServer server = management.realmResourceServer();
        Policy clientPolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientPolicyRep, server);
        management.users().adminImpersonatingPermission().addAssociatedPolicy(clientPolicy);
        management.users().adminImpersonatingPermission().setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        realm.getIdentityProvidersStream().forEach(idp -> {
            management.idps().setPermissionsEnabled(idp, true);
            management.idps().exchangeToPermission(idp).addAssociatedPolicy(clientPolicy);
        });
    }

    @Test
    @UncaughtServerErrorExpected
    public void openshiftLogin() {
        this.setTestProvider(Provider.OPENSHIFT);
        this.performLogin();
        this.assertUpdateProfile(false, false, true);
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    @UncaughtServerErrorExpected
    public void openshift4Login() {
        this.setTestProvider(Provider.OPENSHIFT4);
        this.performLogin();
        this.assertUpdateProfile(false, false, true);
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    public void openshift4KubeAdminLogin() {
        this.setTestProvider(Provider.OPENSHIFT4_KUBE_ADMIN);
        this.performLogin();
        this.assertUpdateProfile(true, true, true);
        this.assertAccount();
    }

    @Test
    @UncaughtServerErrorExpected
    public void openshift4LoginWithGroupsMapper() {
        this.setTestProvider(Provider.OPENSHIFT4);
        this.addAttributeMapper("ocp-groups", "groups");
        this.performLogin();
        this.assertUpdateProfile(false, false, true);
        this.assertAccount();
        this.assertAttribute("ocp-groups", this.getConfig("groups"));
    }

    @Test
    @UncaughtServerErrorExpected
    public void googleLogin() throws InterruptedException {
        this.setTestProvider(Provider.GOOGLE);
        this.performLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    @UncaughtServerErrorExpected
    public void googleHostedDomainLogin() throws InterruptedException {
        this.setTestProvider(Provider.GOOGLE_HOSTED_DOMAIN);
        this.navigateToLoginPage();
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("hd=" + this.getConfig(Provider.GOOGLE_HOSTED_DOMAIN, "hostedDomain")));
        this.doLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    public void googleNonMatchingHostedDomainLogin() throws InterruptedException {
        this.setTestProvider(Provider.GOOGLE_NON_MATCHING_HOSTED_DOMAIN);
        this.navigateToLoginPage();
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("hd=non-matching-hosted-domain"));
        this.doLogin();
        WaitUtils.waitForPageToLoad();
        WebElement errorMessage = this.driver.findElement(By.xpath((String)".//p[@class='instruction']"));
        Assert.assertTrue((boolean)errorMessage.isDisplayed());
        Assert.assertEquals((Object)"Unexpected error when authenticating with identity provider", (Object)errorMessage.getText());
    }

    @Test
    @UncaughtServerErrorExpected
    public void bitbucketLogin() throws InterruptedException {
        this.setTestProvider(Provider.BITBUCKET);
        this.performLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    @UncaughtServerErrorExpected
    public void gitlabLogin() throws InterruptedException {
        this.setTestProvider(Provider.GITLAB);
        this.performLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    @UncaughtServerErrorExpected
    public void facebookLogin() throws InterruptedException {
        this.setTestProvider(Provider.FACEBOOK);
        this.performLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    @UncaughtServerErrorExpected
    public void facebookLoginWithEnhancedScope() throws InterruptedException {
        this.setTestProvider(Provider.FACEBOOK_INCLUDE_BIRTHDAY);
        this.addAttributeMapper("birthday", "birthday");
        this.performLogin();
        this.assertAccount();
        this.assertAttribute("birthday", this.getConfig("profile.birthday"));
        this.testTokenExchange();
    }

    @Test
    public void instagramLogin() throws InterruptedException {
        this.setTestProvider(Provider.INSTAGRAM);
        this.performLogin();
        this.assertUpdateProfile(true, true, true);
        this.assertAccount();
    }

    @Test
    @UncaughtServerErrorExpected
    public void githubLogin() throws InterruptedException {
        this.setTestProvider(Provider.GITHUB);
        this.performLogin();
        this.assertAccount();
        this.testTokenExchange();
    }

    @Test
    public void githubPrivateEmailLogin() throws InterruptedException {
        this.setTestProvider(Provider.GITHUB_PRIVATE_EMAIL);
        this.performLogin();
        this.assertAccount();
    }

    @Test
    public void twitterLogin() {
        this.setTestProvider(Provider.TWITTER);
        this.performLogin();
        this.assertAccount();
    }

    @Test
    public void linkedinLogin() {
        this.setTestProvider(Provider.LINKEDIN);
        this.performLogin();
        this.assertAccount();
    }

    @Test
    public void microsoftLogin() {
        this.setTestProvider(Provider.MICROSOFT);
        this.performLogin();
        this.assertAccount();
    }

    @Test
    public void paypalLogin() {
        this.setTestProvider(Provider.PAYPAL);
        this.performLogin();
        this.assertAccount();
    }

    @Test
    public void stackoverflowLogin() throws InterruptedException {
        this.setTestProvider(Provider.STACKOVERFLOW);
        this.performLogin();
        this.assertUpdateProfile(false, false, true);
        this.assertAccount();
    }

    public IdentityProviderRepresentation buildIdp(Provider provider) {
        IdentityProviderRepresentation idp = IdentityProviderBuilder.create().alias(provider.id()).providerId(provider.id()).build();
        idp.setEnabled(true);
        idp.setStoreToken(true);
        idp.getConfig().put("clientId", this.getConfig(provider, "clientId"));
        idp.getConfig().put("clientSecret", this.getConfig(provider, "clientSecret"));
        if (provider == Provider.GOOGLE_HOSTED_DOMAIN) {
            String hostedDomain = this.getConfig(provider, "hostedDomain");
            if (hostedDomain == null) {
                throw new IllegalArgumentException("'hostedDomain' for Google IdP must be specified");
            }
            idp.getConfig().put("hostedDomain", hostedDomain);
        }
        if (provider == Provider.GOOGLE_NON_MATCHING_HOSTED_DOMAIN) {
            idp.getConfig().put("hostedDomain", "non-matching-hosted-domain");
        }
        if (provider == Provider.STACKOVERFLOW) {
            idp.getConfig().put("key", this.getConfig(provider, "clientKey"));
        }
        if (provider == Provider.OPENSHIFT || provider == Provider.OPENSHIFT4 || provider == Provider.OPENSHIFT4_KUBE_ADMIN) {
            idp.getConfig().put("baseUrl", this.getConfig(provider, "baseUrl"));
        }
        if (provider == Provider.PAYPAL) {
            idp.getConfig().put("sandbox", this.getConfig(provider, "sandbox"));
        }
        if (provider == Provider.FACEBOOK_INCLUDE_BIRTHDAY) {
            idp.getConfig().put("defaultScope", "public_profile,email,user_birthday");
            idp.getConfig().put("fetchedFields", "birthday");
        }
        return idp;
    }

    private void addAttributeMapper(String name, String jsonField) {
        IdentityProviderResource identityProvider = this.adminClient.realm(REALM).identityProviders().get(this.currentTestProvider.id);
        IdentityProviderRepresentation identityProviderRepresentation = identityProvider.toRepresentation();
        IdentityProviderMapperRepresentation mapperRepresentation = new IdentityProviderMapperRepresentation();
        mapperRepresentation.setName(name);
        mapperRepresentation.setIdentityProviderAlias(identityProviderRepresentation.getAlias());
        mapperRepresentation.setIdentityProviderMapper(this.currentTestProvider.id + "-user-attribute-mapper");
        mapperRepresentation.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderMapperSyncMode.IMPORT.toString()).put((Object)"jsonField", (Object)jsonField).put((Object)"userAttribute", (Object)name).build());
        identityProvider.addMapper(mapperRepresentation).close();
    }

    private String getConfig(Provider provider, String key) {
        String providerKey = provider.configId() + "." + key;
        return System.getProperty("social." + providerKey, config.getProperty(providerKey, config.getProperty("common." + key)));
    }

    private String getConfig(String key) {
        return this.getConfig(this.currentTestProvider, key);
    }

    private void performLogin() {
        this.navigateToLoginPage();
        this.doLogin();
    }

    private void navigateToLoginPage() {
        this.currentSocialLoginPage.logout();
        this.accountPage.navigateTo();
        this.loginPage.clickSocial(this.currentTestProvider.id());
        WaitUtils.pause((long)3000L);
        WaitUtils.waitForPageToLoad();
    }

    private void doLogin() {
        if (URLUtils.currentUrlDoesntStartWith((String)this.getAuthServerRoot().toASCIIString())) {
            this.log.infof("current URL: %s", (Object)this.driver.getCurrentUrl());
            this.log.infof("performing log in to '%s' ...", (Object)this.currentTestProvider.id());
            this.currentSocialLoginPage.login(this.getConfig("username"), this.getConfig("password"));
        } else {
            this.log.infof("already logged in to '%s'; skipping the login process", (Object)this.currentTestProvider.id());
        }
        WaitUtils.pause((long)3000L);
        WaitUtils.waitForPageToLoad();
    }

    private void assertAccount() {
        Assert.assertTrue((boolean)URLUtils.currentUrlStartsWith((String)this.accountPage.toString()));
        Assert.assertEquals((Object)this.getConfig("profile.firstName"), (Object)this.accountPage.getFirstName());
        Assert.assertEquals((Object)this.getConfig("profile.lastName"), (Object)this.accountPage.getLastName());
        Assert.assertEquals((Object)this.getConfig("profile.email"), (Object)this.accountPage.getEmail());
    }

    private void assertAttribute(String attrName, String expectedValue) {
        List users = this.adminClient.realm(REALM).users().search(null, null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertNotNull((Object)((UserRepresentation)users.get(0)).getAttributes());
        Assert.assertNotNull(((UserRepresentation)users.get(0)).getAttributes().get(attrName));
        Assert.assertEquals((Object)expectedValue, ((List)((UserRepresentation)users.get(0)).getAttributes().get(attrName)).get(0));
    }

    private void assertUpdateProfile(boolean firstName, boolean lastName, boolean email) {
        Assert.assertTrue((boolean)URLUtils.currentUrlDoesntStartWith((String)this.accountPage.toString()));
        if (firstName) {
            Assert.assertTrue((boolean)this.updateAccountPage.fields().getFirstName().isEmpty());
            this.updateAccountPage.fields().setFirstName(this.getConfig("profile.firstName"));
        } else {
            Assert.assertEquals((Object)this.getConfig("profile.firstName"), (Object)this.updateAccountPage.fields().getFirstName());
        }
        if (lastName) {
            Assert.assertTrue((boolean)this.updateAccountPage.fields().getLastName().isEmpty());
            this.updateAccountPage.fields().setLastName(this.getConfig("profile.lastName"));
        } else {
            Assert.assertEquals((Object)this.getConfig("profile.lastName"), (Object)this.updateAccountPage.fields().getLastName());
        }
        if (email) {
            Assert.assertTrue((boolean)this.updateAccountPage.fields().getEmail().isEmpty());
            this.updateAccountPage.fields().setEmail(this.getConfig("profile.email"));
        } else {
            Assert.assertEquals((Object)this.getConfig("profile.email"), (Object)this.updateAccountPage.fields().getEmail());
        }
        this.updateAccountPage.submit();
    }

    private WebTarget getExchangeUrl(Client httpClient) {
        return httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path(REALM).path("protocol/openid-connect/token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse checkFeature(int expectedStatusCode, String username) {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        Response response = null;
        try {
            this.testingClient.server().run(SocialLoginTest::setupClientExchangePermissions);
            WebTarget exchangeUrl = this.getExchangeUrl((Client)httpClient);
            response = exchangeUrl.request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)EXCHANGE_CLIENT, (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("requested_subject", username).param("requested_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_issuer", this.currentTestProvider.id())));
            Assert.assertEquals((long)expectedStatusCode, (long)response.getStatus());
            if (expectedStatusCode == Response.Status.OK.getStatusCode()) {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
                return accessTokenResponse;
            }
            AccessTokenResponse accessTokenResponse = null;
            return accessTokenResponse;
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testTokenExchange() {
        List users = this.adminClient.realm(REALM).users().search(null, null, null);
        Assert.assertEquals((long)1L, (long)users.size());
        String username = ((UserRepresentation)users.get(0)).getUsername();
        this.checkFeature(501, username);
        Response tokenResp = this.testingClient.testing().enableFeature(Profile.Feature.TOKEN_EXCHANGE.toString());
        Assert.assertEquals((long)200L, (long)tokenResp.getStatus());
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.TOKEN_EXCHANGE);
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        try {
            AccessTokenResponse tokenResponse = this.checkFeature(200, username);
            Assert.assertNotNull((Object)tokenResponse);
            String socialToken = tokenResponse.getToken();
            Assert.assertNotNull((Object)socialToken);
            this.removeUser();
            users = this.adminClient.realm(REALM).users().search(null, null, null);
            Assert.assertEquals((long)0L, (long)users.size());
            Response response = this.getExchangeUrl((Client)httpClient).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)EXCHANGE_CLIENT, (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", socialToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("subject_issuer", this.currentTestProvider.id())));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            users = this.adminClient.realm(REALM).users().search(null, null, null);
            Assert.assertEquals((long)1L, (long)users.size());
            Assert.assertEquals((Object)username, (Object)((UserRepresentation)users.get(0)).getUsername());
            this.removeUser();
            users = this.adminClient.realm(REALM).users().search(null, null, null);
            Assert.assertEquals((long)0L, (long)users.size());
            IdentityProviderRepresentation idp = this.adminClient.realm(REALM).identityProviders().get(this.currentTestProvider.id).toRepresentation();
            idp.setStoreToken(false);
            this.adminClient.realm(REALM).identityProviders().get(idp.getAlias()).update(idp);
            response = this.getExchangeUrl((Client)httpClient).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)EXCHANGE_CLIENT, (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", socialToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("subject_issuer", this.currentTestProvider.id())));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            String keycloakToken = tokenResponse.getToken();
            response.close();
            response = this.getExchangeUrl((Client)httpClient).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)EXCHANGE_CLIENT, (String)"secret")).post(Entity.form((Form)new Form().param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", keycloakToken).param("subject_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_token_type", "urn:ietf:params:oauth:token-type:access_token").param("requested_issuer", this.currentTestProvider.id())));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            response.close();
            Assert.assertEquals((Object)socialToken, (Object)tokenResponse.getToken());
            idp = this.adminClient.realm(REALM).identityProviders().get(this.currentTestProvider.id).toRepresentation();
            idp.setStoreToken(true);
            this.adminClient.realm(REALM).identityProviders().get(idp.getAlias()).update(idp);
        }
        finally {
            httpClient.close();
            tokenResp = this.testingClient.testing().disableFeature(Profile.Feature.TOKEN_EXCHANGE.toString());
            Assert.assertEquals((long)200L, (long)tokenResp.getStatus());
            this.checkFeature(501, username);
        }
    }

    public static enum Provider {
        GOOGLE("google", GoogleLoginPage.class),
        GOOGLE_HOSTED_DOMAIN("google", "google-hosted-domain", GoogleLoginPage.class),
        GOOGLE_NON_MATCHING_HOSTED_DOMAIN("google", "google-hosted-domain", GoogleLoginPage.class),
        FACEBOOK("facebook", FacebookLoginPage.class),
        FACEBOOK_INCLUDE_BIRTHDAY("facebook", FacebookLoginPage.class),
        GITHUB("github", GitHubLoginPage.class),
        GITHUB_PRIVATE_EMAIL("github", "github-private-email", GitHubLoginPage.class),
        TWITTER("twitter", TwitterLoginPage.class),
        LINKEDIN("linkedin", LinkedInLoginPage.class),
        MICROSOFT("microsoft", MicrosoftLoginPage.class),
        PAYPAL("paypal", PayPalLoginPage.class),
        STACKOVERFLOW("stackoverflow", StackOverflowLoginPage.class),
        OPENSHIFT("openshift-v3", OpenShiftLoginPage.class),
        OPENSHIFT4("openshift-v4", OpenShiftLoginPage.class),
        OPENSHIFT4_KUBE_ADMIN("openshift-v4", "openshift-v4-admin", OpenShiftLoginPage.class),
        GITLAB("gitlab", GitLabLoginPage.class),
        BITBUCKET("bitbucket", BitbucketLoginPage.class),
        INSTAGRAM("instagram", InstagramLoginPage.class);

        private final String id;
        private final Class<? extends AbstractSocialLoginPage> pageObjectClazz;
        private String configId = null;

        private Provider(String id, Class<? extends AbstractSocialLoginPage> pageObjectClazz) {
            this.id = id;
            this.pageObjectClazz = pageObjectClazz;
        }

        private Provider(String id, String configId, Class<? extends AbstractSocialLoginPage> pageObjectClazz) {
            this.id = id;
            this.pageObjectClazz = pageObjectClazz;
            this.configId = configId;
        }

        public String id() {
            return this.id;
        }

        public Class<? extends AbstractSocialLoginPage> pageObjectClazz() {
            return this.pageObjectClazz;
        }

        public String configId() {
            return this.configId != null ? this.configId : this.id;
        }
    }
}

