/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.OidcClaimToRoleMapperTest;

public class OidcMultipleClaimToRoleMappersTest
extends OidcClaimToRoleMapperTest {
    private static final String CLAIMS_OR_ATTRIBUTES = "[\n  {\n    \"key\": \"test attribute\",\n    \"value\": \"test value*\"\n  }\n]";

    @Override
    protected void createClaimToRoleMapper(IdentityProviderRepresentation idp, String claimValue, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation firstOidcClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        firstOidcClaimToRoleMapper.setName("claim-to-role-mapper");
        firstOidcClaimToRoleMapper.setIdentityProviderMapper("oidc-role-idp-mapper");
        firstOidcClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"claim", (Object)"user-attribute").put((Object)"claim.value", (Object)claimValue).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        firstOidcClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(firstOidcClaimToRoleMapper).close();
        IdentityProviderMapperRepresentation secondOidcClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        secondOidcClaimToRoleMapper.setName("external-keycloak-role-mapper");
        secondOidcClaimToRoleMapper.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
        secondOidcClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"external.role", (Object)"missing-role").put((Object)"role", (Object)"realm-management.view-realm").build());
        secondOidcClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(secondOidcClaimToRoleMapper).close();
        IdentityProviderMapperRepresentation thirdOidcClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        thirdOidcClaimToRoleMapper.setName("advanced-claim-to-role-mapper");
        thirdOidcClaimToRoleMapper.setIdentityProviderMapper("oidc-advanced-role-idp-mapper");
        thirdOidcClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"claims", (Object)CLAIMS_OR_ATTRIBUTES).put((Object)"are.claim.values.regex", (Object)Boolean.TRUE.toString()).put((Object)"role", (Object)"realm-management.view-realm").build());
        thirdOidcClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(thirdOidcClaimToRoleMapper).close();
    }
}

