/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.tools.ant.filters.StringInputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.RequestedAttributeType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;

public class KcSamlSpDescriptorTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testAttributeConsumingServiceNameInSpMetadata() throws IOException, ParsingException, URISyntaxException {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("attributeConsumingServiceName", "My Attribute Set").update();){
            String spDescriptorString = (String)this.identityProviderResource.export(null).readEntity(String.class);
            SAMLParser parser = SAMLParser.getInstance();
            EntityDescriptorType o = (EntityDescriptorType)parser.parse((InputStream)new StringInputStream(spDescriptorString));
            SPSSODescriptorType spDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)o.getChoiceType().get(0)).getDescriptors().get(0)).getSpDescriptor();
            MatcherAssert.assertThat((Object)spDescriptor.getAttributeConsumingService(), (Matcher)Matchers.empty());
        }
    }

    @Test
    public void testAttributeConsumingServiceMappersInSpMetadataWithoutServiceName() throws IOException, ParsingException, URISyntaxException {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("attributeConsumingServiceIndex", "12").update();){
            IdentityProviderMapperRepresentation attrMapperEmail = new IdentityProviderMapperRepresentation();
            attrMapperEmail.setName("attribute-mapper-email");
            attrMapperEmail.setIdentityProviderMapper("saml-user-attribute-idp-mapper");
            attrMapperEmail.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderMapperSyncMode.INHERIT.toString()).put((Object)"attribute.name", (Object)"email_attr_name").put((Object)"attribute.friendly.name", (Object)"email_attr_friendlyname").put((Object)"user.attribute", (Object)"email").build());
            attrMapperEmail.setIdentityProviderAlias(this.bc.getIDPAlias());
            this.identityProviderResource.addMapper(attrMapperEmail);
            String spDescriptorString = (String)this.identityProviderResource.export(null).readEntity(String.class);
            SAMLParser parser = SAMLParser.getInstance();
            EntityDescriptorType o = (EntityDescriptorType)parser.parse((InputStream)new StringInputStream(spDescriptorString));
            SPSSODescriptorType spDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)o.getChoiceType().get(0)).getDescriptors().get(0)).getSpDescriptor();
            MatcherAssert.assertThat((Object)spDescriptor.getAttributeConsumingService(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getIndex(), (Matcher)Matchers.is((Object)12));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getName(), (Matcher)Matchers.is((Object)"email_attr_name"));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getFriendlyName(), (Matcher)Matchers.is((Object)"email_attr_friendlyname"));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((LocalizedNameType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName().get(0)).getValue(), (Matcher)Matchers.is((Object)this.bc.consumerRealmName()));
        }
    }

    @Test
    public void testAttributeConsumingServiceMappersInSpMetadataWithServiceName() throws IOException, ParsingException, URISyntaxException {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("attributeConsumingServiceIndex", "12").setAttribute("attributeConsumingServiceName", "My Attribute Set").update();){
            IdentityProviderMapperRepresentation attrMapperEmail = new IdentityProviderMapperRepresentation();
            attrMapperEmail.setName("attribute-mapper-email");
            attrMapperEmail.setIdentityProviderMapper("saml-user-attribute-idp-mapper");
            attrMapperEmail.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderMapperSyncMode.INHERIT.toString()).put((Object)"attribute.name", (Object)"email_attr_name").put((Object)"attribute.friendly.name", (Object)"email_attr_friendlyname").put((Object)"user.attribute", (Object)"email").build());
            attrMapperEmail.setIdentityProviderAlias(this.bc.getIDPAlias());
            this.identityProviderResource.addMapper(attrMapperEmail);
            String spDescriptorString = (String)this.identityProviderResource.export(null).readEntity(String.class);
            SAMLParser parser = SAMLParser.getInstance();
            EntityDescriptorType o = (EntityDescriptorType)parser.parse((InputStream)new StringInputStream(spDescriptorString));
            SPSSODescriptorType spDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)o.getChoiceType().get(0)).getDescriptors().get(0)).getSpDescriptor();
            MatcherAssert.assertThat((Object)spDescriptor.getAttributeConsumingService(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getIndex(), (Matcher)Matchers.is((Object)12));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getName(), (Matcher)Matchers.is((Object)"email_attr_name"));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getFriendlyName(), (Matcher)Matchers.is((Object)"email_attr_friendlyname"));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((LocalizedNameType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName().get(0)).getValue(), (Matcher)Matchers.is((Object)"My Attribute Set"));
        }
    }

    @Test
    public void testAttributeConsumingServiceAttributeRoleMapperInSpMetadataWithServiceName() throws IOException, ParsingException, URISyntaxException {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("attributeConsumingServiceIndex", "9").setAttribute("attributeConsumingServiceName", "My Attribute Set").update();){
            IdentityProviderMapperRepresentation attrMapperRole = new IdentityProviderMapperRepresentation();
            attrMapperRole.setName("attribute-mapper-someroleattribute");
            attrMapperRole.setIdentityProviderMapper("saml-role-idp-mapper");
            attrMapperRole.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderMapperSyncMode.INHERIT.toString()).put((Object)"attribute.name", (Object)"role_attr_name").put((Object)"attribute.friendly.name", (Object)"role_attr_friendlyname").put((Object)"role", (Object)"somerole").build());
            attrMapperRole.setIdentityProviderAlias(this.bc.getIDPAlias());
            this.identityProviderResource.addMapper(attrMapperRole);
            String spDescriptorString = (String)this.identityProviderResource.export(null).readEntity(String.class);
            SAMLParser parser = SAMLParser.getInstance();
            EntityDescriptorType o = (EntityDescriptorType)parser.parse((InputStream)new StringInputStream(spDescriptorString));
            SPSSODescriptorType spDescriptor = ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)o.getChoiceType().get(0)).getDescriptors().get(0)).getSpDescriptor();
            MatcherAssert.assertThat((Object)spDescriptor.getAttributeConsumingService(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getIndex(), (Matcher)Matchers.is((Object)9));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getName(), (Matcher)Matchers.is((Object)"role_attr_name"));
            MatcherAssert.assertThat((Object)((RequestedAttributeType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getRequestedAttribute().get(0)).getFriendlyName(), (Matcher)Matchers.is((Object)"role_attr_friendlyname"));
            MatcherAssert.assertThat((Object)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((LocalizedNameType)((AttributeConsumingServiceType)spDescriptor.getAttributeConsumingService().get(0)).getServiceName().get(0)).getValue(), (Matcher)Matchers.is((Object)"My Attribute Set"));
        }
    }
}

