/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.AttributeToRoleMapperTest;

public class KcSamlMultipleAttributeToRoleMappersTest
extends AttributeToRoleMapperTest {
    private static final String ATTRIBUTES_TO_MATCH = "[\n  {\n    \"key\": \"test attribute\",\n    \"value\": \"test value\"\n  }\n]";

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation firstSamlAttributeToRoleMapper = new IdentityProviderMapperRepresentation();
        firstSamlAttributeToRoleMapper.setName("first-role-mapper");
        firstSamlAttributeToRoleMapper.setIdentityProviderMapper("saml-role-idp-mapper");
        firstSamlAttributeToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"user").put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        firstSamlAttributeToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(firstSamlAttributeToRoleMapper).close();
        IdentityProviderMapperRepresentation secondSamlAttributeToRoleMapper = new IdentityProviderMapperRepresentation();
        secondSamlAttributeToRoleMapper.setName("second-role-mapper");
        secondSamlAttributeToRoleMapper.setIdentityProviderMapper("saml-role-idp-mapper");
        secondSamlAttributeToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"missing-role").put((Object)"role", (Object)"realm-management.view-realm").build());
        secondSamlAttributeToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(secondSamlAttributeToRoleMapper).close();
        IdentityProviderMapperRepresentation thirdSamlAttributeToRoleMapper = new IdentityProviderMapperRepresentation();
        thirdSamlAttributeToRoleMapper.setName("advanced-role-mapper");
        thirdSamlAttributeToRoleMapper.setIdentityProviderMapper("saml-advanced-role-idp-mapper");
        thirdSamlAttributeToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attributes", (Object)ATTRIBUTES_TO_MATCH).put((Object)"are.attribute.values.regex", (Object)Boolean.FALSE.toString()).put((Object)"role", (Object)"realm-management.view-realm").build());
        thirdSamlAttributeToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(thirdSamlAttributeToRoleMapper).close();
    }
}

