/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.pages.UpdateAccountInformationPage;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcSamlIdPInitiatedSsoTest
extends AbstractKeycloakTest {
    private static final String PROVIDER_REALM_USER_NAME = "test";
    private static final String PROVIDER_REALM_USER_PASSWORD = "test";
    private static final String CONSUMER_CHOSEN_USERNAME = "mytest";
    @Page
    protected LoginPage accountLoginPage;
    @Page
    protected UpdateAccountInformationPage updateAccountInformationPage;
    private String urlRealmConsumer2;
    private String urlRealmConsumer;
    private String urlRealmProvider;

    protected String getAuthRoot() {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString();
    }

    private RealmRepresentation loadFromClasspath(String fileName, Properties properties) {
        InputStream is = KcSamlIdPInitiatedSsoTest.class.getResourceAsStream(fileName);
        try {
            String template = StreamUtil.readString((InputStream)is);
            String realmString = StringPropertyReplacer.replaceProperties((String)template, (Properties)properties);
            return IOUtil.loadRealm((InputStream)new ByteArrayInputStream(realmString.getBytes("UTF-8")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Before
    public void cleanupTestUserInConsumerRealm() {
        UsersResource users = this.adminClient.realm("consumer").users();
        users.search(CONSUMER_CHOSEN_USERNAME).stream().map(UserRepresentation::getId).map(arg_0 -> ((UsersResource)users).delete(arg_0)).forEach(Response::close);
    }

    @Before
    public void initRealmUrls() {
        this.urlRealmProvider = this.getAuthRoot() + "/auth/realms/" + "provider";
        this.urlRealmConsumer = this.getAuthRoot() + "/auth/realms/" + "consumer";
        this.urlRealmConsumer2 = this.getAuthRoot() + "/auth/realms/" + "consumer" + "-2";
    }

    @Before
    public void resetPrincipalType() {
        IdentityProviderResource idp = this.adminClient.realm("consumer").identityProviders().get("saml-leaf");
        IdentityProviderRepresentation rep = idp.toRepresentation();
        rep.getConfig().put("nameIDPolicyFormat", JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        rep.getConfig().put("principalType", SamlPrincipalType.SUBJECT.name());
        idp.update(rep);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.initRealmUrls();
        Properties p = new Properties();
        p.put("name.realm.provider", "provider");
        p.put("name.realm.consumer", "consumer");
        p.put("url.realm.provider", this.urlRealmProvider);
        p.put("url.realm.consumer", this.urlRealmConsumer);
        p.put("url.realm.consumer-2", this.urlRealmConsumer2);
        testRealms.add(this.loadFromClasspath("kc3731-provider-realm.json", p));
        testRealms.add(this.loadFromClasspath("kc3731-broker-realm.json", p));
    }

    @Test
    public void testProviderIdpInitiatedLogin() throws Exception {
        this.driver.navigate().to(this.getSamlIdpInitiatedUrl("provider", "samlbroker"));
        this.waitForPage("sign in to", true);
        Assert.assertThat((String)"Driver should be on the provider realm page right now", (Object)this.driver.getCurrentUrl(), (Matcher)org.hamcrest.Matchers.containsString((String)"/auth/realms/provider/"));
        this.log.debug((Object)"Logging in");
        this.accountLoginPage.login("test", "test");
        this.waitForPage("update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertThat((String)"We must be on consumer realm right now", (Object)this.driver.getCurrentUrl(), (Matcher)org.hamcrest.Matchers.containsString((String)"/auth/realms/consumer/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(CONSUMER_CHOSEN_USERNAME, "test@localhost", "Firstname", "Lastname");
        UsersResource consumerUsers = this.adminClient.realm("consumer").users();
        int userCount = consumerUsers.count();
        Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
        boolean isUserFound = users.stream().anyMatch(user -> user.getUsername().equals(CONSUMER_CHOSEN_USERNAME) && user.getEmail().equals("test@localhost"));
        Assert.assertTrue((String)"There must be user mytest in realm consumer", (boolean)isUserFound);
        Assert.assertThat((Object)this.driver.findElement(By.tagName((String)"a")).getAttribute("id"), (Matcher)org.hamcrest.Matchers.containsString((String)"account"));
    }

    private String getSamlIdpInitiatedUrl(String realmName, String samlIdpInitiatedSsoUrlName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/protocol/saml/clients/" + samlIdpInitiatedSsoUrlName;
    }

    private String getSamlBrokerIdpInitiatedUrl(String realmName, String samlIdpInitiatedSsoUrlName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/broker/saml-leaf/endpoint/clients/" + samlIdpInitiatedSsoUrlName;
    }

    private String getSamlBrokerUrl(String realmName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/broker/saml-leaf/endpoint";
    }

    private void waitForPage(String title, boolean htmlTitle) {
        WebDriverWait wait = new WebDriverWait(this.driver, 5L);
        ExpectedCondition condition = input -> htmlTitle ? input.getTitle().toLowerCase().contains(title) : PageUtils.getPageTitle((WebDriver)input).toLowerCase().contains(title);
        wait.until((Function)condition);
    }

    private void assertAudience(ResponseType resp, String expectedAudience) throws Exception {
        AssertionType a = AssertionUtil.getAssertion(null, (ResponseType)resp, null);
        org.junit.Assert.assertThat((Object)a, (Matcher)org.hamcrest.Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)a.getConditions(), (Matcher)org.hamcrest.Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)a.getConditions().getConditions(), (Matcher)org.hamcrest.Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)a.getConditions().getConditions(), (Matcher)org.hamcrest.Matchers.hasSize((Matcher)org.hamcrest.Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        org.junit.Assert.assertThat(a.getConditions().getConditions().get(0), (Matcher)org.hamcrest.Matchers.instanceOf(AudienceRestrictionType.class));
        AudienceRestrictionType ar = (AudienceRestrictionType)a.getConditions().getConditions().get(0);
        org.junit.Assert.assertThat((Object)ar.getAudience(), (Matcher)org.hamcrest.Matchers.contains((Object[])new URI[]{URI.create(expectedAudience)}));
    }

    @Test
    public void testProviderIdpInitiatedLoginToApp() throws Exception {
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker")).login().user("test", "test").build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales"));
            return ob;
        })).build().updateProfile().username(CONSUMER_CHOSEN_USERNAME).email("test@localhost").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        org.junit.Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth")));
        this.assertAudience(resp, this.urlRealmConsumer + "/app/auth");
    }

    @Test
    public void testConsumerIdpInitiatedLoginToApp() throws Exception {
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.getSamlIdpInitiatedUrl("consumer", "sales")).login().idp("saml-leaf").build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user("test", "test").build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerUrl("consumer")));
            this.assertAudience(resp, this.urlRealmConsumer);
            return ob;
        })).build().updateProfile().username(CONSUMER_CHOSEN_USERNAME).email("test@localhost").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        org.junit.Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth")));
        this.assertAudience(resp, this.urlRealmConsumer + "/app/auth");
    }

    @Test
    public void testTwoConsequentIdpInitiatedLogins() throws Exception {
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker")).login().user("test", "test").build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales"));
            return ob;
        })).build().updateProfile().username(CONSUMER_CHOSEN_USERNAME).email("test@localhost").firstName("Firstname").lastName("Lastname").build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth")));
            this.assertAudience(resp, this.urlRealmConsumer + "/app/auth");
            return null;
        })).build().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker-2")).login().sso(true).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales2")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales2"));
            return ob;
        })).build().getSamlResponse(SamlClient.Binding.POST);
        org.junit.Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth2/saml")));
        this.assertAudience(resp, this.urlRealmConsumer + "/app/auth2");
        this.assertSingleUserSession("consumer", CONSUMER_CHOSEN_USERNAME, this.urlRealmConsumer + "/app/auth", this.urlRealmConsumer + "/app/auth2");
        this.assertSingleUserSession("provider", "test", this.urlRealmConsumer + "/broker/saml-leaf/endpoint/clients/sales", this.urlRealmConsumer + "/broker/saml-leaf/endpoint/clients/sales2");
    }

    @Test
    public void testProviderIdpInitiatedLoginWithPrincipalAttribute() throws Exception {
        IdentityProviderResource idp = this.adminClient.realm("consumer").identityProviders().get("saml-leaf");
        IdentityProviderRepresentation rep = idp.toRepresentation();
        rep.getConfig().put("principalType", SamlPrincipalType.ATTRIBUTE.name());
        rep.getConfig().put("principalAttribute", X500SAMLProfileConstants.UID.get());
        idp.update(rep);
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker")).login().user("test", "test").build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales"));
            Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
            AttributeStatementType attributeType = (AttributeStatementType)statements.stream().filter(statement -> statement instanceof AttributeStatementType).findFirst().orElse((StatementAbstractType)new AttributeStatementType());
            AttributeType attr = new AttributeType(X500SAMLProfileConstants.UID.get());
            attr.addAttributeValue((Object)"test");
            attributeType.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attributeType);
            return ob;
        })).build().updateProfile().username(CONSUMER_CHOSEN_USERNAME).email("test@localhost").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        org.junit.Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth")));
        this.assertAudience(resp, this.urlRealmConsumer + "/app/auth");
        UsersResource users = this.adminClient.realm("consumer").users();
        String id = ((UserRepresentation)users.search(CONSUMER_CHOSEN_USERNAME).get(0)).getId();
        FederatedIdentityRepresentation fed = (FederatedIdentityRepresentation)users.get(id).getFederatedIdentity().get(0);
        org.junit.Assert.assertThat((Object)fed.getUserId(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
        org.junit.Assert.assertThat((Object)fed.getUserName(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
    }

    @Test
    public void testProviderTransientIdpInitiatedLogin() throws Exception {
        IdentityProviderResource idp = this.adminClient.realm("consumer").identityProviders().get("saml-leaf");
        IdentityProviderRepresentation rep = idp.toRepresentation();
        rep.getConfig().put("nameIDPolicyFormat", JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get());
        rep.getConfig().put("principalType", SamlPrincipalType.ATTRIBUTE.name());
        rep.getConfig().put("principalAttribute", X500SAMLProfileConstants.UID.get());
        idp.update(rep);
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker")).login().user("test", "test").build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales"));
            NameIDType nameId = new NameIDType();
            nameId.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()));
            nameId.setValue("subjectId1");
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getSubject().getSubType().addBaseID((BaseIDAbstractType)nameId);
            Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
            AttributeStatementType attributeType = (AttributeStatementType)statements.stream().filter(statement -> statement instanceof AttributeStatementType).findFirst().orElse((StatementAbstractType)new AttributeStatementType());
            AttributeType attr = new AttributeType(X500SAMLProfileConstants.UID.get());
            attr.addAttributeValue((Object)"test");
            attributeType.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attributeType);
            return ob;
        })).build().navigateTo(this.getSamlIdpInitiatedUrl("provider", "samlbroker-2")).login().sso(true).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            org.junit.Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)this.getSamlBrokerIdpInitiatedUrl("consumer", "sales2")));
            this.assertAudience(resp, this.getSamlBrokerIdpInitiatedUrl("consumer", "sales2"));
            NameIDType nameId = new NameIDType();
            nameId.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()));
            nameId.setValue("subjectId2");
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getSubject().getSubType().addBaseID((BaseIDAbstractType)nameId);
            Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
            AttributeStatementType attributeType = (AttributeStatementType)statements.stream().filter(statement -> statement instanceof AttributeStatementType).findFirst().orElse((StatementAbstractType)new AttributeStatementType());
            AttributeType attr = new AttributeType(X500SAMLProfileConstants.UID.get());
            attr.addAttributeValue((Object)"test");
            attributeType.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attributeType);
            return ob;
        })).build().updateProfile().username(CONSUMER_CHOSEN_USERNAME).email("test@localhost").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        org.junit.Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        org.junit.Assert.assertThat((Object)resp.getDestination(), (Matcher)org.hamcrest.Matchers.is((Object)(this.urlRealmConsumer + "/app/auth2/saml")));
        this.assertAudience(resp, this.urlRealmConsumer + "/app/auth2");
        UsersResource users = this.adminClient.realm("consumer").users();
        List userList = users.search(CONSUMER_CHOSEN_USERNAME);
        org.junit.Assert.assertEquals((long)1L, (long)userList.size());
        String id = ((UserRepresentation)userList.get(0)).getId();
        FederatedIdentityRepresentation fed = (FederatedIdentityRepresentation)users.get(id).getFederatedIdentity().get(0);
        org.junit.Assert.assertThat((Object)fed.getUserId(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
        org.junit.Assert.assertThat((Object)fed.getUserName(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
        userList = users.search("subjectId1");
        org.junit.Assert.assertTrue((boolean)userList.isEmpty());
        userList = users.search("subjectId2");
        org.junit.Assert.assertTrue((boolean)userList.isEmpty());
    }

    private void assertSingleUserSession(String realmName, String userName, String ... expectedClientIds) {
        UsersResource users = this.adminClient.realm(realmName).users();
        ClientsResource clients = this.adminClient.realm(realmName).clients();
        UserRepresentation userRepresentation = (UserRepresentation)users.search(userName).stream().findFirst().get();
        List userSessions = users.get(userRepresentation.getId()).getUserSessions();
        org.junit.Assert.assertThat((Object)userSessions, (Matcher)org.hamcrest.Matchers.hasSize((int)1));
        Map clientSessions = ((UserSessionRepresentation)userSessions.get(0)).getClients();
        Set clientIds = clientSessions.values().stream().flatMap(c -> clients.findByClientId(c).stream()).map(ClientRepresentation::getClientId).collect(Collectors.toSet());
        org.junit.Assert.assertThat(clientIds, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])expectedClientIds));
    }
}

