/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class KcSamlDefaultIdpTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        RealmResource brokeredRealm = this.adminClient.realm(this.bc.providerRealmName());
        List clients = brokeredRealm.clients().findByClientId(this.bc.getIDPClientIdInProviderRealm());
        org.junit.Assert.assertEquals((long)1L, (long)clients.size());
        ClientRepresentation brokerApp = (ClientRepresentation)clients.get(0);
        brokerApp.setConsentRequired(Boolean.valueOf(true));
        brokeredRealm.clients().get(brokerApp.getId()).update(brokerApp);
    }

    @Test
    public void testDefaultIdpNotSet() {
        this.configureFlow(null);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the initial page and nothing should have happened", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
    }

    @Test
    public void testDefaultIdpSet() {
        this.configureFlow("kc-saml-idp");
        String username = "all-info-set@localhost.com";
        this.createUser(this.bc.providerRealmName(), username, "password", "FirstName");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
    }

    @Test
    public void testDefaultIdpSetTriedAndReturnedError() {
        this.configureFlow("kc-saml-idp");
        String username = "all-info-set@localhost.com";
        this.createUser(this.bc.providerRealmName(), username, "password", "FirstName");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.grantPage.assertCurrent();
        this.grantPage.cancel();
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        WebElement errorElement = this.driver.findElement(By.className((String)"alert-error"));
        org.junit.Assert.assertNotNull((String)"Page should show an error message but it's missing", (Object)errorElement);
        org.junit.Assert.assertEquals((Object)"Unexpected error when authenticating with identity provider", (Object)UIUtils.getTextFromElement((WebElement)errorElement));
    }

    private void configureFlow(String defaultIdpValue) {
        String newFlowAlias;
        HashMap<String, String> defaultIdpConfig = new HashMap<String, String>();
        if (defaultIdpValue != null && !defaultIdpValue.isEmpty()) {
            defaultIdpConfig.put("defaultProvider", defaultIdpValue);
            newFlowAlias = "Browser - Default IdP " + defaultIdpValue;
        } else {
            newFlowAlias = "Browser - Default IdP OFF";
        }
        this.testingClient.server("consumer").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("consumer").run((RunOnServer & Serializable)session -> {
            List<AuthenticationExecutionModel> executions = FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).getExecutions();
            int index = IntStream.range(0, executions.size()).filter(t -> "identity-provider-redirector".equals(((AuthenticationExecutionModel)executions.get(t)).getAuthenticator())).findFirst().orElse(-1);
            org.junit.Assert.assertTrue((String)"Identity Provider Redirector execution not found", (index >= 0 ? 1 : 0) != 0);
            FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).updateExecution(index, config -> {
                AuthenticatorConfigModel authConfig = new AuthenticatorConfigModel();
                authConfig.setId(UUID.randomUUID().toString());
                authConfig.setAlias("cfg" + authConfig.getId().hashCode());
                authConfig.setConfig((Map)defaultIdpConfig);
                session.getContext().getRealm().addAuthenticatorConfig(authConfig);
                config.setAuthenticatorConfig(authConfig.getId());
            }).defineAsBrowserFlow();
        });
    }

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlBrokerConfiguration();
    }
}

