/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.broker.AbstractAdvancedBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.SamlStreams;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class KcSamlBrokerTest
extends AbstractAdvancedBrokerTest {
    private static final String EMPTY_ATTRIBUTE_NAME = "empty.attribute.name";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Override
    protected Iterable<IdentityProviderMapperRepresentation> createIdentityProviderMappers(IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation attrMapper1 = new IdentityProviderMapperRepresentation();
        attrMapper1.setName("manager-role-mapper");
        attrMapper1.setIdentityProviderMapper("saml-role-idp-mapper");
        attrMapper1.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"manager").put((Object)"role", (Object)"manager").build());
        IdentityProviderMapperRepresentation attrMapper2 = new IdentityProviderMapperRepresentation();
        attrMapper2.setName("user-role-mapper");
        attrMapper2.setIdentityProviderMapper("saml-role-idp-mapper");
        attrMapper2.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"user").put((Object)"role", (Object)"user").build());
        IdentityProviderMapperRepresentation attrMapper3 = new IdentityProviderMapperRepresentation();
        attrMapper3.setName("friendly-mapper");
        attrMapper3.setIdentityProviderMapper("saml-role-idp-mapper");
        attrMapper3.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.friendly.name", (Object)"user-attribute-friendly").put((Object)"attribute.value", (Object)"friendly-manager").put((Object)"role", (Object)"friendly-manager").build());
        IdentityProviderMapperRepresentation attrMapper4 = new IdentityProviderMapperRepresentation();
        attrMapper4.setName("user-role-dot-guide-mapper");
        attrMapper4.setIdentityProviderMapper("saml-role-idp-mapper");
        attrMapper4.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"user.guide").put((Object)"role", (Object)"user.guide").build());
        IdentityProviderMapperRepresentation attrMapper5 = new IdentityProviderMapperRepresentation();
        attrMapper5.setName("empty-attribute-to-role-mapper");
        attrMapper5.setIdentityProviderMapper("saml-role-idp-mapper");
        attrMapper5.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)EMPTY_ATTRIBUTE_NAME).put((Object)"attribute.value", (Object)"").put((Object)"role", (Object)"empty.attribute.role").build());
        return Arrays.asList(attrMapper1, attrMapper2, attrMapper3, attrMapper4, attrMapper5);
    }

    @Override
    protected void createAdditionalMapperWithCustomSyncMode(IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation friendlyManagerMapper = new IdentityProviderMapperRepresentation();
        friendlyManagerMapper.setName("friendly-manager-role-mapper");
        friendlyManagerMapper.setIdentityProviderMapper("saml-role-idp-mapper");
        friendlyManagerMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attribute.name", (Object)"Role").put((Object)"attribute.value", (Object)"friendly-manager").put((Object)"role", (Object)"friendly-manager").build());
        friendlyManagerMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderResource idpResource = realm.identityProviders().get(this.bc.getIDPAlias());
        idpResource.addMapper(friendlyManagerMapper).close();
    }

    @Test
    public void mapperUpdatesRolesOnEveryLogInForLegacyMode() {
        this.createRolesForRealm(this.bc.providerRealmName());
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm(IdentityProviderMapperSyncMode.FORCE);
        RoleRepresentation managerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("manager").toRepresentation();
        RoleRepresentation friendlyManagerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("friendly-manager").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
        UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResource.roles().realmLevel().add(Collections.singletonList(managerRole));
        this.logInAsUserInIDPForFirstTime();
        Set currentRoles = userResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager"}));
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"user", "friendly-manager"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        userResource.roles().realmLevel().add(Collections.singletonList(userRole));
        userResource.roles().realmLevel().add(Collections.singletonList(friendlyManagerRole));
        this.logInAsUserInIDP();
        currentRoles = userResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager", "user", "friendly-manager"}));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        userResource.roles().realmLevel().remove(Collections.singletonList(friendlyManagerRole));
        this.logInAsUserInIDP();
        currentRoles = userResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager", "user"}));
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"friendly-manager"})));
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
    }

    @Test
    public void roleWithDots() {
        this.createRolesForRealm(this.bc.providerRealmName());
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm();
        RoleRepresentation managerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("manager").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
        RoleRepresentation userRoleDotGuide = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user.guide").toRepresentation();
        UserResource userResourceProv = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResourceProv.roles().realmLevel().add(Collections.singletonList(managerRole));
        this.logInAsUserInIDPForFirstTime();
        String consUserId = ((UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserLogin()).iterator().next()).getId();
        UserResource userResourceCons = this.adminClient.realm(this.bc.consumerRealmName()).users().get(consUserId);
        Set currentRoles = userResourceCons.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager"}));
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"user", "friendly-manager", "user.guide"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        UserRepresentation urp = userResourceProv.toRepresentation();
        urp.setAttributes(new HashMap());
        urp.getAttributes().put("user-attribute-friendly", Collections.singletonList("friendly-manager"));
        userResourceProv.update(urp);
        userResourceProv.roles().realmLevel().add(Collections.singletonList(userRole));
        userResourceProv.roles().realmLevel().add(Collections.singletonList(userRoleDotGuide));
        this.logInAsUserInIDP();
        currentRoles = userResourceCons.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager", "user", "user.guide", "friendly-manager"}));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        urp = userResourceProv.toRepresentation();
        urp.setAttributes(new HashMap());
        userResourceProv.update(urp);
        this.logInAsUserInIDP();
        currentRoles = userResourceCons.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager", "user", "user.guide"}));
        Assert.assertThat(currentRoles, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"friendly-manager"})));
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
    }

    @Test
    public void loginClientWithDotsInName() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        SAMLDocumentHolder samlResponse = new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).username(this.bc.getUserLogin()).build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
    }

    @Test
    public void emptyAttributeToRoleMapperTest() throws ParsingException, ConfigurationException, ProcessingException {
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm();
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType resp = (ResponseType)ob;
            Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
            AttributeStatementType attributeType = (AttributeStatementType)statements.stream().filter(statement -> statement instanceof AttributeStatementType).findFirst().orElse((StatementAbstractType)new AttributeStatementType());
            AttributeType attr = new AttributeType(EMPTY_ATTRIBUTE_NAME);
            attr.addAttributeValue(null);
            attributeType.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
            ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)attributeType);
            return ob;
        })).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).username(this.bc.getUserLogin()).build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        Stream assertionTypeStream = SamlStreams.assertionsUnencrypted((SAML2Object)samlResponse.getSamlObject());
        Stream attributeStatementTypeStream = SamlStreams.attributesUnecrypted((Stream)SamlStreams.attributeStatements((Stream)assertionTypeStream));
        Set attributeValues = attributeStatementTypeStream.filter(a -> a.getName().equals("Role")).flatMap(a -> a.getAttributeValue().stream()).map(Object::toString).collect(Collectors.toSet());
        Assert.assertThat(attributeValues, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"empty.attribute.role"}));
    }

    @Test
    public void loginInResponseToMismatch() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(this::tamperInResponseTo)).build().execute(hr -> Assert.assertThat((Object)hr, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST)));
    }

    @Test
    public void loginInResponseToMissing() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(this::removeInResponseTo)).build().execute(hr -> Assert.assertThat((Object)hr, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST)));
    }

    @Test
    public void loginInResponseToEmpty() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(this::clearInResponseTo)).build().execute(hr -> Assert.assertThat((Object)hr, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST)));
    }

    private Document tamperInResponseTo(Document orig) {
        Element rootElement = orig.getDocumentElement();
        rootElement.setAttribute(SAMLProtocolQNames.ATTR_IN_RESPONSE_TO.getQName().getLocalPart(), "TAMPERED_" + rootElement.getAttribute("InResponseTo"));
        return orig;
    }

    private Document removeInResponseTo(Document orig) {
        Element rootElement = orig.getDocumentElement();
        rootElement.removeAttribute(SAMLProtocolQNames.ATTR_IN_RESPONSE_TO.getQName().getLocalPart());
        return orig;
    }

    private Document clearInResponseTo(Document orig) {
        Element rootElement = orig.getDocumentElement();
        rootElement.setAttribute(SAMLProtocolQNames.ATTR_IN_RESPONSE_TO.getQName().getLocalPart(), "");
        return orig;
    }
}

