/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class KcSamlBrokerSessionNotOnOrAfterTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testConsumerIdpInitiatedLoginContainsSessionNotOnOrAfter() throws Exception {
        SAMLDocumentHolder samlResponse = new SamlClientBuilder().idpInitiatedLogin(this.getConsumerSamlEndpoint("consumer"), "sales-post").build().login().idp("kc-saml-idp").build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user("testuser", "password").build().processSamlResponse(SamlClient.Binding.POST).build().updateProfile().username("testuser").email("user@localhost.com").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)samlResponse.getSamlObject();
        Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
        AuthnStatementType authType = statements.stream().filter(statement -> statement instanceof AuthnStatementType).map(s -> (AuthnStatementType)s).findFirst().orElse(null);
        Assert.assertThat((Object)authType, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.is((Object)XMLTimeUtil.add((XMLGregorianCalendar)authType.getAuthnInstant(), (long)(this.adminClient.realm("consumer").toRepresentation().getSsoSessionMaxLifespan() * 1000))));
    }
}

