/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Closeable;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class KcSamlAttributeConsumingServiceIndexTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testAttributeConsumingServiceIndexNotSet() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Node attrNode = document.getDocumentElement().getAttributes().getNamedItem("AttributeConsumingServiceIndex");
                    Assert.assertEquals((String)"Unexpected AttributeConsumingServiceIndex attribute value", null, (Object)attrNode);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    @Test
    public void testAttributeConsumingServiceIndexSet() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("attributeConsumingServiceIndex", "15").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    String attrValue = document.getDocumentElement().getAttributes().getNamedItem("AttributeConsumingServiceIndex").getNodeValue();
                    Assert.assertEquals((String)"Unexpected AttributeConsumingServiceIndex attribute value", (Object)"15", (Object)attrValue);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }
}

