/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.util.ExecutionBuilder;

public class KcOidcFirstBrokerLoginDetectExistingUserTest
extends AbstractInitializedBaseBrokerTest {
    @Page
    protected LoginUpdateProfilePage loginUpdateProfilePage;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Override
    @Before
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        this.log.debug((Object)("creating detect existing user flow for realm " + this.bc.providerRealmName()));
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        AuthenticationManagementResource authMgmtResource = consumerRealm.flows();
        String detectExistingFlowAlias = "detectExistingUserFlow";
        AuthenticationFlowRepresentation authenticationFlowRepresentation = this.newFlow(detectExistingFlowAlias, detectExistingFlowAlias, "basic-flow", true, false);
        authMgmtResource.createFlow(authenticationFlowRepresentation);
        AuthenticationFlowRepresentation authenticationFlowRepresentation1 = this.getFlow(authMgmtResource, detectExistingFlowAlias);
        Assert.assertNotNull((String)"The authentication flow must exist", (Object)authenticationFlowRepresentation1);
        String flowId = authenticationFlowRepresentation1.getId();
        this.addExecution(authMgmtResource, flowId, "idp-detect-existing-broker-user", 10);
        this.addExecution(authMgmtResource, flowId, "idp-auto-link", 20);
        IdentityProviderResource identityConsumerResource = consumerRealm.identityProviders().get(this.bc.getIDPAlias());
        IdentityProviderRepresentation identityProviderRepresentation = (IdentityProviderRepresentation)consumerRealm.identityProviders().findAll().get(0);
        identityProviderRepresentation.setFirstBrokerLoginFlowAlias(detectExistingFlowAlias);
        identityProviderRepresentation.getConfig().put("syncMode", IdentityProviderSyncMode.FORCE.toString());
        identityConsumerResource.update(identityProviderRepresentation);
        Assert.assertEquals((String)"Two executions must have been created", (long)2L, (long)this.getFlow(authMgmtResource, detectExistingFlowAlias).getAuthenticationExecutions().size());
    }

    private void addExecution(AuthenticationManagementResource authMgmtResource, String flowId, String providerId, int priority) {
        AuthenticationExecutionRepresentation exec = ExecutionBuilder.create().parentFlow(flowId).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString()).authenticator(providerId).priority(priority).authenticatorFlow(false).build();
        authMgmtResource.addExecution(exec);
    }

    private AuthenticationFlowRepresentation getFlow(AuthenticationManagementResource authMgmtResource, String detectExistingFlowAlias) {
        return authMgmtResource.getFlows().stream().filter(v -> detectExistingFlowAlias.equals(v.getAlias())).findFirst().get();
    }

    private AuthenticationFlowRepresentation newFlow(String alias, String description, String providerId, boolean topLevel, boolean builtIn) {
        AuthenticationFlowRepresentation flow = new AuthenticationFlowRepresentation();
        flow.setAlias(alias);
        flow.setDescription(description);
        flow.setProviderId(providerId);
        flow.setTopLevel(topLevel);
        flow.setBuiltIn(builtIn);
        return flow;
    }

    @Test
    public void loginWhenUserDoesNotExistOnConsumer() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String firstname = "Firstname";
        String lastname = "Lastname";
        String username = "firstandlastname";
        this.createUser(this.bc.providerRealmName(), username, "password", firstname, lastname, "firstnamelastname@example.org");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithIdp(this.bc.getIDPAlias(), username, "password");
        this.loginPage.assertCurrent(this.bc.consumerRealmName());
        Assert.assertEquals((Object)("User " + username + " authenticated with identity provider " + this.bc.getIDPAlias() + " does not exists. Please contact your administrator."), (Object)this.loginPage.getInstruction());
    }

    @Test
    public void loginWhenUserExistsOnConsumer() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String firstname = "Firstname(loginWhenUserExistsOnConsumer)";
        String lastname = "Lastname(loginWhenUserExistsOnConsumer)";
        String username = "firstandlastname";
        String email = "firstnamelastname@example.org";
        this.createUser(this.bc.providerRealmName(), "firstandlastname", "password", "Firstname(loginWhenUserExistsOnConsumer)", "Lastname(loginWhenUserExistsOnConsumer)", "firstnamelastname@example.org");
        this.createUser(this.bc.consumerRealmName(), "firstandlastname", "THIS PASSWORD IS USELESS", (String)null, (String)null, "firstnamelastname@example.org");
        String accountUrl = this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.getLogger().error((Object)("> LOG INTO " + accountUrl));
        this.driver.navigate().to(accountUrl);
        this.logInWithIdp(this.bc.getIDPAlias(), "firstandlastname", "password");
        Assert.assertTrue((boolean)this.driver.getTitle().contains("Account Management"));
        Assert.assertTrue((String)"email must be in the page", (boolean)this.driver.getPageSource().contains("value=\"firstnamelastname@example.org\""));
        Assert.assertTrue((String)"firstname must appear in the page", (boolean)this.driver.getPageSource().contains("value=\"Firstname(loginWhenUserExistsOnConsumer)\""));
        Assert.assertTrue((String)"lastname must appear in the page", (boolean)this.driver.getPageSource().contains("value=\"Lastname(loginWhenUserExistsOnConsumer)\""));
    }
}

