/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractAdvancedBrokerTest;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ProtocolMapperUtil;
import org.keycloak.testsuite.util.WaitUtils;

public final class KcOidcBrokerTest
extends AbstractAdvancedBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Override
    protected Iterable<IdentityProviderMapperRepresentation> createIdentityProviderMappers(IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation attrMapper1 = new IdentityProviderMapperRepresentation();
        attrMapper1.setName("manager-role-mapper");
        attrMapper1.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
        attrMapper1.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"external.role", (Object)"manager").put((Object)"role", (Object)"manager").build());
        IdentityProviderMapperRepresentation attrMapper2 = new IdentityProviderMapperRepresentation();
        attrMapper2.setName("user-role-mapper");
        attrMapper2.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
        attrMapper2.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"external.role", (Object)"user").put((Object)"role", (Object)"user").build());
        return Lists.newArrayList((Object[])new IdentityProviderMapperRepresentation[]{attrMapper1, attrMapper2});
    }

    @Override
    protected void createAdditionalMapperWithCustomSyncMode(IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation friendlyManagerMapper = new IdentityProviderMapperRepresentation();
        friendlyManagerMapper.setName("friendly-manager-role-mapper");
        friendlyManagerMapper.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
        friendlyManagerMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"external.role", (Object)"friendly-manager").put((Object)"role", (Object)"friendly-manager").build());
        friendlyManagerMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        IdentityProviderResource idpResource = realm.identityProviders().get(this.bc.getIDPAlias());
        idpResource.addMapper(friendlyManagerMapper).close();
    }

    @Test
    public void mapperDoesNothingForLegacyMode() {
        this.createRolesForRealm(this.bc.providerRealmName());
        this.createRolesForRealm(this.bc.consumerRealmName());
        this.createRoleMappersForConsumerRealm(IdentityProviderMapperSyncMode.LEGACY);
        RoleRepresentation managerRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("manager").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realm(this.bc.providerRealmName()).roles().get("user").toRepresentation();
        UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResource.roles().realmLevel().add(Collections.singletonList(managerRole));
        this.logInAsUserInIDPForFirstTime();
        UserResource consumerUserResource = this.adminClient.realm(this.bc.consumerRealmName()).users().get(((UserRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).users().search(this.bc.getUserLogin()).get(0)).getId());
        Set currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager"}));
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        userResource.roles().realmLevel().add(Collections.singletonList(userRole));
        this.logInAsUserInIDP();
        currentRoles = consumerUserResource.roles().realmLevel().listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.hasItems((Object[])new String[]{"manager"}));
        org.junit.Assert.assertThat(currentRoles, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new String[]{"user"})));
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginFetchingUserFromUserEndpoint() {
        RealmResource realm = this.realmsResouce().realm(this.bc.providerRealmName());
        ClientsResource clients = realm.clients();
        ClientRepresentation brokerApp = (ClientRepresentation)clients.findByClientId("brokerapp").get(0);
        try {
            IdentityProviderResource identityProviderResource = this.realmsResouce().realm(this.bc.consumerRealmName()).identityProviders().get(this.bc.getIDPAlias());
            IdentityProviderRepresentation idp = identityProviderResource.toRepresentation();
            idp.getConfig().put("jwksUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/certs");
            identityProviderResource.update(idp);
            brokerApp.getAttributes().put("user.info.response.signature.alg", "RS256");
            brokerApp.getAttributes().put("validateSignature", Boolean.TRUE.toString());
            clients.get(brokerApp.getId()).update(brokerApp);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "update account information", false);
            this.updateAccountInformationPage.assertCurrent();
            Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
            this.log.debug((Object)"Updating info on updateAccount page");
            this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
            UsersResource consumerUsers = this.adminClient.realm(this.bc.consumerRealmName()).users();
            int userCount = consumerUsers.count();
            Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
            List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
            boolean isUserFound = false;
            for (UserRepresentation user : users) {
                if (!user.getUsername().equals(this.bc.getUserLogin()) || !user.getEmail().equals(this.bc.getUserEmail())) continue;
                isUserFound = true;
                break;
            }
            Assert.assertTrue((String)("There must be user " + this.bc.getUserLogin() + " in realm " + this.bc.consumerRealmName()), (boolean)isUserFound);
        }
        finally {
            brokerApp.getAttributes().put("user.info.response.signature.alg", null);
            brokerApp.getAttributes().put("validateSignature", Boolean.FALSE.toString());
            clients.get(brokerApp.getId()).update(brokerApp);
        }
    }

    @Test
    public void loginFetchingUserFromUserEndpointWithClaimMapper() {
        RealmResource realm = this.realmsResouce().realm(this.bc.providerRealmName());
        ClientsResource clients = realm.clients();
        ClientRepresentation brokerApp = (ClientRepresentation)clients.findByClientId("brokerapp").get(0);
        IdentityProviderResource identityProviderResource = this.getIdentityProviderResource();
        clients.get(brokerApp.getId()).getProtocolMappers().createMapper(ProtocolMapperUtil.createHardcodedClaim("hard-coded", "hard-coded", "hard-coded", "String", true, true)).close();
        IdentityProviderMapperRepresentation hardCodedSessionNoteMapper = new IdentityProviderMapperRepresentation();
        hardCodedSessionNoteMapper.setName("hard-coded");
        hardCodedSessionNoteMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        hardCodedSessionNoteMapper.setIdentityProviderMapper("oidc-user-attribute-idp-mapper");
        hardCodedSessionNoteMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)IdentityProviderMapperSyncMode.INHERIT.toString()).put((Object)"user.attribute", (Object)"hard-coded").put((Object)"claim", (Object)"hard-coded").build());
        identityProviderResource.addMapper(hardCodedSessionNoteMapper).close();
        this.loginFetchingUserFromUserEndpoint();
        UserRepresentation user = this.getFederatedIdentity();
        Assert.assertEquals((long)1L, (long)user.getAttributes().size());
        Assert.assertEquals((Object)"hard-coded", ((List)user.getAttributes().get("hard-coded")).get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReauthenticationSamlBrokerWithOTPRequired() throws Exception {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(samlBrokerConfig.getIDPAlias()));
            this.logInWithBroker(samlBrokerConfig);
            this.totpPage.assertCurrent();
            String totpSecret = this.totpPage.getTotpSecret();
            this.totpPage.configure(this.totp.generateTOTP(totpSecret));
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            this.idpConfirmLinkPage.assertCurrent();
            this.idpConfirmLinkPage.clickLinkAccount();
            this.loginPage.clickSocial(samlBrokerConfig.getIDPAlias());
            BrokerTestTools.waitForPage(this.driver, "sign in to", true);
            this.log.debug((Object)"Logging in");
            this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 2);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReauthenticationOIDCBrokerWithOTPRequired() throws Exception {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(samlBrokerConfig);
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(this.bc.getIDPAlias()));
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            this.idpConfirmLinkPage.assertCurrent();
            this.idpConfirmLinkPage.clickLinkAccount();
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.driver.navigate().back();
            this.logInWithBroker(samlBrokerConfig);
            this.totpPage.assertCurrent();
            String totpSecret = this.totpPage.getTotpSecret();
            this.totpPage.configure(this.totp.generateTOTP(totpSecret));
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 2);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReauthenticationBothBrokersWithOTPRequired() throws Exception {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(samlBrokerConfig.getIDPAlias()));
            this.logInWithBroker(samlBrokerConfig);
            this.totpPage.assertCurrent();
            String totpSecret = this.totpPage.getTotpSecret();
            this.totpPage.configure(this.totp.generateTOTP(totpSecret));
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.testingClient.server(this.bc.consumerRealmName()).run(BrokerRunOnServerUtil.configurePostBrokerLoginWithOTP(this.bc.getIDPAlias()));
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            this.idpConfirmLinkPage.assertCurrent();
            this.idpConfirmLinkPage.clickLinkAccount();
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.driver.navigate().back();
            this.logInWithBroker(samlBrokerConfig);
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 2);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    @Test
    public void testInvalidIssuedFor() {
        this.loginUser();
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        RealmResource realm = this.adminClient.realm(this.bc.providerRealmName());
        ClientRepresentation rep = (ClientRepresentation)realm.clients().findByClientId("brokerapp").get(0);
        ClientResource clientResource = realm.clients().get(rep.getId());
        ProtocolMapperRepresentation hardCodedAzp = ProtocolMapperUtil.createHardcodedClaim("hard", "azp", "invalid-azp", "String", true, true);
        clientResource.getProtocolMappers().createMapper(hardCodedAzp);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.errorPage.assertCurrent();
    }

    @Test
    public void testInvalidAudience() {
        this.loginUser();
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        RealmResource realm = this.adminClient.realm(this.bc.providerRealmName());
        ClientRepresentation rep = (ClientRepresentation)realm.clients().findByClientId("brokerapp").get(0);
        ClientResource clientResource = realm.clients().get(rep.getId());
        ProtocolMapperRepresentation hardCodedAzp = ProtocolMapperUtil.createHardcodedClaim("hard", "aud", "invalid-aud", "List", true, true);
        clientResource.getProtocolMappers().createMapper(hardCodedAzp);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.errorPage.assertCurrent();
    }

    @Test
    public void testIdPNotFound() {
        String notExistingIdP = "not-exists";
        String realmName = Optional.ofNullable(this.realmsResouce().realm(this.bc.providerRealmName()).toRepresentation().getRealm()).orElse(null);
        org.junit.Assert.assertThat((Object)realmName, (Matcher)Matchers.notNullValue());
        String LINK = OAuthClient.AUTH_SERVER_ROOT + "/realms/" + realmName + "/broker/" + "not-exists" + "/endpoint";
        this.driver.navigate().to(LINK);
        this.errorPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.errorPage.getError(), (Matcher)Matchers.is((Object)"Page not found"));
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            SimpleHttp.Response simple = SimpleHttp.doGet((String)LINK, (HttpClient)client).asResponse();
            org.junit.Assert.assertThat((Object)simple, (Matcher)Matchers.notNullValue());
            org.junit.Assert.assertThat((Object)simple.getStatus(), (Matcher)Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
            OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)simple.asJson(OAuth2ErrorRepresentation.class);
            org.junit.Assert.assertThat((Object)error, (Matcher)Matchers.notNullValue());
            org.junit.Assert.assertThat((Object)error.getError(), (Matcher)Matchers.is((Object)"Identity Provider [not-exists] not found."));
        }
        catch (IOException ex) {
            Assert.fail((String)("Cannot create HTTP client. Details: " + ex.getMessage()));
        }
    }

    @Test
    public void testIdPForceSyncUserAttributes() {
        this.checkUpdatedUserAttributesIdP(true);
    }

    @Test
    public void testIdPNotForceSyncUserAttributes() {
        this.checkUpdatedUserAttributesIdP(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdatedUserAttributesIdP(boolean isForceSync) {
        String IDP_NAME = this.getBrokerConfiguration().getIDPAlias();
        String USERNAME = "demoUser";
        String FIRST_NAME = "John";
        String LAST_NAME = "Doe";
        String EMAIL = "mail@example.com";
        String NEW_FIRST_NAME = "Jack";
        String NEW_LAST_NAME = "Doee";
        String NEW_EMAIL = "mail123@example.com";
        UsersResource providerUserResource = Optional.ofNullable(this.realmsResouce().realm(this.bc.providerRealmName()).users()).orElse(null);
        org.junit.Assert.assertThat((String)"Cannot get User Resource from Provider realm", (Object)providerUserResource, (Matcher)Matchers.notNullValue());
        String userID = this.createUser(this.bc.providerRealmName(), "demoUser", "demoUser", "John", "Doe", "mail@example.com");
        org.junit.Assert.assertThat((String)"Cannot create user : demoUser", (Object)userID, (Matcher)Matchers.notNullValue());
        try {
            UserRepresentation user = Optional.ofNullable(providerUserResource.get(userID).toRepresentation()).orElse(null);
            org.junit.Assert.assertThat((String)"Cannot get user from provider", (Object)user, (Matcher)Matchers.notNullValue());
            IdentityProviderResource consumerIdentityResource = Optional.ofNullable(this.getIdentityProviderResource()).orElse(null);
            org.junit.Assert.assertThat((String)"Cannot get Identity Provider resource", (Object)consumerIdentityResource, (Matcher)Matchers.notNullValue());
            IdentityProviderRepresentation idProvider = Optional.ofNullable(consumerIdentityResource.toRepresentation()).orElse(null);
            org.junit.Assert.assertThat((String)"Cannot get Identity Provider", (Object)idProvider, (Matcher)Matchers.notNullValue());
            this.updateIdPSyncMode(idProvider, consumerIdentityResource, isForceSync ? IdentityProviderSyncMode.FORCE : IdentityProviderSyncMode.IMPORT);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            WaitUtils.waitForPageToLoad();
            org.junit.Assert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.containsString((String)("Sign in to " + this.bc.consumerRealmName())));
            this.logInWithIdp(IDP_NAME, "demoUser", "demoUser");
            this.accountUpdateProfilePage.assertCurrent();
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName()));
            WaitUtils.waitForPageToLoad();
            org.junit.Assert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.containsString((String)("Sign in to " + this.bc.providerRealmName())));
            this.loginPage.login("demoUser", "demoUser");
            WaitUtils.waitForPageToLoad();
            this.accountUpdateProfilePage.assertCurrent();
            this.accountUpdateProfilePage.updateProfile("Jack", "Doee", "mail123@example.com");
            this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            WaitUtils.waitForPageToLoad();
            org.junit.Assert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.containsString((String)("Sign in to " + this.bc.consumerRealmName())));
            this.logInWithIdp(IDP_NAME, "demoUser", "demoUser");
            this.accountUpdateProfilePage.assertCurrent();
            org.junit.Assert.assertThat((Object)this.accountUpdateProfilePage.getEmail(), (Matcher)Matchers.equalTo((Object)(isForceSync ? "mail123@example.com" : "mail@example.com")));
            org.junit.Assert.assertThat((Object)this.accountUpdateProfilePage.getFirstName(), (Matcher)Matchers.equalTo((Object)(isForceSync ? "Jack" : "John")));
            org.junit.Assert.assertThat((Object)this.accountUpdateProfilePage.getLastName(), (Matcher)Matchers.equalTo((Object)(isForceSync ? "Doee" : "Doe")));
        }
        finally {
            providerUserResource.delete(userID);
            org.junit.Assert.assertThat((String)"User wasn't deleted", (Object)providerUserResource.search("demoUser").size(), (Matcher)Matchers.is((Object)0));
        }
    }

    private void updateIdPSyncMode(IdentityProviderRepresentation idProvider, IdentityProviderResource idProviderResource, IdentityProviderSyncMode syncMode) {
        org.junit.Assert.assertThat((Object)idProvider, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)idProviderResource, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((Object)syncMode, (Matcher)Matchers.notNullValue());
        if (((String)idProvider.getConfig().get("syncMode")).equals(syncMode.name())) {
            return;
        }
        idProvider.getConfig().put("syncMode", syncMode.name());
        idProviderResource.update(idProvider);
        idProvider = Optional.ofNullable(idProviderResource.toRepresentation()).orElse(null);
        org.junit.Assert.assertThat((String)"Cannot get Identity Provider", (Object)idProvider, (Matcher)Matchers.notNullValue());
        org.junit.Assert.assertThat((String)"Sync mode didn't change", idProvider.getConfig().get("syncMode"), (Matcher)Matchers.equalTo((Object)syncMode.name()));
    }

    private UserRepresentation getFederatedIdentity() {
        List users = this.realmsResouce().realm(this.bc.consumerRealmName()).users().search(this.bc.getUserLogin());
        Assert.assertEquals((long)1L, (long)users.size());
        return (UserRepresentation)users.get(0);
    }

    private IdentityProviderResource getIdentityProviderResource() {
        return this.realmsResouce().realm(this.bc.consumerRealmName()).identityProviders().get(this.bc.getIDPAlias());
    }
}

